/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.util.EnumSet;
import java.util.Map;
import java.util.StringJoiner;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;

public class DptXlator16BitSet
extends DPTXlator {
    public static final EnumDpt<RhccStatus> DptRhccStatus = new EnumDpt<RhccStatus>("22.101", RhccStatus.class);
    public static final EnumDpt<Medium> DptMedia = new EnumDpt<Medium>("22.1000", Medium.class);
    private static final Map<String, DPT> types = DptXlator16BitSet.loadDatapointTypes(DptXlator16BitSet.class);

    public DptXlator16BitSet(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DptXlator16BitSet(String dptId) throws KNXFormatException {
        super(2);
        this.setTypeID(types, dptId);
    }

    @Override
    public String getValue() {
        return this.textOf(0);
    }

    public final void setValue(int value) throws KNXFormatException {
        this.data = this.toDpt(value);
    }

    public final void setValue(EnumSet<?> elements) {
        this.data = DptXlator16BitSet.toDpt(elements);
    }

    @Override
    public final double getNumericValue() throws KNXFormatException {
        return this.fromDpt(0);
    }

    @Override
    public String[] getAllValues() {
        int items = this.getItems();
        String[] s = new String[items];
        for (int i = 0; i < items; ++i) {
            s[i] = this.textOf(i);
        }
        return s;
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private String textOf(int index) {
        int offset = 2 * index;
        int d = this.data[offset] << 8 | this.data[offset + 1];
        StringJoiner joiner = new StringJoiner(", ");
        for (int i = 16384; i > 0; i >>= 1) {
            if ((d & i) != i) continue;
            joiner.add(((EnumDpt)this.dpt).friendly(i));
        }
        if (this.dpt.equals(DptRhccStatus) && joiner.length() == 0) {
            return "Cooling Mode";
        }
        return joiner.toString();
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        int result = 0;
        try {
            result = Integer.decode(value);
            this.validate(result);
        }
        catch (NumberFormatException nfe) {
            String[] split;
            String regex;
            EnumDpt enumDpt = (EnumDpt)this.dpt;
            String string = regex = value.contains(",") ? "," : " ";
            if ("Cooling Mode".equals(value) || enumDpt.find(value) != null) {
                regex = ",";
            }
            if ((split = value.split(regex, 0)).length == 1 && "".equals(split[0])) {
                return;
            }
            for (int i = 0; i < split.length; ++i) {
                int bit;
                String s = split[split.length - 1 - i].trim();
                int n = "1".equals(s) || "true".equalsIgnoreCase(s) ? 1 : (bit = "0".equals(s) || "false".equalsIgnoreCase(s) ? 0 : -1);
                if (bit == 1) {
                    result |= bit << i;
                    continue;
                }
                if (bit != -1 || this.dpt.equals(DptRhccStatus) && "Cooling Mode".equals(s)) continue;
                Object e = enumDpt.find(s);
                if (e == null) {
                    throw this.newException("value is no element of " + enumDpt.elements.getSimpleName(), s);
                }
                result |= 1 << ((Enum)e).ordinal();
            }
        }
        int offset = 2 * index;
        dst[offset] = (short)(result >> 8);
        dst[offset + 1] = DptXlator16BitSet.ubyte(result);
    }

    private static short[] toDpt(EnumSet<?> elements) {
        int v = 0;
        for (Enum e : elements) {
            v |= 1 << e.ordinal();
        }
        return new short[]{(short)(v >> 8), DptXlator16BitSet.ubyte(v)};
    }

    private short[] toDpt(int value) throws KNXFormatException {
        this.validate(value);
        return new short[]{(short)(value >> 8), DptXlator16BitSet.ubyte(value)};
    }

    private int fromDpt(int index) throws KNXFormatException {
        int offset = 2 * index;
        int v = this.data[offset] << 8 | this.data[offset + 1];
        this.validate(v);
        return v;
    }

    private void validate(int value) throws KNXFormatException {
        EnumDpt enumDpt = (EnumDpt)this.dpt;
        if (value < 0 || value > DptXlator16BitSet.maxValue(enumDpt.elements)) {
            throw this.newException("value is out of range [" + enumDpt.getLowerValue() + ".." + enumDpt.getUpperValue() + "]", Integer.toString(value));
        }
    }

    private static <E extends Enum<E>> int maxValue(Class<E> elements) {
        int bits = EnumSet.allOf(elements).size();
        return (1 << bits) - 1;
    }

    public static class EnumDpt<T extends Enum<T>>
    extends DPT {
        private final Class<T> elements;

        public EnumDpt(String typeId, Class<T> elements) {
            this(typeId, elements.getSimpleName().replaceAll("\\B([A-Z])", " $1"), elements);
        }

        private EnumDpt(String typeId, String description, Class<T> elements) {
            super(typeId, description, "0", Integer.toString(DptXlator16BitSet.maxValue(elements)));
            this.elements = elements;
        }

        private T find(int element) {
            for (Enum e : EnumSet.allOf(this.elements)) {
                if (((EnumBase)((Object)e)).value() != element) continue;
                return (T)e;
            }
            return null;
        }

        private T find(String description) {
            for (Enum e : EnumSet.allOf(this.elements)) {
                if (!e.name().equals(description) && !this.friendly(((EnumBase)((Object)e)).value()).equals(description)) continue;
                return (T)e;
            }
            return null;
        }

        private String textOf(int element) {
            T e = this.find(element);
            if (e != null) {
                return ((Enum)e).name();
            }
            throw new KNXIllegalArgumentException(this.getID() + " " + this.elements.getSimpleName() + " has no element " + element + " specified");
        }

        private String friendly(int element) {
            return this.textOf(element).replaceAll("(\\p{Lower})\\B([A-Z])", "$1 $2");
        }
    }

    public static enum RhccStatus implements EnumBase<RhccStatus>
    {
        Fault,
        HeatingEcoMode,
        LimitFlowTemperature,
        LimitReturnTemperature,
        HeatingMorningBoost,
        EarlyMorningStart,
        EarlyEveningShutdown,
        HeatingDisabled,
        HeatingMode,
        CoolingEcoMode,
        PreCoolingMode,
        CoolingDisabled,
        DewPointAlarm,
        FrostAlarm,
        OverheatAlarm;

    }

    public static enum Medium implements EnumBase<Medium>
    {
        _0,
        TP1,
        PL110,
        _3,
        RF,
        Knxip;

    }

    private static interface EnumBase<E extends Enum<E>> {
        default public int value() {
            return 1 << ((Enum)((Object)this)).ordinal();
        }
    }
}

