/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.util.EnumSet;
import java.util.Map;
import java.util.StringJoiner;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;

public class DptXlator8BitSet
extends DPTXlator {
    public static final EnumDpt<GeneralStatus> DptGeneralStatus = new EnumDpt<GeneralStatus>("21.001", GeneralStatus.class);
    public static final EnumDpt<DeviceControl> DptDeviceControl = new EnumDpt<DeviceControl>("21.002", DeviceControl.class);
    public static final EnumDpt<ForcingSignal> DptForcingSignal = new EnumDpt<ForcingSignal>("21.100", ForcingSignal.class);
    public static final EnumDpt<ForcingSignalCool> DptForcingSignalCool = new EnumDpt<ForcingSignalCool>("21.101", ForcingSignalCool.class);
    public static final EnumDpt<RoomHeatingControllerStatus> DptRoomHeatingControllerStatus = new EnumDpt<RoomHeatingControllerStatus>("21.102", RoomHeatingControllerStatus.class);
    public static final EnumDpt<SolarDhwControllerStatus> DptSolarDhwControllerStatus = new EnumDpt<SolarDhwControllerStatus>("21.103", SolarDhwControllerStatus.class);
    public static final EnumDpt<FuelTypeSet> DptFuelTypeSet = new EnumDpt<FuelTypeSet>("21.104", FuelTypeSet.class);
    public static final EnumDpt<RoomCoolingControllerStatus> DptRoomCoolingControllerStatus = new EnumDpt<RoomCoolingControllerStatus>("21.105", RoomCoolingControllerStatus.class);
    public static final EnumDpt<VentilationControllerStatus> DptVentilationControllerStatus = new EnumDpt<VentilationControllerStatus>("21.106", VentilationControllerStatus.class);
    public static final EnumDpt<LightActuatorErrorInfo> DptLightActuatorErrorInfo = new EnumDpt<LightActuatorErrorInfo>("21.601", LightActuatorErrorInfo.class);
    public static final EnumDpt<RFCommModeInfo> DptRFCommModeInfo = new EnumDpt<RFCommModeInfo>("21.1000", RFCommModeInfo.class);
    public static final EnumDpt<RFFilterModes> DptRFFilterInfo = new EnumDpt<RFFilterModes>("21.1001", RFFilterModes.class);
    public static final EnumDpt<SecurityReport> DptSecurityReport = new EnumDpt<SecurityReport>("21.1002", SecurityReport.class);
    public static final EnumDpt<ChannelActivationState> DptChannelActivation = new EnumDpt<ChannelActivationState>("21.1010", ChannelActivationState.class);
    private static final Map<String, DPT> types = DptXlator8BitSet.loadDatapointTypes(DptXlator8BitSet.class);

    public DptXlator8BitSet(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DptXlator8BitSet(String dptId) throws KNXFormatException {
        super(1);
        this.setTypeID(types, dptId);
    }

    @Override
    public String getValue() {
        return this.textOf(0);
    }

    public final void setValue(int value) throws KNXFormatException {
        this.data = new short[]{this.toDpt(value)};
    }

    public final void setValue(EnumSet<?> elements) {
        this.data = new short[]{DptXlator8BitSet.toDpt(elements)};
    }

    @Override
    public final double getNumericValue() throws KNXFormatException {
        return this.fromDpt(0);
    }

    @Override
    public String[] getAllValues() {
        String[] s = new String[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            s[i] = this.textOf(i);
        }
        return s;
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private String textOf(int index) {
        StringJoiner joiner = new StringJoiner(", ");
        short d = this.data[index];
        for (int i = 128; i > 0; i >>= 1) {
            if ((d & i) != i) continue;
            joiner.add(((EnumDpt)this.dpt).textOf(i));
        }
        return joiner.toString();
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        try {
            dst[index] = this.toDpt(Integer.decode(value));
        }
        catch (NumberFormatException nfe) {
            int result = 0;
            boolean tryNames = false;
            for (String s : value.split(" ")) {
                int bit;
                int n = "1".equals(s) || "true".equalsIgnoreCase(s) ? 1 : (bit = "0".equals(s) || "false".equalsIgnoreCase(s) ? 0 : -1);
                if (bit == -1) {
                    tryNames = true;
                    break;
                }
                result = result << 1 | bit;
            }
            if (tryNames) {
                result = 0;
                String[] stringArray = value.split(",");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String s;
                    EnumDpt enumDpt = (EnumDpt)this.dpt;
                    s = stringArray[i];
                    Object e = enumDpt.find(s.trim());
                    if (e == null) {
                        throw this.newException("value is no element of " + enumDpt.elements.getSimpleName(), value);
                    }
                    result |= 1 << ((Enum)e).ordinal();
                }
            }
            dst[index] = (short)result;
        }
    }

    private static short toDpt(EnumSet<?> elements) {
        int v = 0;
        for (Enum e : elements) {
            v |= 1 << e.ordinal();
        }
        return (short)v;
    }

    private short toDpt(int value) throws KNXFormatException {
        this.validate(value);
        return (short)value;
    }

    private short fromDpt(int index) throws KNXFormatException {
        short v = this.data[index];
        this.validate(v);
        return v;
    }

    private void validate(int value) throws KNXFormatException {
        EnumDpt enumDpt = (EnumDpt)this.dpt;
        if (value < 0 || value > DptXlator8BitSet.maxValue(enumDpt.elements)) {
            throw this.newException("value is out of range [" + enumDpt.getLowerValue() + ".." + enumDpt.getUpperValue() + "]", Integer.toString(value));
        }
    }

    private static <E extends Enum<E>> int maxValue(Class<E> elements) {
        int bits = EnumSet.allOf(elements).size();
        return (1 << bits) - 1;
    }

    public static class EnumDpt<T extends Enum<T>>
    extends DPT {
        private final Class<T> elements;

        public EnumDpt(String typeId, Class<T> elements) {
            this(typeId, elements.getSimpleName().replaceAll("\\B([A-Z])", " $1"), elements);
        }

        private EnumDpt(String typeId, String description, Class<T> elements) {
            super(typeId, description, "0", Integer.toString(DptXlator8BitSet.maxValue(elements)));
            this.elements = elements;
        }

        private T find(int element) {
            for (Enum e : EnumSet.allOf(this.elements)) {
                if (((EnumBase)((Object)e)).value() != element) continue;
                return (T)e;
            }
            return null;
        }

        private T find(String description) {
            for (Enum e : EnumSet.allOf(this.elements)) {
                if (!e.name().equals(description) && !EnumDpt.friendly(e.name()).equalsIgnoreCase(description)) continue;
                return (T)e;
            }
            return null;
        }

        private String textOf(int element) {
            T e = this.find(element);
            if (e != null) {
                return EnumDpt.friendly(((Enum)e).name());
            }
            throw new KNXIllegalArgumentException(this.getID() + " " + this.elements.getSimpleName() + " has no element " + element + " specified");
        }

        private static String friendly(String name) {
            return name.replaceAll("\\B([A-Z])", " $1").toLowerCase();
        }
    }

    public static enum GeneralStatus implements EnumBase<GeneralStatus>
    {
        OutOfService,
        Fault,
        Overridden,
        InAlarm,
        AlarmUnAck;

    }

    public static enum DeviceControl implements EnumBase<DeviceControl>
    {
        UserStopped,
        OwnIndAddress,
        VerifyMode;

    }

    public static enum ForcingSignal implements EnumBase<ForcingSignal>
    {
        ForceRequest,
        Protection,
        Oversupply,
        Overrun,
        DhwNorm,
        DhwLegio,
        RoomHeatingComfort,
        RoomHeatingMax;

    }

    public static enum ForcingSignalCool implements EnumBase<ForcingSignalCool>
    {
        ForceRequest;

    }

    public static enum RoomHeatingControllerStatus implements EnumBase<RoomHeatingControllerStatus>
    {
        Fault,
        EcoMode,
        FlowTempLimit,
        ReturnTempLimit,
        MorningBoost,
        StartOptimization,
        StopOptimization,
        SummerMode;

    }

    public static enum SolarDhwControllerStatus implements EnumBase<SolarDhwControllerStatus>
    {
        Fault,
        SolarDhwLoadActive,
        SolarLoadSufficient;

    }

    public static enum FuelTypeSet implements EnumBase<FuelTypeSet>
    {
        Oil,
        Gas,
        SolidState;

    }

    public static enum RoomCoolingControllerStatus implements EnumBase<RoomCoolingControllerStatus>
    {
        Fault;

    }

    public static enum VentilationControllerStatus implements EnumBase<VentilationControllerStatus>
    {
        Fault,
        FanActive,
        Heat,
        Cool;

    }

    public static enum LightActuatorErrorInfo implements EnumBase<LightActuatorErrorInfo>
    {
        LoadDetectionFailed,
        Undervoltage,
        Overcurrent,
        Underload,
        DefectiveLoad,
        LampFailure,
        Overheat;

    }

    public static enum RFCommModeInfo implements EnumBase<RFCommModeInfo>
    {
        Asynchronous,
        BiBatMaster,
        BiBatSlave;

    }

    public static enum RFFilterModes implements EnumBase<RFFilterModes>
    {
        DomainAddress,
        SerialNumber,
        DoAAndSN;

    }

    public static enum SecurityReport implements EnumBase<SecurityReport>
    {
        SecurityFailure;

    }

    public static enum ChannelActivationState implements EnumBase<ChannelActivationState>
    {
        Channel1,
        Channel2,
        Channel3,
        Channel4,
        Channel5,
        Channel6,
        Channel7,
        Channel8;

    }

    private static interface EnumBase<E extends Enum<E>> {
        default public int value() {
            return 1 << ((Enum)((Object)this)).ordinal();
        }
    }
}

