/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;
import tuwien.auto.calimero.dptxlator.DPTXlator4ByteSigned;
import tuwien.auto.calimero.dptxlator.DptXlator8BitSet;

public class DptXlatorMeteringValue
extends DPTXlator {
    public static final DPT DptMeteringValue = new DPT("229.001", "Metering Value", Integer.toString(Integer.MIN_VALUE), Integer.toString(Integer.MAX_VALUE));
    private static final Map<String, DPT> types = new HashMap<String, DPT>();
    private static final int dimensionlessCounter = 186;
    private final DptXlator8BitSet status = new DptXlator8BitSet(DptXlator8BitSet.DptGeneralStatus);
    private final DPTXlator4ByteSigned cv = new DPTXlator4ByteSigned(DPTXlator4ByteSigned.DPT_COUNT);
    private String description;
    private String unit;
    private int expUnitAdjustment;

    public DptXlatorMeteringValue(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DptXlatorMeteringValue(String dptId) throws KNXFormatException {
        super(6);
        this.setTypeID(types, dptId);
        this.data[4] = 186;
    }

    @Override
    public String getValue() {
        return this.textOf(0);
    }

    public final void setValue(int value) {
        this.expUnitAdjustment = 0;
        try {
            this.data = this.toDpt(186, value);
        }
        catch (KNXFormatException e) {
            logger.error("{} {} coding {} (value {}) should alway have correct format", new Object[]{this.dpt.getID(), this.dpt.getDescription(), DptXlatorMeteringValue.binary(186), value, e});
        }
    }

    public final void setValue(int coding, double value) throws KNXFormatException {
        this.expUnitAdjustment = 0;
        this.data = this.toDpt(coding, value);
    }

    public final DptXlator8BitSet status() {
        this.status.setData(new byte[]{(byte)this.data[5]});
        return this.status;
    }

    @Override
    public final double getNumericValue() {
        return this.fromDpt(0);
    }

    @Override
    public String[] getAllValues() {
        String[] s = new String[this.data.length / this.typeSize];
        for (int i = 0; i < s.length; ++i) {
            s[i] = this.textOf(i);
        }
        return s;
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        String[] split = value.split(" ");
        boolean hasUnit = split.length > 1;
        String number = split[hasUnit ? split.length - 2 : 0];
        this.unit = hasUnit ? split[split.length - 1] : "";
        int coding = this.coding(this.unit);
        try {
            short[] result = this.toDpt(coding, Double.parseDouble(number));
            int offset = index * this.typeSize;
            for (int i = 0; i < result.length; ++i) {
                dst[offset + i] = result[i];
            }
            if (split.length > 2) {
                String[] statusPart = Arrays.copyOfRange(split, 0, split.length - 2);
                this.status.setValue(Arrays.asList(statusPart).stream().collect(Collectors.joining(" ")));
                dst[offset + 5] = (short)this.status.getNumericValue();
            }
        }
        catch (NumberFormatException e) {
            throw this.newException("not a parsable number", number, e);
        }
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private String textOf(int index) {
        int i = 6 * index;
        this.status.setData(new byte[]{(byte)this.data[i + 5]});
        String s = this.status.getValue();
        return ((String)(s.isEmpty() ? "" : s + ", ") + this.fromDpt(index) + this.appendUnit()).trim();
    }

    private String appendUnit() {
        return this.appendUnit && !this.unit.isEmpty() ? " " + this.unit : "";
    }

    private short[] toDpt(int coding, double value) throws KNXFormatException {
        int exp = this.coding(coding);
        double result = Math.pow(10.0, -exp + this.expUnitAdjustment) * value;
        int counterValue = (int)result;
        boolean status = false;
        this.cv.setValue(counterValue);
        byte[] data = this.cv.getData();
        return new short[]{DptXlatorMeteringValue.ubyte(data[0]), DptXlatorMeteringValue.ubyte(data[1]), DptXlatorMeteringValue.ubyte(data[2]), DptXlatorMeteringValue.ubyte(data[3]), (short)coding, 0};
    }

    private double fromDpt(int index) {
        int i = 6 * index;
        this.cv.setData(new byte[]{(byte)this.data[i], (byte)this.data[i + 1], (byte)this.data[i + 2], (byte)this.data[i + 3]});
        short coding = DptXlatorMeteringValue.ubyte(this.data[i + 4]);
        try {
            int exp = this.coding(coding);
            double result = Math.pow(10.0, exp) * this.cv.getNumericValue();
            logger.info("{} {} '{}' {} (exp {}) value {} {}", new Object[]{this.dpt.getID(), this.dpt.getDescription(), this.description, DptXlatorMeteringValue.binary(coding), exp, result, this.unit});
            return result;
        }
        catch (KNXFormatException e) {
            logger.error("{} {} unsupported coding {}", new Object[]{this.dpt.getID(), this.dpt.getDescription(), DptXlatorMeteringValue.binary(coding)});
            return this.cv.getNumericValue();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int coding(int coding) throws KNXFormatException {
        String unit;
        String desc;
        if (coding < 0 || coding > 255) {
            throw new KNXIllegalArgumentException("coding " + DptXlatorMeteringValue.binary(coding) + " out of range [0..0xff]");
        }
        int exp = 0;
        int vifExtensionBit = 128;
        if ((coding & 0x80) == 0) {
            int vifMask = 248;
            int id = coding & 0xF8;
            int n = coding & 0xFFFFFF07;
            if (id == 0) {
                desc = "energy";
                unit = "Wh";
                exp = n - 3;
            } else if (id == 8) {
                desc = "energy";
                unit = "J";
                exp = n;
            } else if (id == 16) {
                desc = "volume";
                unit = "m\u00b3";
                exp = n - 6;
            } else if (id == 24) {
                desc = "mass";
                unit = "kg";
                exp = n - 3;
            } else if (id == 40) {
                desc = "power";
                unit = "W";
                exp = n - 3;
            } else if (id == 48) {
                desc = "power";
                unit = "J/h";
                exp = n;
            } else if (id == 56) {
                desc = "volume flow";
                unit = "m\u00b3/h";
                exp = n - 6;
            } else if (id == 64) {
                desc = "volume flow";
                unit = "m\u00b3/min";
                exp = n - 7;
            } else if (id == 72) {
                desc = "volume flow";
                unit = "m\u00b3/sec";
                exp = n - 9;
            } else if (id == 80) {
                desc = "mass flow";
                unit = "kg/h";
                exp = n - 3;
            } else {
                if (coding != 110) throw this.newException("reserved coding", DptXlatorMeteringValue.binary(coding));
                desc = "units for HCA";
                unit = "";
            }
        } else {
            int vifExtMask = 254;
            int id = coding & 0xFE;
            int n = coding & 0xFFFFFF01;
            if (id == 128) {
                desc = "energy";
                unit = "Wh";
                exp = n + 5;
            } else if (id == 136) {
                desc = "energy";
                unit = "J";
                exp = n + 8;
            } else if (id == 168) {
                desc = "power";
                unit = "W";
                exp = n + 5;
            } else if (id == 176) {
                desc = "power";
                unit = "J/h";
                exp = n + 8;
            } else {
                if (coding != 186) throw this.newException("reserved coding", DptXlatorMeteringValue.binary(coding));
                desc = "dimensionless counter";
                unit = "";
            }
        }
        this.description = desc;
        this.unit = unit;
        return exp;
    }

    private int coding(String unit) throws KNXFormatException {
        this.expUnitAdjustment = 0;
        switch (unit) {
            case "Wh": {
                return 0;
            }
            case "MWh": {
                this.expUnitAdjustment = 6;
                return 128;
            }
            case "kJ": {
                this.expUnitAdjustment = 3;
                return 8;
            }
            case "GJ": {
                this.expUnitAdjustment = 9;
                return 136;
            }
            case "l": {
                this.expUnitAdjustment = -3;
                return 16;
            }
            case "kg": {
                return 24;
            }
            case "W": {
                return 40;
            }
            case "MW": {
                this.expUnitAdjustment = 6;
                return 168;
            }
            case "kJ/h": {
                this.expUnitAdjustment = 3;
                return 48;
            }
            case "GJ/h": {
                this.expUnitAdjustment = 9;
                return 176;
            }
            case "l/h": {
                this.expUnitAdjustment = -3;
                return 56;
            }
            case "l/min": {
                this.expUnitAdjustment = -3;
                return 64;
            }
            case "ml/s": {
                this.expUnitAdjustment = -6;
                return 72;
            }
            case "kg/h": {
                return 80;
            }
            case "": {
                return 186;
            }
        }
        throw this.newException("unsupported unit", unit);
    }

    private static short ubyte(byte b) {
        return (short)(b & 0xFF);
    }

    private static String binary(int coding) {
        return String.format("0b%8s", Integer.toBinaryString(coding)).replace(' ', '0');
    }

    static {
        types.put(DptMeteringValue.getID(), DptMeteringValue);
    }
}

