/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.util.Map;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;
import tuwien.auto.calimero.dptxlator.DPTXlator3BitControlled;

public class DptXlatorRelativeControlRgb
extends DPTXlator {
    public static final String Description = "relative control RGB";
    public static final DPT DptRelativeControlRgb = new DPT("254.600", "relative control RGB", "decrease 0 decrease 0 decrease 0", "increase 7 increase 7 increase 7");
    private static final Map<String, DPT> types = DptXlatorRelativeControlRgb.loadDatapointTypes(DptXlatorRelativeControlRgb.class);
    private static final String Red = "R";
    private static final String Green = "G";
    private static final String Blue = "B";
    private final DPTXlator3BitControlled t = new DPTXlator3BitControlled(DPTXlator3BitControlled.DPT_CONTROL_DIMMING);

    public DptXlatorRelativeControlRgb() throws KNXFormatException {
        this(DptRelativeControlRgb);
    }

    public DptXlatorRelativeControlRgb(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DptXlatorRelativeControlRgb(String dptId) throws KNXFormatException {
        super(3);
        this.setTypeID(types, dptId);
        this.data = new short[this.typeSize];
    }

    @Override
    public String getValue() {
        return this.fromDpt(0);
    }

    public final void setValue(boolean increaseRed, int redStepcode, boolean increaseGreen, int greenStepcode, boolean increaseBlue, int blueStepcode) {
        this.data = this.toDpt(increaseRed, redStepcode, increaseGreen, greenStepcode, increaseBlue, blueStepcode);
    }

    @Override
    public String[] getAllValues() {
        int items = this.getItems();
        String[] s = new String[items];
        for (int i = 0; i < items; ++i) {
            s[i] = this.fromDpt(i);
        }
        return s;
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private String fromDpt(int index) {
        int offset = index * this.typeSize;
        this.t.setAppendUnit(this.appendUnit);
        Object s = this.component(offset, 2);
        s = (String)s + this.component(offset, 1);
        s = (String)s + this.component(offset, 0);
        return ((String)s).trim();
    }

    private String component(int offset, int component) {
        String[] prefixes = new String[]{Blue, Green, Red};
        this.t.setData(new byte[]{(byte)this.data[offset + 2 - component]});
        return " " + prefixes[component] + " " + this.t.getValue();
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        if (value.isEmpty()) {
            return;
        }
        String[] fields = value.split(" ", 0);
        if (fields.length > 12 || fields.length < 3) {
            throw this.newException("unsupported format for relative control RGB", value);
        }
        int offset = index * this.typeSize;
        int i = 0;
        String[] components = new String[]{Red, Green, Blue};
        int clrOffset = 0;
        int colors = 0;
        for (String c : components) {
            if (c.equals(fields[i])) {
                ++i;
            }
            if ("break".equals(fields[i])) {
                dst[offset + clrOffset] = 0;
                ++i;
            } else {
                int clr = this.component(fields, i);
                dst[offset + clrOffset] = DptXlatorRelativeControlRgb.ubyte(clr);
                i += 2;
            }
            if (i < fields.length && "steps".equals(fields[i])) {
                ++i;
            }
            ++colors;
            if (i >= fields.length) break;
            ++clrOffset;
        }
        if (colors < 3) {
            throw this.newException("value contains not all color components", "missing " + (3 - colors));
        }
        if (i < fields.length) {
            throw this.newException("value contains excessive components", fields[i]);
        }
    }

    private int component(String[] fields, int i) throws KNXFormatException {
        String first = fields[i];
        if (fields.length > i + 1) {
            this.t.setValue(first + " " + fields[i + 1]);
        } else {
            this.t.setValue(first);
        }
        return this.t.getData()[0];
    }

    private short[] toDpt(boolean increaseRed, int redStepcode, boolean increaseGreen, int greenStepcode, boolean increaseBlue, int blueStepcode) {
        this.rangeCheck(redStepcode);
        this.rangeCheck(greenStepcode);
        this.rangeCheck(blueStepcode);
        this.t.setValue(increaseRed, redStepcode);
        short red = DptXlatorRelativeControlRgb.ubyte(this.t.getData()[0]);
        this.t.setValue(increaseGreen, greenStepcode);
        short green = DptXlatorRelativeControlRgb.ubyte(this.t.getData()[0]);
        this.t.setValue(increaseBlue, blueStepcode);
        short blue = DptXlatorRelativeControlRgb.ubyte(this.t.getData()[0]);
        return new short[]{red, green, blue};
    }

    private void rangeCheck(int clrStepcode) {
        if (clrStepcode < 0 || clrStepcode > 7) {
            throw new KNXIllegalArgumentException("stepcode " + clrStepcode + " out of range [0..7]");
        }
    }
}

