/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.util.Map;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;
import tuwien.auto.calimero.dptxlator.DPTXlator3BitControlled;

public class DptXlatorRelativeControlRgbw
extends DPTXlator {
    public static final String Description = "relative control RGBW";
    public static final DPT DptRelativeControlRgbw = new DPT("252.600", "relative control RGBW", "R decrease 0 G decrease 0 B decrease 0 W decrease 0", "R increase 7 G increase 7 B increase 7 W increase 7");
    private static final Map<String, DPT> types = DptXlatorRelativeControlRgbw.loadDatapointTypes(DptXlatorRelativeControlRgbw.class);
    private static final String Red = "R";
    private static final String Green = "G";
    private static final String Blue = "B";
    private static final String White = "W";
    private final DPTXlator3BitControlled t = new DPTXlator3BitControlled(DPTXlator3BitControlled.DPT_CONTROL_DIMMING);

    public DptXlatorRelativeControlRgbw() throws KNXFormatException {
        this(DptRelativeControlRgbw);
    }

    public DptXlatorRelativeControlRgbw(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DptXlatorRelativeControlRgbw(String dptId) throws KNXFormatException {
        super(5);
        this.setTypeID(types, dptId);
        this.data = new short[this.typeSize];
    }

    @Override
    public String getValue() {
        return this.fromDpt(0);
    }

    public final void setValue(boolean increaseRed, int redStepcode, boolean increaseGreen, int greenStepcode, boolean increaseBlue, int blueStepcode, boolean increaseWhite, int whiteStepcode) {
        this.data = this.toDpt(increaseRed, redStepcode, increaseGreen, greenStepcode, increaseBlue, blueStepcode, increaseWhite, whiteStepcode);
    }

    @Override
    public String[] getAllValues() {
        int items = this.getItems();
        String[] s = new String[items];
        for (int i = 0; i < items; ++i) {
            s[i] = this.fromDpt(i);
        }
        return s;
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private String fromDpt(int index) {
        int offset = index * this.typeSize;
        short valid = this.data[offset + this.typeSize - 1];
        if (valid == 0) {
            return "R - G - B - W -";
        }
        this.t.setAppendUnit(this.appendUnit);
        Object s = this.component(offset, 3);
        s = (String)s + this.component(offset, 2);
        s = (String)s + this.component(offset, 1);
        s = (String)s + this.component(offset, 0);
        return ((String)s).trim();
    }

    private String component(int offset, int component) {
        String[] prefixes = new String[]{White, Blue, Green, Red};
        short mask = this.data[offset + this.typeSize - 1];
        if ((mask >> component & 1) == 1) {
            this.t.setData(new byte[]{(byte)this.data[offset + 3 - component]});
            return " " + prefixes[component] + " " + this.t.getValue();
        }
        return "";
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        if (value.isEmpty()) {
            return;
        }
        String[] fields = value.split(" ", 0);
        if (fields.length > 16 || fields.length < 4) {
            throw this.newException("unsupported format for relative control RGBW", value);
        }
        int valid = 0;
        int offset = index * this.typeSize;
        int i = 0;
        String[] components = new String[]{Red, Green, Blue, White};
        int maskBit = 8;
        int clrOffset = 0;
        for (String c : components) {
            if (c.equals(fields[i])) {
                int clr = this.component(fields, ++i);
                dst[offset + clrOffset] = DptXlatorRelativeControlRgbw.ubyte(clr);
                boolean invalid = clr == -1;
                valid |= invalid ? 0 : maskBit;
                if ((i += invalid || clr == 0 ? 1 : 2) < fields.length && "steps".equals(fields[i])) {
                    ++i;
                }
            }
            if (i >= fields.length) break;
            maskBit >>= 1;
            ++clrOffset;
        }
        if (i < fields.length) {
            throw this.newException("value contains excessive components", fields[i]);
        }
        dst[offset + this.typeSize - 1] = (short)valid;
    }

    private int component(String[] fields, int i) throws KNXFormatException {
        String first = fields[i];
        if ("-".equals(first)) {
            return -1;
        }
        if (fields.length > i + 1) {
            this.t.setValue(first + " " + fields[i + 1]);
        } else {
            this.t.setValue(first);
        }
        return this.t.getData()[0];
    }

    private short[] toDpt(boolean increaseRed, int redStepcode, boolean increaseGreen, int greenStepcode, boolean increaseBlue, int blueStepcode, boolean increaseWhite, int whiteStepcode) {
        this.rangeCheck(redStepcode);
        this.rangeCheck(greenStepcode);
        this.rangeCheck(blueStepcode);
        this.rangeCheck(whiteStepcode);
        this.t.setValue(increaseRed, redStepcode);
        short red = DptXlatorRelativeControlRgbw.ubyte(this.t.getData()[0]);
        this.t.setValue(increaseGreen, greenStepcode);
        short green = DptXlatorRelativeControlRgbw.ubyte(this.t.getData()[0]);
        this.t.setValue(increaseBlue, blueStepcode);
        short blue = DptXlatorRelativeControlRgbw.ubyte(this.t.getData()[0]);
        this.t.setValue(increaseWhite, whiteStepcode);
        short white = DptXlatorRelativeControlRgbw.ubyte(this.t.getData()[0]);
        int valid = 15;
        return new short[]{red, green, blue, white, 15};
    }

    private void rangeCheck(int clrStepcode) {
        if (clrStepcode < 0 || clrStepcode > 7) {
            throw new KNXIllegalArgumentException("stepcode " + clrStepcode + " out of range [0..7]");
        }
    }
}

