/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.util.Map;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;
import tuwien.auto.calimero.dptxlator.DPTXlator3BitControlled;

public class DptXlatorRelativeControlXyY
extends DPTXlator {
    public static final String Description = "relative control xyY";
    public static final DPT DptRelativeControlXyY = new DPT("253.600", "relative control xyY", "x decrease 0 y decrease 0 Y decrease 0", "x increase 7 y increase 7 Y increase 7");
    private static final Map<String, DPT> types = DptXlatorRelativeControlXyY.loadDatapointTypes(DptXlatorRelativeControlXyY.class);
    private final DPTXlator3BitControlled t = new DPTXlator3BitControlled(DPTXlator3BitControlled.DPT_CONTROL_DIMMING);

    public DptXlatorRelativeControlXyY() throws KNXFormatException {
        this(DptRelativeControlXyY);
    }

    public DptXlatorRelativeControlXyY(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DptXlatorRelativeControlXyY(String dptId) throws KNXFormatException {
        super(4);
        this.setTypeID(types, dptId);
        this.data = new short[this.typeSize];
    }

    @Override
    public String getValue() {
        return this.fromDpt(0);
    }

    public final void setValue(boolean increaseX, int xStepcode, boolean increaseY, int yStepcode, boolean increaseBrightness, int brightnessStepcode) {
        this.data = this.toDpt(increaseX, xStepcode, increaseY, yStepcode, increaseBrightness, brightnessStepcode);
    }

    @Override
    public String[] getAllValues() {
        int items = this.getItems();
        String[] s = new String[items];
        for (int i = 0; i < items; ++i) {
            s[i] = this.fromDpt(i);
        }
        return s;
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private String fromDpt(int index) {
        int offset = index * this.typeSize;
        short valid = this.data[offset + this.typeSize - 1];
        if (valid == 0) {
            return "x - y - Y -";
        }
        this.t.setAppendUnit(this.appendUnit);
        Object s = this.component(offset, 2);
        s = (String)s + this.component(offset, 1);
        s = (String)s + this.component(offset, 0);
        return ((String)s).trim();
    }

    private String component(int offset, int component) {
        String[] prefixes = new String[]{"Y", "y", "x"};
        short mask = this.data[offset + this.typeSize - 1];
        if ((mask >> component & 1) == 1) {
            this.t.setData(new byte[]{(byte)this.data[offset + 2 - component]});
            return " " + prefixes[component] + " " + this.t.getValue();
        }
        return "";
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        if (value.isEmpty()) {
            return;
        }
        String[] fields = value.split(" ", 0);
        if (fields.length > 12 || fields.length < 3) {
            throw this.newException("unsupported format for relative control xyY", value);
        }
        int valid = 0;
        int offset = index * this.typeSize;
        int i = 0;
        String[] components = new String[]{"x", "y", "Y"};
        int maskBit = 4;
        int clrOffset = 0;
        for (String c : components) {
            if (c.equals(fields[i])) {
                int clr = this.component(fields, ++i);
                dst[offset + clrOffset] = DptXlatorRelativeControlXyY.ubyte(clr);
                boolean invalid = clr == -1;
                valid |= invalid ? 0 : maskBit;
                if ((i += invalid || clr == 0 ? 1 : 2) < fields.length && "steps".equals(fields[i])) {
                    ++i;
                }
            }
            if (i >= fields.length) break;
            maskBit >>= 1;
            ++clrOffset;
        }
        if (i < fields.length) {
            throw this.newException("value contains excessive components", fields[i]);
        }
        dst[offset + this.typeSize - 1] = (short)valid;
    }

    private int component(String[] fields, int i) throws KNXFormatException {
        String first = fields[i];
        if ("-".equals(first)) {
            return -1;
        }
        if (fields.length > i + 1) {
            this.t.setValue(first + " " + fields[i + 1]);
        } else {
            this.t.setValue(first);
        }
        return this.t.getData()[0];
    }

    private short[] toDpt(boolean increaseX, int xStepcode, boolean increaseY, int yStepcode, boolean increaseBrightness, int brightnessStepcode) {
        this.rangeCheck(xStepcode);
        this.rangeCheck(yStepcode);
        this.rangeCheck(brightnessStepcode);
        this.t.setValue(increaseX, xStepcode);
        short red = DptXlatorRelativeControlXyY.ubyte(this.t.getData()[0]);
        this.t.setValue(increaseY, yStepcode);
        short green = DptXlatorRelativeControlXyY.ubyte(this.t.getData()[0]);
        this.t.setValue(increaseBrightness, brightnessStepcode);
        short blue = DptXlatorRelativeControlXyY.ubyte(this.t.getData()[0]);
        int valid = 7;
        return new short[]{red, green, blue, 7};
    }

    private void rangeCheck(int stepcode) {
        if (stepcode < 0 || stepcode > 7) {
            throw new KNXIllegalArgumentException("stepcode " + stepcode + " out of range [0..7]");
        }
    }
}

