/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;

public class DptXlatorRgbw
extends DPTXlator {
    public static final String Description = "RGBW color";
    public static final DPT DptRgbw = new DPT("251.600", "RGBW color", "0 0 0 0", "100 100 100 100", "%");
    private static final Map<String, DPT> types = new HashMap<String, DPT>();
    private final NumberFormat formatter = NumberFormat.getNumberInstance();

    public DptXlatorRgbw() throws KNXFormatException {
        this(DptRgbw);
    }

    public DptXlatorRgbw(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DptXlatorRgbw(String dptId) throws KNXFormatException {
        super(6);
        this.setTypeID(types, dptId);
        this.data = new short[6];
        this.formatter.setMaximumFractionDigits(1);
    }

    @Override
    public String getValue() {
        return this.fromDpt(0);
    }

    public final void setValue(double red, double green, double blue, double white) {
        this.data = this.toDpt(red, green, blue, white);
    }

    public final Optional<Double> red() {
        return this.component(0);
    }

    public final Optional<Double> green() {
        return this.component(1);
    }

    public final Optional<Double> blue() {
        return this.component(2);
    }

    public final Optional<Double> white() {
        return this.component(3);
    }

    @Override
    public String[] getAllValues() {
        int items = this.getItems();
        String[] s = new String[items];
        for (int i = 0; i < items; ++i) {
            s[i] = this.fromDpt(i);
        }
        return s;
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private String fromDpt(int index) {
        if (this.data[index * 6 + 4] != 0) {
            logger.warn("DPT " + this.dpt.getID() + " " + this.dpt.getDescription() + ": reserved bits not 0");
        }
        return this.appendUnit(this.component(index, 0) + " " + this.component(index, 1) + " " + this.component(index, 2) + " " + this.component(index, 3));
    }

    private String component(int index, int component) {
        boolean valid;
        int mask = 1 << 3 - component;
        boolean bl = valid = (this.data[index * 6 + 5] & mask) == mask;
        if (valid) {
            return this.formatter.format((double)this.data[index * 6 + component] * 100.0 / 255.0);
        }
        return "-";
    }

    private Optional<Double> component(int component) {
        boolean valid;
        boolean index = false;
        int mask = 1 << 3 - component;
        boolean bl = valid = (this.data[5] & mask) == mask;
        if (valid) {
            return Optional.of((double)this.data[0 + component] * 100.0 / 255.0);
        }
        return Optional.empty();
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        String[] components = this.removeUnit(value).split(" ");
        if (components.length != 4) {
            throw this.newException("RGBW format requires 4 components", value);
        }
        int valid = 0;
        for (int i = 0; i < 4; ++i) {
            int mask = 1 << 3 - i;
            if (components[i].equals("-")) continue;
            valid |= mask;
            dst[index * 6 + i] = this.toDpt(components[i]);
        }
        dst[index * 6 + 5] = (short)valid;
    }

    private short[] toDpt(double red, double green, double blue, double white) {
        int valid = 15;
        return new short[]{this.toDpt(red), this.toDpt(green), this.toDpt(blue), this.toDpt(white), 0, 15};
    }

    private short toDpt(double value) {
        if (value < 0.0 || value > 100.0) {
            throw new KNXIllegalArgumentException("RGBW component " + value + " out of range [0..100]");
        }
        return (short)Math.round(value * 255.0 / 100.0);
    }

    private short toDpt(String component) throws KNXFormatException {
        try {
            double value = Double.parseDouble(component.replace(',', '.'));
            return this.toDpt(value);
        }
        catch (NumberFormatException e) {
            throw this.newException("wrong value format", component);
        }
        catch (KNXIllegalArgumentException e) {
            throw this.newException(e.getMessage(), component);
        }
    }

    static {
        types.put(DptRgbw.getID(), DptRgbw);
    }
}

