/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.internal;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventListeners<T> {
    private final CopyOnWriteArrayList<T> listeners = new CopyOnWriteArrayList();
    private final Logger logger;

    public EventListeners(Logger logger) {
        this.logger = logger;
    }

    public EventListeners() {
        this.logger = LoggerFactory.getLogger((String)"calimero");
    }

    public void add(T l) {
        this.listeners.addIfAbsent(l);
    }

    public void remove(T l) {
        this.listeners.remove(l);
    }

    public void removeAll() {
        this.listeners.clear();
    }

    public List<T> listeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public void fire(Consumer<? super T> c) {
        for (T l : this.listeners) {
            try {
                c.accept(l);
            }
            catch (RuntimeException rte) {
                this.remove(l);
                this.logger.error("removed event listener", (Throwable)rte);
            }
        }
    }
}

