/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.internal;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UncheckedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedChannelException;

public abstract class UdpSocketLooper {
    protected DatagramSocket s;
    protected volatile boolean reboundSocket;
    private final int timeout;
    private final int maxRcvBuf;
    private final int total;
    private final boolean closeSocket;
    private volatile boolean quit;

    public UdpSocketLooper(DatagramSocket socket, boolean closeSocket) {
        this(socket, closeSocket, 512, 0, 0);
    }

    public UdpSocketLooper(DatagramSocket socket, boolean closeSocket, int receiveBufferSize, int socketTimeout, int loopTimeout) {
        this.s = socket;
        this.maxRcvBuf = receiveBufferSize;
        this.timeout = socketTimeout;
        this.total = loopTimeout;
        this.closeSocket = closeSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loop() throws IOException {
        long start = System.currentTimeMillis();
        byte[] buf = new byte[this.maxRcvBuf];
        try {
            if (this.timeout > 0) {
                this.setTimeout(this.timeout);
            }
            while (!this.quit) {
                if (this.total > 0) {
                    long now = System.currentTimeMillis();
                    int to = (int)(start + (long)this.total - now);
                    if (to <= 0) {
                        break;
                    }
                    int sto = this.timeout();
                    if (sto > 0) {
                        to = Math.min(to, sto);
                    }
                    this.setTimeout(to);
                }
                try {
                    this.receive(buf);
                }
                catch (SocketTimeoutException e) {
                    if (this.total != 0 && start + (long)this.total <= System.currentTimeMillis()) continue;
                    this.onTimeout();
                }
                catch (IOException e) {
                    if (!this.reboundSocket) {
                        throw e;
                    }
                    this.reboundSocket = false;
                }
            }
        }
        catch (InterruptedIOException e) {
            Thread.currentThread().interrupt();
        }
        catch (ClosedChannelException e) {
        }
        catch (IOException | UncheckedIOException e) {
            if (!this.quit) {
                throw e;
            }
        }
        finally {
            this.quit();
        }
    }

    protected int timeout() throws SocketException {
        if (this.s == null) {
            return 0;
        }
        return this.s.getSoTimeout();
    }

    protected void setTimeout(int timeout) throws SocketException {
        if (this.s == null) {
            return;
        }
        this.s.setSoTimeout(timeout);
    }

    protected void receive(byte[] buf) throws IOException {
        DatagramPacket p = new DatagramPacket(buf, buf.length);
        this.s.receive(p);
        this.onReceive((InetSocketAddress)p.getSocketAddress(), buf, p.getOffset(), p.getLength());
    }

    protected void onTimeout() {
    }

    protected abstract void onReceive(InetSocketAddress var1, byte[] var2, int var3, int var4) throws IOException;

    public void quit() {
        this.quit = true;
        if (this.closeSocket && this.s != null) {
            this.s.close();
        }
    }
}

