/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXInvalidResponseException;
import tuwien.auto.calimero.KNXRemoteException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.knxnetip.Connection;
import tuwien.auto.calimero.knxnetip.ConnectionBase;
import tuwien.auto.calimero.knxnetip.Net;
import tuwien.auto.calimero.knxnetip.servicetype.ConnectRequest;
import tuwien.auto.calimero.knxnetip.servicetype.ConnectResponse;
import tuwien.auto.calimero.knxnetip.servicetype.ConnectionstateRequest;
import tuwien.auto.calimero.knxnetip.servicetype.ConnectionstateResponse;
import tuwien.auto.calimero.knxnetip.servicetype.DisconnectRequest;
import tuwien.auto.calimero.knxnetip.servicetype.DisconnectResponse;
import tuwien.auto.calimero.knxnetip.servicetype.ErrorCodes;
import tuwien.auto.calimero.knxnetip.servicetype.KNXnetIPHeader;
import tuwien.auto.calimero.knxnetip.servicetype.PacketHelper;
import tuwien.auto.calimero.knxnetip.servicetype.ServiceAck;
import tuwien.auto.calimero.knxnetip.util.CRI;
import tuwien.auto.calimero.knxnetip.util.HPAI;
import tuwien.auto.calimero.knxnetip.util.TunnelCRD;
import tuwien.auto.calimero.log.LogService;

abstract class ClientConnection
extends ConnectionBase {
    public static final int CEMI_CON_PENDING = 4;
    public static final int UNKNOWN_ERROR = -1;
    private static final int CONFIRMATION_TIMEOUT = 3;
    private HeartbeatMonitor heartbeat;
    private IndividualAddress tunnelingAddress;
    private String status = "";
    private volatile boolean cleanup;
    final boolean tcp;
    private final Connection connection;

    ClientConnection(int serviceRequest, int serviceAck, int maxSendAttempts, int responseTimeout, Connection connection) {
        super(serviceRequest, serviceAck, maxSendAttempts, responseTimeout);
        this.tcp = connection != Connection.Udp;
        this.connection = connection;
    }

    ClientConnection(int serviceRequest, int serviceAck, int maxSendAttempts, int responseTimeout) {
        this(serviceRequest, serviceAck, maxSendAttempts, responseTimeout, Connection.Udp);
    }

    protected void connect(Connection c, CRI cri) throws KNXException, InterruptedException {
        try {
            c.connect();
            c.registerConnectRequest(this);
            this.connect(c.localEndpoint(), c.server(), cri, false);
        }
        catch (IOException e) {
            throw new KNXException("connecting " + this.connection, e);
        }
        finally {
            c.unregisterConnectRequest(this);
        }
    }

    protected void connect(InetSocketAddress localEP, InetSocketAddress serverCtrlEP, CRI cri, boolean useNAT) throws KNXException, InterruptedException {
        if (this.state != 1) {
            throw new IllegalStateException("open connection");
        }
        this.ctrlEndpt = serverCtrlEP;
        if (this.ctrlEndpt.isUnresolved()) {
            throw new KNXException("server control endpoint is unresolved: " + serverCtrlEP);
        }
        if (this.ctrlEndpt.getAddress().isMulticastAddress()) {
            throw new KNXIllegalArgumentException("server control endpoint cannot be a multicast address (" + this.ctrlEndpt.getAddress().getHostAddress() + ")");
        }
        this.useNat = useNAT;
        this.logger = LogService.getLogger("calimero.knxnetip." + this.getName());
        if (localEP == null) {
            throw new KNXIllegalArgumentException("no local endpoint specified");
        }
        InetSocketAddress local = localEP;
        try {
            if (local.isUnresolved()) {
                throw new KNXIllegalArgumentException("unresolved address " + local);
            }
            if (local.getAddress().isAnyLocalAddress()) {
                InetAddress addr = useNAT ? null : Optional.ofNullable(serverCtrlEP.getAddress()).flatMap(Net::onSameSubnet).orElse(InetAddress.getLocalHost());
                local = new InetSocketAddress(addr, localEP.getPort());
            }
            if (!this.tcp) {
                this.ctrlSocket = this.socket = new DatagramSocket(local);
            }
            InetSocketAddress lsa = this.localSocketAddress();
            this.logger.debug("establish connection from {} to {} ({})", new Object[]{Net.hostPort(lsa), Net.hostPort(this.ctrlEndpt), this.tcp ? "tcp" : "udp"});
            HPAI hpai = this.tcp ? HPAI.Tcp : new HPAI(1, this.useNat ? null : lsa);
            byte[] buf = PacketHelper.toPacket(new ConnectRequest(cri, hpai, hpai));
            this.send(buf, this.ctrlEndpt);
        }
        catch (UnknownHostException e) {
            throw new KNXException("no local host address available", e);
        }
        catch (IOException | SecurityException e) {
            this.closeSocket();
            this.logger.error("communication failure on connect", (Throwable)e);
            if (local.getAddress().isLoopbackAddress()) {
                this.logger.warn("local endpoint uses loopback address ({}), try with a different IP address", (Object)local.getAddress());
            }
            throw new KNXException("connecting from " + Net.hostPort(local) + " to " + Net.hostPort(this.ctrlEndpt) + ": " + e.getMessage());
        }
        this.logger.debug("wait for connect response from {} ...", (Object)Net.hostPort(this.ctrlEndpt));
        if (!this.tcp) {
            this.startReceiver();
        }
        try {
            boolean changed = this.waitForStateChange(1, 10);
            if (this.state == 0) {
                this.heartbeat = new HeartbeatMonitor();
                this.heartbeat.start();
                Object optionalConnectionInfo = "";
                if (this.tunnelingAddress != null) {
                    optionalConnectionInfo = ", tunneling address " + this.tunnelingAddress;
                }
                this.logger.info("connection established (data endpoint {}:{}, channel {}{})", new Object[]{this.dataEndpt.getAddress().getHostAddress(), this.dataEndpt.getPort(), this.channelId, optionalConnectionInfo});
                return;
            }
            KNXException e = !changed ? new KNXTimeoutException("timeout connecting to control endpoint " + this.ctrlEndpt) : (this.state == 3 ? new KNXRemoteException("error response from control endpoint " + this.ctrlEndpt + ": " + this.status) : new KNXInvalidResponseException("invalid connect response from " + this.ctrlEndpt));
            this.connectCleanup(e);
            throw e;
        }
        catch (InterruptedException e) {
            this.connectCleanup(e);
            throw e;
        }
    }

    @Override
    protected void send(byte[] packet, InetSocketAddress dst) throws IOException {
        if (this.tcp) {
            this.connection.send(packet);
        } else {
            super.send(packet, dst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cleanup(int initiator, String reason, LogService.LogLevel level, Throwable t) {
        ClientConnection clientConnection = this;
        synchronized (clientConnection) {
            if (this.cleanup) {
                return;
            }
            this.cleanup = true;
        }
        LogService.log(this.logger, level, "close connection - " + reason, t);
        if (this.heartbeat != null) {
            this.heartbeat.quit();
        }
        this.stopReceiver();
        this.closeSocket();
        this.updateState = true;
        super.cleanup(initiator, reason, level, t);
    }

    @Override
    void doExtraBlockingModes() throws KNXTimeoutException, InterruptedException {
        this.waitForStateChange(4, 3);
        if (this.internalState == 4) {
            KNXTimeoutException e = new KNXTimeoutException("no confirmation reply received for " + this.keepForCon);
            this.logger.warn("response timeout waiting for confirmation", (Throwable)e);
            this.internalState = 0;
            throw e;
        }
    }

    @Override
    protected boolean handleServiceType(KNXnetIPHeader h, byte[] data, int offset, InetAddress src, int port) throws KNXFormatException, IOException {
        int svc = h.getServiceType();
        if (svc == 517) {
            this.logger.warn("received connect request - ignored");
        } else if (svc == 518) {
            ConnectResponse res = new ConnectResponse(data, offset);
            HPAI ep = res.getDataEndpoint();
            if (res.getStatus() == 0 && !(this.tcp ^ ep.getHostProtocol() == 2)) {
                this.channelId = res.getChannelID();
                if (this.tcp) {
                    if (!ep.isRouteBack()) {
                        String msg = "connect response from " + src + ":" + port + " does not contain route-back data endpoint";
                        this.close(3, msg, LogService.LogLevel.ERROR, null);
                        return true;
                    }
                    this.dataEndpt = new InetSocketAddress(src, port);
                } else {
                    this.dataEndpt = this.useNat && (ep.getAddress().isAnyLocalAddress() || ep.getPort() == 0) ? new InetSocketAddress(src, port) : ep.endpoint();
                }
                if (res.getCRD() instanceof TunnelCRD) {
                    this.tunnelingAddress = ((TunnelCRD)res.getCRD()).getAssignedAddress();
                }
                this.checkVersion(h);
                this.setStateNotify(0);
                return true;
            }
            this.status = ep != null && ep.getHostProtocol() != 1 ? "server does not agree with UDP/IP" : res.getStatusString();
            this.setStateNotify(3);
        } else if (svc == 519) {
            this.logger.warn("received connection state request - ignored");
        } else if (svc == 520) {
            if (this.checkVersion(h)) {
                this.heartbeat.setResponse(new ConnectionstateResponse(data, offset));
            }
        } else if (svc == 521) {
            if (this.ctrlEndpt.getAddress().equals(src) && this.ctrlEndpt.getPort() == port) {
                this.disconnectRequested(new DisconnectRequest(data, offset));
            }
        } else if (svc == 522) {
            DisconnectResponse res = new DisconnectResponse(data, offset);
            if (res.getStatus() != 0) {
                this.logger.warn("received disconnect response status 0x" + Integer.toHexString(res.getStatus()) + " (" + ErrorCodes.getErrorMessage(res.getStatus()) + ")");
            }
            this.closing = 2;
            this.setStateNotify(1);
        } else if (svc == this.serviceAck) {
            if (this.tcp) {
                return true;
            }
            ServiceAck res = new ServiceAck(svc, data, offset);
            if (!this.checkChannelId(res.getChannelID(), "acknowledgment")) {
                return true;
            }
            if (res.getSequenceNumber() != this.getSeqSend()) {
                this.logger.warn("received service acknowledgment with wrong send sequence " + res.getSequenceNumber() + ", expected " + this.getSeqSend() + " - ignored");
            } else {
                if (!this.checkVersion(h)) {
                    return true;
                }
                this.incSeqSend();
                this.setStateNotify(res.getStatus() == 0 ? 4 : 3);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("received service ack {} from {} (channel {})", new Object[]{res.getSequenceNumber(), this.ctrlEndpt, this.channelId});
                }
                if (this.internalState == 3) {
                    this.logger.warn("received service acknowledgment status " + res.getStatusString());
                }
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    String connectionState() {
        switch (this.state) {
            case 4: {
                return "cEMI.con pending";
            }
            case -1: {
                return "unknown error";
            }
        }
        return super.connectionState();
    }

    private InetSocketAddress localSocketAddress() {
        return this.tcp ? this.connection.localEndpoint() : this.socket.getLocalSocketAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectRequested(DisconnectRequest req) {
        if (req.getChannelID() == this.channelId) {
            byte[] buf = PacketHelper.toPacket(new DisconnectResponse(this.channelId, 0));
            DatagramPacket p = new DatagramPacket(buf, buf.length, this.ctrlEndpt.getAddress(), this.ctrlEndpt.getPort());
            try {
                this.ctrlSocket.send(p);
            }
            catch (IOException e) {
                this.logger.error("communication failure", (Throwable)e);
            }
            finally {
                this.cleanup(1, "server request", LogService.LogLevel.INFO, null);
            }
        }
    }

    private boolean checkVersion(KNXnetIPHeader h) {
        if (h.getVersion() != 16) {
            this.status = "protocol version changed";
            this.close(3, "protocol version changed", LogService.LogLevel.ERROR, null);
            return false;
        }
        return true;
    }

    private void connectCleanup(Exception thrown) {
        this.stopReceiver();
        this.closeSocket();
        this.setState(1);
        String msg = thrown.getMessage();
        msg = msg != null && msg.length() > 0 ? msg : thrown.getClass().getSimpleName();
        this.logger.error("establishing connection failed, {}", (Object)msg);
    }

    private void closeSocket() {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    private final class HeartbeatMonitor
    extends Thread {
        private static final int CONNECTIONSTATE_REQ_TIMEOUT = 10;
        private static final int HEARTBEAT_INTERVAL = 60;
        private static final int MAX_REQUEST_ATTEMPTS = 4;
        private boolean received;

        HeartbeatMonitor() {
            super("KNXnet/IP heartbeat monitor");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HPAI hpai = ClientConnection.this.tcp ? HPAI.Tcp : new HPAI(1, ClientConnection.this.useNat ? null : ClientConnection.this.localSocketAddress());
            byte[] buf = PacketHelper.toPacket(new ConnectionstateRequest(ClientConnection.this.channelId, hpai));
            try {
                int i;
                block6: do {
                    Thread.sleep(60000L);
                    for (i = 0; i < 4; ++i) {
                        ClientConnection.this.logger.trace("sending connection state request, attempt " + (i + 1));
                        HeartbeatMonitor heartbeatMonitor = this;
                        synchronized (heartbeatMonitor) {
                            this.received = false;
                            ClientConnection.this.send(buf, ClientConnection.this.ctrlEndpt);
                            long remaining = 10000L;
                            long end = System.currentTimeMillis() + remaining;
                            while (!this.received && remaining > 0L) {
                                this.wait(remaining);
                                remaining = end - System.currentTimeMillis();
                            }
                            if (this.received) {
                                continue block6;
                            }
                            continue;
                        }
                    }
                } while (i != 4);
                ClientConnection.this.close(3, "no heartbeat response", LogService.LogLevel.WARN, null);
            }
            catch (InterruptedException i) {
            }
            catch (IOException e) {
                ClientConnection.this.close(3, "heartbeat communication failure", LogService.LogLevel.ERROR, e);
            }
        }

        void quit() {
            this.interrupt();
            if (HeartbeatMonitor.currentThread() == this) {
                return;
            }
            try {
                this.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setResponse(ConnectionstateResponse res) {
            boolean ok = res.getStatus() == 0;
            HeartbeatMonitor heartbeatMonitor = this;
            synchronized (heartbeatMonitor) {
                if (ok) {
                    this.received = true;
                }
                this.notify();
            }
            if (!ok) {
                ClientConnection.this.logger.warn("connection state response: {} (channel {})", (Object)res.getStatusString(), (Object)ClientConnection.this.channelId);
            }
        }
    }
}

