/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.XECPublicKey;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.KnxRuntimeException;
import tuwien.auto.calimero.SerialNumber;
import tuwien.auto.calimero.knxnetip.ClientConnection;
import tuwien.auto.calimero.knxnetip.ConnectionBase;
import tuwien.auto.calimero.knxnetip.KNXConnectionClosedException;
import tuwien.auto.calimero.knxnetip.Net;
import tuwien.auto.calimero.knxnetip.SecureConnection;
import tuwien.auto.calimero.knxnetip.servicetype.KNXnetIPHeader;
import tuwien.auto.calimero.knxnetip.servicetype.PacketHelper;
import tuwien.auto.calimero.knxnetip.util.HPAI;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.secure.KnxSecureException;

public final class Connection
implements Closeable {
    static Connection Udp = new Connection(new InetSocketAddress(0));
    private static final Duration connectionTimeout = Duration.ofMillis(5000L);
    private volatile InetSocketAddress localEndpoint;
    private final InetSocketAddress server;
    private final Socket socket;
    private final Logger logger;
    final Map<Integer, SecureSession> sessions = new ConcurrentHashMap<Integer, SecureSession>();
    private final Map<Integer, ClientConnection> unsecuredConnections = new ConcurrentHashMap<Integer, ClientConnection>();
    private final List<ClientConnection> ongoingConnectRequests = Collections.synchronizedList(new ArrayList());
    private final Lock sessionRequestLock = new ReentrantLock();
    private volatile SecureSession inSessionRequestStage;

    public static Connection newTcpConnection(InetSocketAddress local, InetSocketAddress server) {
        return new Connection(local, server);
    }

    private Connection(InetSocketAddress server) {
        this.server = server;
        this.socket = new Socket();
        this.logger = LoggerFactory.getLogger((String)("calimero.knxnetip.tcp " + Net.hostPort(server)));
    }

    protected Connection(InetSocketAddress local, InetSocketAddress server) {
        this(server);
        if (local.isUnresolved()) {
            throw new KNXIllegalArgumentException("unresolved address " + local);
        }
        InetSocketAddress bind = local;
        if (local.getAddress().isAnyLocalAddress()) {
            try {
                InetAddress addr = Optional.ofNullable(server.getAddress()).flatMap(Net::onSameSubnet).orElse(InetAddress.getLocalHost());
                bind = new InetSocketAddress(addr, local.getPort());
            }
            catch (UnknownHostException e) {
                throw new KnxRuntimeException("no local host address available", e);
            }
        }
        try {
            this.socket.bind(bind);
            this.localEndpoint = (InetSocketAddress)this.socket.getLocalSocketAddress();
        }
        catch (IOException e) {
            throw new KnxRuntimeException("binding to local address " + bind, e);
        }
    }

    public SecureSession newSecureSession(int user, byte[] userKey, byte[] deviceAuthCode) {
        return new SecureSession(this, user, userKey, deviceAuthCode);
    }

    public InetSocketAddress localEndpoint() {
        return this.localEndpoint;
    }

    public InetSocketAddress server() {
        return this.server;
    }

    public boolean isConnected() {
        boolean connected = this.socket.isConnected();
        if (this.socket.isClosed()) {
            return false;
        }
        return connected;
    }

    @Override
    public void close() {
        this.unsecuredConnections.values().forEach(ConnectionBase::close);
        this.unsecuredConnections.clear();
        this.sessions.values().forEach(SecureSession::close);
        this.sessions.clear();
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        String state = this.socket.isClosed() ? "closed" : (this.socket.isConnected() ? "connected" : "bound");
        return Net.hostPort(this.localEndpoint()) + " " + Net.hostPort(this.server) + " (" + state + ")";
    }

    Socket socket() {
        return this.socket;
    }

    void send(byte[] data) throws IOException {
        OutputStream os = this.socket.getOutputStream();
        os.write(data);
        os.flush();
    }

    void registerConnectRequest(ClientConnection c) {
        this.ongoingConnectRequests.add(c);
    }

    void unregisterConnectRequest(ClientConnection c) {
        this.ongoingConnectRequests.remove(c);
        if (c.getState() == 0) {
            this.unsecuredConnections.put(c.channelId, c);
        }
    }

    synchronized void connect() throws IOException {
        if (!this.socket.isConnected()) {
            this.socket.connect(this.server, (int)connectionTimeout.toMillis());
            this.startTcpReceiver();
        }
    }

    private void startTcpReceiver() {
        Thread t = new Thread(this::runReceiveLoop, "KNXnet/IP tcp receiver " + Net.hostPort(this.server));
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runReceiveLoop() {
        int rcvBufferSize = 512;
        byte[] data = new byte[512];
        int offset = 0;
        try {
            InputStream in = this.socket.getInputStream();
            while (!this.socket.isClosed()) {
                int read;
                if (offset >= 6) {
                    try {
                        KNXnetIPHeader header = new KNXnetIPHeader(data, 0);
                        if (header.getTotalLength() <= offset) {
                            int leftover;
                            int length = header.getTotalLength() - header.getStructLength();
                            offset = leftover = offset - header.getTotalLength();
                            if (header.isSecure()) {
                                this.dispatchToSession(header, data, header.getStructLength(), length);
                            } else {
                                this.dispatchToConnection(header, data, header.getStructLength());
                            }
                            if (leftover > 0) {
                                System.arraycopy(data, header.getTotalLength(), data, 0, leftover);
                                continue;
                            }
                        } else if (header.getTotalLength() > 512) {
                            int skip = header.getTotalLength() - offset;
                            while (skip-- > 0 && in.read() != -1) {
                            }
                            offset = 0;
                        }
                    }
                    catch (KNXFormatException | KnxSecureException e) {
                        this.logger.warn("received invalid frame", (Throwable)e);
                        offset = 0;
                    }
                }
                if ((read = in.read(data, offset, data.length - offset)) == -1) {
                    return;
                }
                offset += read;
            }
        }
        catch (InterruptedIOException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException | RuntimeException e) {
            if (!this.socket.isClosed()) {
                this.logger.error("receiver communication failure", (Throwable)e);
            }
        }
        finally {
            this.close();
        }
    }

    private void dispatchToSession(KNXnetIPHeader header, byte[] data, int offset, int length) throws KNXFormatException {
        int sessionId = ByteBuffer.wrap(data, offset, length).getShort() & 0xFFFF;
        if (sessionId == 0) {
            throw new KnxSecureException("no more free secure sessions, or remote endpoint busy");
        }
        SecureSession session = this.sessions.get(sessionId);
        if (session == null && header.getServiceType() == 2386) {
            session = this.inSessionRequestStage;
        }
        if (session != null) {
            session.acceptServiceType(header, data, offset, length);
        } else {
            this.logger.warn("session {} does not exist", (Object)sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchToConnection(KNXnetIPHeader header, byte[] data, int offset) throws IOException, KNXFormatException {
        int svcType = header.getServiceType();
        if (svcType == 524 || svcType == 516) {
            for (ClientConnection client : this.unsecuredConnections.values()) {
                client.handleServiceType(header, data, offset, this.server.getAddress(), this.server.getPort());
            }
            return;
        }
        int channelId = Connection.channelId(header, data, offset);
        ClientConnection connection = this.unsecuredConnections.get(channelId);
        if (connection == null) {
            List<ClientConnection> list = this.ongoingConnectRequests;
            synchronized (list) {
                if (!this.ongoingConnectRequests.isEmpty()) {
                    connection = this.ongoingConnectRequests.remove(0);
                }
            }
        }
        if (connection != null) {
            connection.handleServiceType(header, data, offset, this.server.getAddress(), this.server.getPort());
            if (svcType == 522) {
                this.unsecuredConnections.remove(channelId);
            }
        } else {
            this.logger.warn("communication channel {} does not exist", (Object)channelId);
        }
    }

    private static int channelId(KNXnetIPHeader header, byte[] data, int offset) {
        int channelIdOffset = offset;
        switch (header.getServiceType()) {
            case 784: 
            case 1056: 
            case 1059: 
            case 1061: {
                channelIdOffset = offset + 1;
            }
        }
        int channelId = data[channelIdOffset] & 0xFF;
        return channelId;
    }

    private static void reverse(byte[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            byte b = array[i];
            array[i] = array[array.length - 1 - i];
            array[array.length - 1 - i] = b;
        }
    }

    public static final class SecureSession
    implements AutoCloseable {
        private static final int SecureWrapper = 2384;
        private static final int SecureSessionResponse = 2386;
        private static final int SecureSessionAuth = 2387;
        private static final int SecureSessionStatus = 2388;
        private static final int AuthSuccess = 0;
        private static final int AuthFailed = 1;
        private static final int Unauthenticated = 2;
        private static final int Timeout = 3;
        private static final int KeepAlive = 4;
        private static final int Close = 5;
        private static final int Setup = 6;
        private static final int keyLength = 32;
        private static final int macSize = 16;
        private static final int sessionSetupTimeout = 10000;
        private static final Duration keepAliveInvterval = Duration.ofSeconds(30L);
        private static final ScheduledThreadPoolExecutor keepAliveSender = new ScheduledThreadPoolExecutor(1, r -> {
            Thread t = new Thread(r);
            t.setName("KNX IP Secure session keep-alive");
            t.setDaemon(true);
            return t;
        });
        private static final byte[] emptyUserPwdHash;
        private final Connection conn;
        private final int user;
        private final SecretKey userKey;
        private final SecretKey deviceAuthKey;
        private PrivateKey privateKey;
        private final byte[] publicKey = new byte[32];
        private final SerialNumber sno;
        private int sessionId;
        private volatile SessionState sessionState = SessionState.Idle;
        private volatile int sessionStatus = 6;
        Key secretKey;
        private final AtomicLong sendSeq = new AtomicLong();
        private final AtomicLong rcvSeq = new AtomicLong();
        private Future<?> keepAliveFuture = CompletableFuture.completedFuture(Void.TYPE);
        final Map<Integer, ClientConnection> securedConnections = new ConcurrentHashMap<Integer, ClientConnection>();
        private final List<ClientConnection> ongoingConnectRequests = Collections.synchronizedList(new ArrayList());
        private final Logger logger;

        private SecureSession(Connection connection, int user, byte[] userKey, byte[] deviceAuthCode) {
            this.conn = connection;
            this.user = user;
            byte[] key = userKey.length == 0 ? (byte[])emptyUserPwdHash.clone() : userKey;
            this.userKey = SecureConnection.createSecretKey(key);
            byte[] authCode = deviceAuthCode.length == 0 ? new byte[16] : deviceAuthCode;
            this.deviceAuthKey = SecureConnection.createSecretKey(authCode);
            this.sno = SecureSession.deriveSerialNumber(this.conn.localEndpoint());
            this.logger = LoggerFactory.getLogger((String)("calimero.knxnetip." + SecureConnection.secureSymbol + " Session " + Net.hostPort(this.conn.server)));
        }

        public int id() {
            return this.sessionId;
        }

        public int user() {
            return this.user;
        }

        public SecretKey userKey() {
            return this.userKey;
        }

        public SerialNumber serialNumber() {
            return this.sno;
        }

        public Connection connection() {
            return this.conn;
        }

        @Override
        public void close() {
            if (this.sessionState == SessionState.Idle) {
                return;
            }
            this.sessionState = SessionState.Idle;
            this.keepAliveFuture.cancel(false);
            this.securedConnections.values().forEach(ConnectionBase::close);
            this.securedConnections.clear();
            this.conn.sessions.remove(this.sessionId);
            if (this.conn.socket.isClosed()) {
                return;
            }
            try {
                this.conn.send(this.newStatusInfo(this.sessionId, this.nextSendSeq(), 5));
            }
            catch (IOException e) {
                this.logger.info("I/O error closing secure session {}", (Object)this.sessionId, (Object)e);
            }
        }

        public String toString() {
            return SecureConnection.secureSymbol + " session " + this.sessionId + " (user " + this.user + "): " + this.sessionState;
        }

        SecretKey deviceAuthKey() {
            return this.deviceAuthKey;
        }

        void ensureOpen() throws KNXTimeoutException, KNXConnectionClosedException, InterruptedException {
            if (this.sessionState == SessionState.Authenticated) {
                return;
            }
            this.setupSecureSession();
        }

        void registerConnectRequest(ClientConnection c) {
            this.ongoingConnectRequests.add(c);
        }

        void unregisterConnectRequest(ClientConnection c) {
            this.ongoingConnectRequests.remove(c);
            if (c.getState() == 0) {
                this.securedConnections.put(c.channelId, c);
            }
        }

        long nextSendSeq() {
            return this.sendSeq.getAndIncrement();
        }

        long nextReceiveSeq() {
            return this.rcvSeq.getAndIncrement();
        }

        private void setupSecureSession() throws KNXTimeoutException, KNXConnectionClosedException, InterruptedException {
            this.conn.sessionRequestLock.lock();
            String hostPort = Net.hostPort(this.conn.server);
            try {
                if (this.sessionState == SessionState.Authenticated) {
                    return;
                }
                this.sessionState = SessionState.Idle;
                this.sessionStatus = 6;
                this.conn.inSessionRequestStage = this;
                this.logger.debug("setup secure session with {}", (Object)hostPort);
                this.initKeys();
                this.conn.connect();
                byte[] sessionReq = PacketHelper.newChannelRequest(HPAI.Tcp, this.publicKey);
                this.conn.send(sessionReq);
                this.awaitAuthenticationStatus();
                if (this.sessionState == SessionState.Unauthenticated || this.sessionStatus != 0) {
                    this.sessionState = SessionState.Idle;
                    throw new KnxSecureException("secure session " + SecureConnection.statusMsg(this.sessionStatus));
                }
                if (this.sessionState == SessionState.Idle) {
                    throw new KNXTimeoutException("timeout establishing secure session with " + hostPort);
                }
                long delay = keepAliveInvterval.toMillis();
                this.keepAliveFuture = keepAliveSender.scheduleWithFixedDelay(this::sendKeepAlive, delay, delay, TimeUnit.MILLISECONDS);
            }
            catch (GeneralSecurityException e) {
                throw new KnxSecureException("error creating key pair for " + hostPort, e);
            }
            catch (SocketTimeoutException e) {
                Thread.currentThread().interrupt();
                throw new InterruptedException("interrupted I/O establishing secure session with " + hostPort + ": " + e.getMessage());
            }
            catch (IOException e) {
                this.close();
                this.conn.close();
                throw new KNXConnectionClosedException("I/O error establishing secure session with " + hostPort, e);
            }
            finally {
                this.conn.sessionRequestLock.unlock();
                Arrays.fill(this.publicKey, (byte)0);
            }
        }

        private void initKeys() throws NoSuchAlgorithmException {
            KeyPair keyPair = SecureSession.generateKeyPair();
            this.privateKey = keyPair.getPrivate();
            BigInteger u = ((XECPublicKey)keyPair.getPublic()).getU();
            byte[] tmp = u.toByteArray();
            Connection.reverse(tmp);
            System.arraycopy(tmp, 0, this.publicKey, 0, tmp.length);
            Arrays.fill(tmp, (byte)0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void awaitAuthenticationStatus() throws InterruptedException, KNXTimeoutException {
            long end = System.nanoTime() / 1000000L + 10000L;
            long remaining = 10000L;
            boolean inAuth = false;
            while (remaining > 0L && this.sessionState != SessionState.Authenticated && this.sessionStatus == 6) {
                SecureSession secureSession = this;
                synchronized (secureSession) {
                    this.wait(remaining);
                }
                remaining = end - System.nanoTime() / 1000000L;
                if (this.sessionState != SessionState.Unauthenticated || inAuth) continue;
                inAuth = true;
                end = end - remaining + 10000L;
            }
            if (remaining <= 0L) {
                throw new KNXTimeoutException("timeout establishing secure session with " + Net.hostPort(this.conn.server));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean acceptServiceType(KNXnetIPHeader h, byte[] data, int offset, int length) throws KNXFormatException {
            int svc = h.getServiceType();
            if (!h.isSecure()) {
                throw new KnxSecureException(String.format("dispatched insecure service type 0x%h to %s", svc, this));
            }
            if (h.getTotalLength() < 44) {
                return false;
            }
            if (svc == 2386) {
                if (this.sessionState != SessionState.Idle) {
                    this.logger.warn("received session response in state {} - ignore", (Object)this.sessionState);
                    return true;
                }
                try {
                    byte[] serverPublicKey = this.parseSessionResponse(h, data, offset, this.conn.server);
                    byte[] auth = this.newSessionAuth(serverPublicKey);
                    this.sessionState = SessionState.Unauthenticated;
                    byte[] packet = this.wrap(auth);
                    this.logger.debug("secure session {}, request access for user {}", (Object)this.sessionId, (Object)this.user);
                    this.conn.send(packet);
                }
                catch (IOException | RuntimeException e) {
                    this.sessionStatus = 1;
                    this.logger.error("negotiating session key failed", (Throwable)e);
                }
                SecureSession e = this;
                synchronized (e) {
                    this.notifyAll();
                }
            }
            if (svc == 2384) {
                byte[] packet = this.unwrap(h, data, offset);
                KNXnetIPHeader plainHeader = new KNXnetIPHeader(packet, 0);
                int hdrLen = plainHeader.getStructLength();
                if (plainHeader.getServiceType() == 2388) {
                    this.sessionStatus = SecureConnection.newChannelStatus(plainHeader, packet, hdrLen);
                    if (this.sessionState == SessionState.Unauthenticated) {
                        if (this.sessionStatus == 0) {
                            this.sessionState = SessionState.Authenticated;
                        }
                        LogService.log(this.logger, this.sessionStatus == 0 ? LogService.LogLevel.DEBUG : LogService.LogLevel.ERROR, "{} {}", SecureConnection.statusMsg(this.sessionStatus), this);
                        SecureSession secureSession = this;
                        synchronized (secureSession) {
                            this.notifyAll();
                        }
                    } else if (this.sessionStatus == 3 || this.sessionStatus == 2) {
                        this.logger.error("{} {}", (Object)SecureConnection.statusMsg(this.sessionStatus), (Object)this);
                        this.close();
                    }
                } else {
                    this.dispatchToConnection(plainHeader, packet, hdrLen, plainHeader.getTotalLength() - hdrLen);
                }
            } else {
                this.logger.warn("received unsupported secure service type 0x{} - ignore", (Object)Integer.toHexString(svc));
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchToConnection(KNXnetIPHeader header, byte[] data, int offset, int length) {
            int svcType = header.getServiceType();
            if (svcType == 524 || svcType == 516) {
                for (ClientConnection client : this.securedConnections.values()) {
                    try {
                        client.handleServiceType(header, data, offset, this.conn.server.getAddress(), this.conn.server.getPort());
                    }
                    catch (KNXFormatException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return;
            }
            int channelId = Connection.channelId(header, data, offset);
            ClientConnection connection = this.securedConnections.get(channelId);
            if (connection == null) {
                List<ClientConnection> e = this.ongoingConnectRequests;
                synchronized (e) {
                    if (!this.ongoingConnectRequests.isEmpty()) {
                        connection = this.ongoingConnectRequests.remove(0);
                    }
                }
            }
            try {
                if (connection != null) {
                    connection.handleServiceType(header, data, offset, this.conn.server.getAddress(), this.conn.server.getPort());
                    if (header.getServiceType() == 522) {
                        this.logger.trace("remove connection {}", (Object)connection);
                        this.securedConnections.remove(channelId);
                    }
                } else {
                    this.logger.warn("communication channel {} does not exist", (Object)channelId);
                }
            }
            catch (IOException | KNXFormatException e) {
                e.printStackTrace();
            }
        }

        private void sendKeepAlive() {
            block2: {
                try {
                    this.logger.trace("sending keep-alive");
                    this.conn.send(this.newStatusInfo(this.sessionId, this.nextSendSeq(), 4));
                }
                catch (IOException e) {
                    if (this.sessionState != SessionState.Authenticated || this.conn.socket.isClosed()) break block2;
                    this.logger.warn("error sending keep-alive: {}", (Object)e.getMessage());
                    this.close();
                    this.conn.close();
                }
            }
        }

        private byte[] wrap(byte[] plainPacket) {
            return SecureConnection.newSecurePacket(this.sessionId, this.nextSendSeq(), this.sno, 0, plainPacket, this.secretKey);
        }

        private byte[] unwrap(KNXnetIPHeader h, byte[] data, int offset) throws KNXFormatException {
            Object[] fields = SecureConnection.unwrap(h, data, offset, this.secretKey);
            int sid = (Integer)fields[0];
            if (sid != this.sessionId) {
                throw new KnxSecureException("secure session mismatch: received ID " + sid + ", expected " + this.sessionId);
            }
            long seq = (Long)fields[1];
            if (seq < this.rcvSeq.get()) {
                throw new KnxSecureException("received secure packet with sequence " + seq + " < expected " + this.rcvSeq);
            }
            this.rcvSeq.incrementAndGet();
            SerialNumber sn = (SerialNumber)fields[2];
            int tag = (Integer)fields[3];
            if (tag != 0) {
                throw new KnxSecureException("expected message tag 0, received " + tag);
            }
            byte[] knxipPacket = (byte[])fields[4];
            this.logger.trace("received (seq {} S/N {}) {}", new Object[]{seq, sn, DataUnitBuilder.toHex(knxipPacket, " ")});
            return knxipPacket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] parseSessionResponse(KNXnetIPHeader h, byte[] data, int offset, InetSocketAddress remote) throws KNXFormatException {
            if (h.getServiceType() != 2386) {
                throw new IllegalArgumentException("no secure channel response");
            }
            if (h.getTotalLength() != 56) {
                throw new KNXFormatException("invalid length " + data.length + " for a secure session response");
            }
            ByteBuffer buffer = ByteBuffer.wrap(data, offset, h.getTotalLength() - h.getStructLength());
            this.sessionId = buffer.getShort() & 0xFFFF;
            if (this.sessionId == 0) {
                throw new KnxSecureException("no more free secure sessions, or remote endpoint busy");
            }
            byte[] serverPublicKey = new byte[32];
            buffer.get(serverPublicKey);
            byte[] sharedSecret = SecureConnection.keyAgreement(this.privateKey, serverPublicKey);
            byte[] sessionKey = SecureConnection.sessionKey(sharedSecret);
            SecureSession secureSession = this;
            synchronized (secureSession) {
                this.secretKey = SecureConnection.createSecretKey(sessionKey);
            }
            this.conn.sessions.put(this.sessionId, this);
            this.conn.inSessionRequestStage = null;
            boolean skipDeviceAuth = Arrays.equals(this.deviceAuthKey.getEncoded(), new byte[16]);
            if (skipDeviceAuth) {
                this.logger.warn("skipping device authentication of {} (no device key)", (Object)Net.hostPort(remote));
            } else {
                ByteBuffer mac = SecureConnection.decrypt(buffer, this.deviceAuthKey, SecureConnection.securityInfo(new byte[16], 0, 65280));
                int msgLen = h.getStructLength() + 2 + 32;
                ByteBuffer macInput = ByteBuffer.allocate(18 + msgLen);
                macInput.put(new byte[16]);
                macInput.put((byte)0);
                macInput.put((byte)msgLen);
                macInput.put(h.toByteArray());
                macInput.putShort((short)this.sessionId);
                macInput.put(SecureConnection.xor(serverPublicKey, 0, this.publicKey, 0, 32));
                byte[] verifyAgainst = this.cbcMacSimple(this.deviceAuthKey, macInput.array(), 0, macInput.capacity());
                boolean authenticated = Arrays.equals(mac.array(), verifyAgainst);
                if (!authenticated) {
                    String packet = DataUnitBuilder.toHex(Arrays.copyOfRange(data, offset - 6, offset - 6 + 56), " ");
                    throw new KnxSecureException("authentication failed for session response " + packet);
                }
            }
            return serverPublicKey;
        }

        private byte[] newSessionAuth(byte[] serverPublicKey) {
            KNXnetIPHeader header = new KNXnetIPHeader(2387, 18);
            ByteBuffer buffer = ByteBuffer.allocate(header.getTotalLength());
            buffer.put(header.toByteArray());
            buffer.putShort((short)this.user);
            int msgLen = 40;
            ByteBuffer macInput = ByteBuffer.allocate(58);
            macInput.put(new byte[16]);
            macInput.put((byte)0);
            macInput.put((byte)40);
            macInput.put(buffer.array(), 0, buffer.position());
            macInput.put(SecureConnection.xor(serverPublicKey, 0, this.publicKey, 0, 32));
            byte[] mac = this.cbcMacSimple(this.userKey, macInput.array(), 0, macInput.capacity());
            SecureConnection.encrypt(mac, 0, this.userKey, SecureConnection.securityInfo(new byte[16], 8, 65280));
            buffer.put(mac);
            return buffer.array();
        }

        private byte[] newStatusInfo(int sessionId, long seq, int status) {
            ByteBuffer packet = ByteBuffer.allocate(8);
            packet.put(new KNXnetIPHeader(2388, 2).toByteArray());
            packet.put((byte)status);
            boolean msgTag = false;
            return SecureConnection.newSecurePacket(sessionId, seq, this.sno, 0, packet.array(), this.secretKey);
        }

        private byte[] cbcMacSimple(Key secretKey, byte[] data, int offset, int length) {
            byte[] log = Arrays.copyOfRange(data, offset, offset + length);
            this.logger.trace("authenticating (length {}): {}", (Object)length, (Object)DataUnitBuilder.toHex(log, " "));
            try {
                Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
                IvParameterSpec ivSpec = new IvParameterSpec(new byte[16]);
                cipher.init(1, secretKey, ivSpec);
                byte[] padded = Arrays.copyOfRange(data, offset, (length + 15) / 16 * 16);
                byte[] result = cipher.doFinal(padded);
                byte[] mac = Arrays.copyOfRange(result, result.length - 16, result.length);
                return mac;
            }
            catch (GeneralSecurityException e) {
                throw new KnxSecureException("calculating CBC-MAC of " + DataUnitBuilder.toHex(log, " "), e);
            }
        }

        private static KeyPair generateKeyPair() throws NoSuchAlgorithmException {
            KeyPairGenerator gen = KeyPairGenerator.getInstance("X25519");
            return gen.generateKeyPair();
        }

        private static SerialNumber deriveSerialNumber(InetSocketAddress localEP) {
            try {
                if (localEP != null) {
                    return SecureSession.deriveSerialNumber(NetworkInterface.getByInetAddress(localEP.getAddress()));
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            return SerialNumber.Zero;
        }

        private static SerialNumber deriveSerialNumber(NetworkInterface netif) {
            try {
                byte[] hardwareAddress;
                if (netif != null && (hardwareAddress = netif.getHardwareAddress()) != null) {
                    return SerialNumber.from(Arrays.copyOf(hardwareAddress, 6));
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            return SerialNumber.Zero;
        }

        static {
            keepAliveSender.setKeepAliveTime(90L, TimeUnit.SECONDS);
            keepAliveSender.allowCoreThreadTimeOut(true);
            emptyUserPwdHash = new byte[]{-23, -61, 4, -71, 20, -93, 81, 117, -3, 125, 28, 103, 58, -75, 47, -31};
        }

        private static enum SessionState {
            Idle,
            Unauthenticated,
            Authenticated;

        }
    }
}

