/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import org.slf4j.Logger;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.KNXAckTimeoutException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXListener;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.internal.EventListeners;
import tuwien.auto.calimero.knxnetip.KNXConnectionClosedException;
import tuwien.auto.calimero.knxnetip.KNXnetIPConnection;
import tuwien.auto.calimero.knxnetip.Net;
import tuwien.auto.calimero.knxnetip.ReceiverLoop;
import tuwien.auto.calimero.knxnetip.servicetype.DisconnectRequest;
import tuwien.auto.calimero.knxnetip.servicetype.ErrorCodes;
import tuwien.auto.calimero.knxnetip.servicetype.KNXnetIPHeader;
import tuwien.auto.calimero.knxnetip.servicetype.PacketHelper;
import tuwien.auto.calimero.knxnetip.servicetype.RoutingIndication;
import tuwien.auto.calimero.knxnetip.servicetype.ServiceRequest;
import tuwien.auto.calimero.knxnetip.util.HPAI;
import tuwien.auto.calimero.log.LogService;

public abstract class ConnectionBase
implements KNXnetIPConnection {
    public static final int ACK_PENDING = 2;
    public static final int ACK_ERROR = 3;
    static final int CONNECT_REQ_TIMEOUT = 10;
    protected DatagramSocket ctrlSocket;
    protected DatagramSocket socket;
    protected InetSocketAddress ctrlEndpt;
    protected InetSocketAddress dataEndpt;
    protected int channelId;
    protected boolean useNat;
    protected final int serviceRequest;
    protected final int serviceAck;
    protected final EventListeners<KNXListener> listeners = new EventListeners();
    protected Logger logger;
    volatile int state = 1;
    protected volatile int internalState = 1;
    volatile boolean updateState = true;
    volatile int closing;
    final int maxSendAttempts;
    final int responseTimeout;
    CEMI keepForCon;
    private ReceiverLoop receiver;
    final Object lock = new Object();
    private int seqRcv;
    private int seqSend;
    private final Semaphore sendWaitQueue = new Semaphore();
    private boolean inBlockingSend;

    protected ConnectionBase(int serviceRequest, int serviceAck, int maxSendAttempts, int responseTimeout) {
        this.serviceRequest = serviceRequest;
        this.serviceAck = serviceAck;
        this.maxSendAttempts = maxSendAttempts;
        this.responseTimeout = responseTimeout;
    }

    @Override
    public void addConnectionListener(KNXListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeConnectionListener(KNXListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void send(CEMI frame, KNXnetIPConnection.BlockingMode mode) throws KNXTimeoutException, KNXConnectionClosedException, InterruptedException {
        if (this.state == 1) {
            throw new KNXConnectionClosedException("send attempt on closed connection");
        }
        if (this.state < 0) {
            this.logger.error("send invoked in error state " + this.state + " - aborted");
            throw new IllegalStateException("in error state, send aborted");
        }
        this.sendWaitQueue.acquire(mode != KNXnetIPConnection.BlockingMode.NonBlocking);
        var3_3 = this.lock;
        synchronized (var3_3) {
            block23: {
                if (mode == KNXnetIPConnection.BlockingMode.NonBlocking && this.state != 0 && this.state != 3) {
                    this.logger.warn("nonblocking send invoked while waiting for data response in state " + this.state + " - aborted");
                    this.sendWaitQueue.release(false);
                    throw new IllegalStateException("waiting for data response");
                }
                try {
                    if (this.state == 1) {
                        throw new KNXConnectionClosedException("send attempt on closed connection");
                    }
                    this.updateState = mode == KNXnetIPConnection.BlockingMode.NonBlocking;
                    this.inBlockingSend = mode != KNXnetIPConnection.BlockingMode.NonBlocking;
                    buf = this.serviceRequest == 1328 ? PacketHelper.toPacket(new RoutingIndication(frame)) : PacketHelper.toPacket(new ServiceRequest(this.serviceRequest, this.channelId, this.getSeqSend(), frame));
                    this.keepForCon = frame;
                    attempt = 0;
lbl21:
                    // 2 sources

                    while (attempt < this.maxSendAttempts) {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("sending cEMI frame seq {}, {}, attempt {} (channel {}) {}", new Object[]{this.getSeqSend(), mode, attempt + 1, this.channelId, DataUnitBuilder.toHex(buf, " ")});
                        }
                        this.send(buf, this.dataEndpt);
                        if (this.serviceRequest == 1328) {
                            this.updateState = true;
                            this.setState(this.internalState);
                            this.inBlockingSend = false;
                            if (mode == KNXnetIPConnection.BlockingMode.NonBlocking) {
                                if (this.serviceRequest != 1328) return;
                            }
                            this.sendWaitQueue.release(mode != KNXnetIPConnection.BlockingMode.NonBlocking);
                            break block23;
                        }
                        ** GOTO lbl-1000
                    }
                    ** GOTO lbl72
                }
                catch (InterruptedIOException e) {
                    try {
                        throw new InterruptedException("interrupted I/O, " + e);
                        catch (IOException e) {
                            this.close(3, "communication failure", LogService.LogLevel.ERROR, e);
                            throw new KNXConnectionClosedException("connection closed", e);
                        }
                    }
                    catch (Throwable var7_9) {
                        this.updateState = true;
                        this.setState(this.internalState);
                        this.inBlockingSend = false;
                        if (mode == KNXnetIPConnection.BlockingMode.NonBlocking) {
                            if (this.serviceRequest != 1328) throw var7_9;
                        }
                        this.sendWaitQueue.release(mode != KNXnetIPConnection.BlockingMode.NonBlocking);
                        throw var7_9;
                    }
                }
            }
            return;
lbl-1000:
            // 1 sources

            {
                block24: {
                    if (this.socket != null) break block24;
                    this.internalState = 4;
                    ** GOTO lbl72
                }
                this.internalState = 2;
                this.state = 2;
                if (mode != KNXnetIPConnection.BlockingMode.NonBlocking) ** GOTO lbl-1000
                this.updateState = true;
                this.setState(this.internalState);
                this.inBlockingSend = false;
                if (mode == KNXnetIPConnection.BlockingMode.NonBlocking) {
                    if (this.serviceRequest != 1328) return;
                }
                this.sendWaitQueue.release(mode != KNXnetIPConnection.BlockingMode.NonBlocking);
            }
            return;
lbl-1000:
            // 1 sources

            {
                block25: {
                    this.waitForStateChange(2, this.responseTimeout);
                    if (this.internalState == 4 || this.internalState == 0) break block25;
                    if (this.internalState == 1) {
                        throw new KNXConnectionClosedException("waiting for service ack");
                    }
                    ++attempt;
                    ** GOTO lbl21
                }
                if (attempt == this.maxSendAttempts) {
                    e = new KNXAckTimeoutException("maximum send attempts, no service acknowledgment received");
                    this.close(3, "maximum send attempts", LogService.LogLevel.ERROR, e);
                    throw e;
                }
                this.state = this.internalState;
                if (mode != KNXnetIPConnection.BlockingMode.WaitForAck) {
                    this.doExtraBlockingModes();
                }
                this.updateState = true;
                this.setState(this.internalState);
                this.inBlockingSend = false;
                if (mode == KNXnetIPConnection.BlockingMode.NonBlocking) {
                    if (this.serviceRequest != 1328) return;
                }
                this.sendWaitQueue.release(mode != KNXnetIPConnection.BlockingMode.NonBlocking);
            }
            return;
        }
    }

    protected void send(byte[] packet, InetSocketAddress dst) throws IOException {
        DatagramPacket p = new DatagramPacket(packet, packet.length, dst);
        if (dst.equals(this.dataEndpt)) {
            this.socket.send(p);
        } else {
            this.ctrlSocket.send(p);
        }
    }

    @Override
    public final InetSocketAddress getRemoteAddress() {
        if (this.state == 1) {
            return new InetSocketAddress(0);
        }
        return this.ctrlEndpt;
    }

    @Override
    public final int getState() {
        return this.state;
    }

    @Override
    public String getName() {
        return Net.hostPort(this.ctrlEndpt);
    }

    @Override
    public final void close() {
        this.close(0, "user request", LogService.LogLevel.DEBUG, null);
    }

    public String toString() {
        return this.getName() + (String)(this.channelId != 0 ? " channel " + this.channelId : "") + " (state " + this.connectionState() + ")";
    }

    protected synchronized int getSeqRcv() {
        return this.seqRcv;
    }

    protected synchronized void incSeqRcv() {
        this.seqRcv = this.seqRcv + 1 & 0xFF;
    }

    protected synchronized int getSeqSend() {
        return this.seqSend;
    }

    protected synchronized void incSeqSend() {
        this.seqSend = this.seqSend + 1 & 0xFF;
    }

    protected void fireFrameReceived(CEMI frame) {
        FrameEvent fe = new FrameEvent((Object)this, frame);
        this.listeners.fire(l -> l.frameReceived(fe));
    }

    boolean handleServiceType(KNXnetIPHeader h, byte[] data, int offset, InetSocketAddress source) throws KNXFormatException, IOException {
        return this.handleServiceType(h, data, offset, source.getAddress(), source.getPort());
    }

    protected boolean handleServiceType(KNXnetIPHeader h, byte[] data, int offset, InetAddress src, int port) throws KNXFormatException, IOException {
        return false;
    }

    protected final void setState(int newState) {
        if (this.closing < 2) {
            if (this.internalState == 0 && newState == 4) {
                return;
            }
            this.internalState = newState;
            if (this.updateState) {
                this.state = newState;
            }
        } else {
            this.internalState = 1;
            this.state = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setStateNotify(int newState) {
        Object object = this.lock;
        synchronized (object) {
            this.setState(newState);
            if (newState == 0 && !this.inBlockingSend) {
                this.sendWaitQueue.release(false);
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(int initiator, String reason, LogService.LogLevel level, Throwable t) {
        Object object = this;
        synchronized (object) {
            if (this.closing > 0) {
                return;
            }
            this.closing = 1;
        }
        try {
            object = this.lock;
            synchronized (object) {
                boolean tcp;
                boolean bl = tcp = this.ctrlSocket == null;
                HPAI hpai = tcp ? HPAI.Tcp : new HPAI(1, this.useNat ? null : (InetSocketAddress)this.ctrlSocket.getLocalSocketAddress());
                this.logger.trace("sending disconnect request for {}", (Object)this);
                byte[] buf = PacketHelper.toPacket(new DisconnectRequest(this.channelId, hpai));
                this.send(buf, this.ctrlEndpt);
                long remaining = 10000L;
                long end = System.currentTimeMillis() + remaining;
                while (this.closing == 1 && remaining > 0L) {
                    this.lock.wait(remaining);
                    remaining = end - System.currentTimeMillis();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException | RuntimeException e) {
            this.logger.error("send disconnect failed", (Throwable)e);
        }
        this.cleanup(initiator, reason, level, t);
    }

    protected void cleanup(int initiator, String reason, LogService.LogLevel level, Throwable t) {
        this.setStateNotify(1);
        this.fireConnectionClosed(initiator, reason);
        this.listeners.removeAll();
    }

    protected boolean supportedVersion(KNXnetIPHeader h) {
        boolean supported;
        boolean bl = supported = h.getVersion() == 16;
        if (!supported) {
            this.logger.warn("KNXnet/IP {}.{} {}", new Object[]{h.getVersion() >> 4, h.getVersion() & 0xF, ErrorCodes.getErrorMessage(2)});
        }
        return supported;
    }

    protected boolean checkChannelId(int id, String svcType) {
        if (id == this.channelId) {
            return true;
        }
        this.logger.warn("received service " + svcType + " with wrong channel ID " + id + ", expected " + this.channelId + " - ignored");
        return false;
    }

    protected ServiceRequest getServiceRequest(KNXnetIPHeader h, byte[] data, int offset) throws KNXFormatException {
        try {
            return PacketHelper.getServiceRequest(h, data, offset);
        }
        catch (KNXFormatException e) {
            ServiceRequest req = PacketHelper.getEmptyServiceRequest(h, data, offset);
            this.logger.warn("received request with unknown cEMI data " + DataUnitBuilder.toHex(Arrays.copyOfRange(data, offset + 4, offset + h.getTotalLength() - h.getStructLength()), " "), (Throwable)e);
            return req;
        }
    }

    final void startReceiver() {
        if (this.receiver == null) {
            ReceiverLoop looper = new ReceiverLoop(this, this.socket, 512);
            Thread t = new Thread((Runnable)looper, "KNXnet/IP receiver");
            t.setDaemon(true);
            t.start();
            this.receiver = looper;
        }
    }

    final void stopReceiver() {
        if (this.receiver != null) {
            this.receiver.quit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForStateChange(int initialState, int timeout) throws InterruptedException {
        boolean changed = false;
        long remaining = (long)timeout * 1000L;
        long end = System.currentTimeMillis() + remaining;
        Object object = this.lock;
        synchronized (object) {
            while (this.internalState == initialState && remaining > 0L) {
                this.lock.wait(remaining);
                remaining = end - System.currentTimeMillis();
            }
        }
        changed = remaining > 0L;
        return changed;
    }

    void doExtraBlockingModes() throws KNXTimeoutException, InterruptedException {
    }

    String connectionState() {
        switch (this.state) {
            case 0: {
                return "OK";
            }
            case 1: {
                return "closed";
            }
            case 2: {
                return "ACK pending";
            }
            case 3: {
                return "ACK error";
            }
        }
        return "unknown";
    }

    private void fireConnectionClosed(int initiator, String reason) {
        CloseEvent ce = new CloseEvent(this, initiator, reason);
        this.listeners.fire(l -> l.connectionClosed(ce));
    }

    private static final class Semaphore {
        private Node head;
        private Node tail;
        private int cnt = 1;
        private int nonblockingCnt = 0;

        Semaphore() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void acquire(boolean blocking) {
            Node n;
            boolean interrupted = false;
            Object object = this;
            synchronized (object) {
                if (this.cnt > 0 && this.tail == null) {
                    --this.cnt;
                    if (!blocking) {
                        ++this.nonblockingCnt;
                    }
                    return;
                }
                if (!blocking) {
                    ++this.nonblockingCnt;
                    return;
                }
                n = this.enqueue();
            }
            object = n;
            synchronized (object) {
                while (n.blocked) {
                    try {
                        n.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
            }
            object = this;
            synchronized (object) {
                this.dequeue();
                --this.cnt;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }

        synchronized void release(boolean blocking) {
            if (blocking) {
                if (++this.cnt > 0) {
                    this.notifyNext();
                }
            } else if (this.nonblockingCnt > 0) {
                --this.nonblockingCnt;
                if (this.nonblockingCnt == 0 && ++this.cnt > 0) {
                    this.notifyNext();
                }
            }
        }

        private Node enqueue() {
            Node n = new Node(null);
            if (this.tail == null) {
                this.tail = n;
            } else {
                this.head.next = n;
            }
            this.head = n;
            return this.head;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyNext() {
            if (this.tail != null) {
                Node node = this.tail;
                synchronized (node) {
                    this.tail.blocked = false;
                    this.tail.notify();
                }
            }
        }

        private void dequeue() {
            this.tail = this.tail.next;
            if (this.tail == null) {
                this.head = null;
            }
        }

        private static final class Node {
            Node next;
            boolean blocked;

            Node(Node n) {
                this.next = n;
                this.blocked = true;
            }
        }
    }
}

