/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXInvalidResponseException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.KnxRuntimeException;
import tuwien.auto.calimero.internal.UdpSocketLooper;
import tuwien.auto.calimero.knxnetip.Connection;
import tuwien.auto.calimero.knxnetip.KNXnetIPTunnel;
import tuwien.auto.calimero.knxnetip.Net;
import tuwien.auto.calimero.knxnetip.SecureConnection;
import tuwien.auto.calimero.knxnetip.servicetype.DescriptionRequest;
import tuwien.auto.calimero.knxnetip.servicetype.DescriptionResponse;
import tuwien.auto.calimero.knxnetip.servicetype.KNXnetIPHeader;
import tuwien.auto.calimero.knxnetip.servicetype.PacketHelper;
import tuwien.auto.calimero.knxnetip.servicetype.SearchRequest;
import tuwien.auto.calimero.knxnetip.servicetype.SearchResponse;
import tuwien.auto.calimero.knxnetip.servicetype.ServiceType;
import tuwien.auto.calimero.knxnetip.util.CRI;
import tuwien.auto.calimero.knxnetip.util.Srp;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;
import tuwien.auto.calimero.log.LogService;

public class Discoverer {
    public static final String LOG_SERVICE = "calimero.knxnetip.Discoverer";
    public static final String SEARCH_MULTICAST = "224.0.23.12";
    public static final int SEARCH_PORT = 3671;
    private static final Logger logger = LogService.getLogger("calimero.knxnetip.Discoverer");
    static final InetAddress SYSTEM_SETUP_MULTICAST;
    private InetAddress host;
    private final int port;
    private final boolean nat;
    private final boolean mcast;
    private Connection connection;
    private Connection.SecureSession session;
    private volatile Duration timeout;
    private final List<ReceiverLoop> receivers = Collections.synchronizedList(new ArrayList());
    private final List<Result<SearchResponse>> responses = Collections.synchronizedList(new ArrayList());
    private static ExecutorService executor;

    public static Discoverer tcp(Connection c) {
        return new Discoverer(c);
    }

    public static Discoverer secure(Connection.SecureSession session) {
        return new Discoverer(session);
    }

    public Discoverer(int localPort, boolean natAware) {
        this(null, localPort, natAware, false);
    }

    public Discoverer(InetAddress localHost, int localPort, boolean natAware, boolean mcastResponse) {
        if (localPort < 0 || localPort > 65535) {
            throw new KNXIllegalArgumentException("port out of range [0..0xFFFF]");
        }
        this.host = localHost;
        this.port = localPort;
        this.nat = natAware;
        this.mcast = mcastResponse;
        if (this.host != null && this.host.getAddress().length != 4 && !this.nat) {
            throw new KNXIllegalArgumentException("IPv4 address required if NAT is not used (supplied " + this.host.getHostAddress() + ")");
        }
    }

    private Discoverer(Connection c) {
        this.host = null;
        this.port = 0;
        this.nat = false;
        this.mcast = false;
        this.connection = c;
    }

    private Discoverer(Connection.SecureSession session) {
        this.host = null;
        this.port = 0;
        this.nat = false;
        this.mcast = false;
        this.connection = session.connection();
        this.session = session;
    }

    public Discoverer timeout(Duration timeout) {
        if (timeout.isNegative() || timeout.isZero()) {
            throw new KNXIllegalArgumentException("timeout <= 0");
        }
        this.timeout = timeout;
        return this;
    }

    private CompletableFuture<List<Result<SearchResponse>>> search(Duration timeout) {
        try {
            return this.searchAsync(timeout, new Srp[0]);
        }
        catch (KNXException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletableFuture<List<Result<SearchResponse>>> search(Srp ... searchParameters) {
        if (this.connection != null) {
            return this.tcpSearch(searchParameters).thenApply(List::of);
        }
        try {
            return this.searchAsync(this.timeoutOrDefault(), searchParameters);
        }
        catch (KNXException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletableFuture<Result<SearchResponse>> search(InetSocketAddress serverControlEndpoint, Srp ... searchParameters) throws KNXException {
        if (this.connection != null) {
            return this.tcpSearch(searchParameters);
        }
        InetAddress addr = this.nat ? this.host : (this.host != null ? this.host : Net.onSameSubnet(serverControlEndpoint.getAddress()).orElseGet(Discoverer::localHost));
        try {
            DatagramChannel dc = Discoverer.newChannel(new InetSocketAddress(addr, this.port));
            InetSocketAddress local = (InetSocketAddress)dc.getLocalAddress();
            logger.debug("search {} -> server control endpoint {}", (Object)Net.hostPort(local), (Object)Net.hostPort(serverControlEndpoint));
            boolean tcp = false;
            InetSocketAddress res = this.nat ? new InetSocketAddress(0) : local;
            byte[] request = PacketHelper.toPacket(new SearchRequest(res, searchParameters));
            dc.send(ByteBuffer.wrap(request), serverControlEndpoint);
            return this.receiveAsync(dc, serverControlEndpoint, this.timeoutOrDefault());
        }
        catch (IOException e) {
            throw new KNXException("search request to " + Net.hostPort(serverControlEndpoint) + " failed on " + addr, e);
        }
    }

    private static InetAddress localHost() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new KnxRuntimeException("local IP required, but getting local host failed");
        }
    }

    private CompletableFuture<Result<SearchResponse>> tcpSearch(Srp ... searchParameters) {
        SearchRequest req = SearchRequest.newTcpRequest(searchParameters);
        return this.tcpSend(PacketHelper.toPacket(req));
    }

    private <T> CompletableFuture<Result<T>> tcpSend(byte[] packet) {
        try {
            CompletableFuture cf = new CompletableFuture();
            Tunnel tunnel = new Tunnel(KNXnetIPTunnel.TunnelingLayer.LinkLayer, this.connection, KNXMediumSettings.BackboneRouter, cf);
            tunnel.send(packet);
            cf.whenCompleteAsync((_1, _2) -> tunnel.close());
            return cf.orTimeout(this.timeoutOrDefault().toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (IOException | InterruptedException | KNXException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private Duration timeoutOrDefault() {
        return this.timeout != null ? this.timeout : Duration.ofSeconds(10L);
    }

    public void startSearch(NetworkInterface ni, int timeout, boolean wait) throws KNXException, InterruptedException {
        this.startSearch(this.port, ni, timeout, wait);
    }

    public void startSearch(int localPort, NetworkInterface ni, int timeout, boolean wait) throws KNXException, InterruptedException {
        if (timeout < 0) {
            throw new KNXIllegalArgumentException("timeout has to be >= 0");
        }
        if (localPort < 0 || localPort > 65535) {
            throw new KNXIllegalArgumentException("port out of range [0..0xFFFF]");
        }
        List l = Optional.ofNullable(ni).map(NetworkInterface::getInetAddresses).map(Collections::list).orElse(new ArrayList());
        InetAddress addr = l.stream().filter(ia -> this.nat || ia instanceof Inet4Address).findFirst().orElse(this.host(null));
        CompletableFuture<Void> cf = this.search(addr, localPort, ni, Duration.ofSeconds(timeout), this.responses::add, new Srp[0]);
        if (wait) {
            try {
                cf.get();
            }
            catch (CancellationException | ExecutionException e) {
                logger.error("search completed with error", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startSearch(int timeout, boolean wait) throws KNXException, InterruptedException {
        CompletableFuture<List<Result<SearchResponse>>> search = this.search(Duration.ofSeconds(timeout));
        if (!wait) {
            return;
        }
        try {
            search.get();
        }
        catch (CancellationException | ExecutionException e) {
            logger.error("search completed with error", (Throwable)e);
        }
        finally {
            this.stopSearch();
        }
    }

    private CompletableFuture<List<Result<SearchResponse>>> searchAsync(Duration timeout, Srp ... searchParameters) throws KNXException {
        NetworkInterface[] nifs;
        if (timeout.isNegative()) {
            throw new KNXIllegalArgumentException("timeout has to be >= 0");
        }
        try {
            nifs = (NetworkInterface[])NetworkInterface.networkInterfaces().toArray(NetworkInterface[]::new);
        }
        catch (SocketException e) {
            logger.error("failed to get network interfaces", (Throwable)e);
            throw new KNXException("network interface error: " + e.getMessage());
        }
        boolean lo = false;
        ArrayList<CompletableFuture<Void>> cfs = new ArrayList<CompletableFuture<Void>>();
        Set responses = Collections.newSetFromMap(new ConcurrentHashMap());
        for (NetworkInterface ni : nifs) {
            Enumeration<InetAddress> ea = ni.getInetAddresses();
            while (ea.hasMoreElements()) {
                InetAddress a = ea.nextElement();
                if (!this.nat && a.getAddress().length != 4) {
                    logger.debug("skip {}, not an IPv4 address", (Object)a);
                    continue;
                }
                try {
                    block14: {
                        block13: {
                            if (!lo) break block13;
                            if (a.isLoopbackAddress()) break block14;
                        }
                        cfs.add(this.search(a, this.port, ni, timeout, responses::add, searchParameters));
                    }
                    if (!a.isLoopbackAddress()) continue;
                    lo = true;
                }
                catch (RuntimeException | KNXException e) {
                    Object causeMsg = "";
                    for (Throwable t2 = e.getCause(); t2 != null && t2 != t2.getCause(); t2 = t2.getCause()) {
                        causeMsg = " (" + t2.getMessage() + ")";
                    }
                    logger.warn("using {} at {}: {}{}", new Object[]{a, ni.getName(), e.getMessage(), causeMsg});
                }
            }
        }
        if (cfs.size() == 0) {
            throw new KNXException("search could not be started on any network interface");
        }
        CompletionStage search = CompletableFuture.allOf(cfs.toArray(new CompletableFuture[0])).thenApply(__ -> List.copyOf(responses));
        ((CompletableFuture)search).exceptionally(t -> {
            cfs.forEach(cf -> cf.cancel(false));
            return null;
        });
        return search;
    }

    public final void stopSearch() {
        ReceiverLoop[] loopers = this.receivers.toArray(new ReceiverLoop[this.receivers.size()]);
        for (int i = 0; i < loopers.length; ++i) {
            ReceiverLoop loop = loopers[i];
            loop.quit();
        }
        this.receivers.removeAll(Arrays.asList(loopers));
    }

    public final boolean isSearching() {
        return this.receivers.size() != 0;
    }

    public final List<Result<SearchResponse>> getSearchResponses() {
        return Collections.unmodifiableList(this.responses);
    }

    public final void clearSearchResponses() {
        this.responses.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result<DescriptionResponse> getDescription(InetSocketAddress server, int timeout) throws KNXException {
        if (timeout <= 0) throw new KNXIllegalArgumentException("timeout out of range");
        if (timeout >= 2147483) {
            throw new KNXIllegalArgumentException("timeout out of range");
        }
        if (this.connection != null) {
            try {
                return this.tcpDescription().get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new KnxRuntimeException("interrupted");
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof KNXException)) throw new KNXException("waiting for description response", cause);
                throw (KNXException)cause;
            }
        }
        InetAddress localhost = this.host(server.getAddress());
        InetSocketAddress bind = new InetSocketAddress(this.nat ? null : Net.onSameSubnet(server.getAddress()).orElse(localhost), this.port);
        try (DatagramChannel dc = Discoverer.newChannel(bind);){
            InetSocketAddress local = (InetSocketAddress)dc.getLocalAddress();
            byte[] buf = PacketHelper.toPacket(new DescriptionRequest(this.nat ? null : local));
            dc.send(ByteBuffer.wrap(buf), server);
            ReceiverLoop looper = new ReceiverLoop(dc, 512, Duration.ofSeconds(timeout), server);
            looper.loop();
            if (looper.thrown != null) {
                throw looper.thrown;
            }
            if (looper.res == null) throw new KNXTimeoutException("timeout, no description response received from " + Net.hostPort(server));
            Result<DescriptionResponse> result = new Result<DescriptionResponse>(looper.res, NetworkInterface.getByInetAddress(local.getAddress()), local, server);
            return result;
        }
        catch (IOException e) {
            throw new KNXException("network failure on getting description from " + Net.hostPort(server), e);
        }
    }

    private CompletableFuture<Result<DescriptionResponse>> tcpDescription() {
        byte[] request = PacketHelper.toPacket(DescriptionRequest.tcpRequest());
        return this.tcpSend(request);
    }

    private CompletableFuture<Void> search(InetAddress localAddr, int localPort, NetworkInterface ni, Duration timeout, Consumer<Result<SearchResponse>> notifyResponse, Srp ... searchParameters) throws KNXException {
        InetSocketAddress bind = this.mcast ? new InetSocketAddress(3671) : new InetSocketAddress(localAddr, localPort);
        try {
            DatagramChannel channel = Discoverer.newChannel(bind);
            if (ni != null) {
                channel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, ni);
            }
            if (this.mcast) {
                channel.join(SYSTEM_SETUP_MULTICAST, ni);
            }
            String nifName = ni != null ? ni.getName() + " " : "";
            int realLocalPort = ((InetSocketAddress)channel.getLocalAddress()).getPort();
            InetSocketAddress localEndpoint = new InetSocketAddress(localAddr, realLocalPort);
            logger.debug("search on " + nifName + localEndpoint);
            InetSocketAddress res = this.mcast ? new InetSocketAddress(SYSTEM_SETUP_MULTICAST, realLocalPort) : (this.nat ? new InetSocketAddress(0) : localEndpoint);
            InetSocketAddress dst = new InetSocketAddress(SYSTEM_SETUP_MULTICAST, 3671);
            SearchRequest req = searchParameters.length > 0 ? new SearchRequest(res, searchParameters) : new SearchRequest(res, Srp.withDeviceDescription(1, 2, 8, 6, 7));
            channel.send(ByteBuffer.wrap(PacketHelper.toPacket(req)), dst);
            if (searchParameters.length == 0) {
                byte[] std = PacketHelper.toPacket(new SearchRequest(res));
                channel.send(ByteBuffer.wrap(std), dst);
            }
            return this.receiveAsync(channel, localEndpoint, timeout, nifName + localAddr.getHostAddress(), notifyResponse);
        }
        catch (IOException | RuntimeException e) {
            throw new KNXException("search request to " + SYSTEM_SETUP_MULTICAST + " failed on " + localAddr + ":" + localPort, e);
        }
    }

    private static DatagramChannel newChannel(InetSocketAddress bind) throws IOException {
        return (DatagramChannel)((AbstractSelectableChannel)((Object)((DatagramChannel)DatagramChannel.open(StandardProtocolFamily.INET).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true)).bind(bind).setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)64))).configureBlocking(false);
    }

    private synchronized InetAddress host(InetAddress remote) throws KNXException {
        try {
            if (remote == null) {
                return InetAddress.getLocalHost();
            }
            if (this.host == null) {
                this.host = InetAddress.getLocalHost();
            }
            return this.host;
        }
        catch (UnknownHostException e) {
            throw new KNXException("on resolving address of local host", e);
        }
    }

    private CompletableFuture<Void> receiveAsync(DatagramChannel dc, InetSocketAddress localEndpoint, Duration timeout, String name, Consumer<Result<SearchResponse>> notifyResponse) throws IOException {
        ReceiverLoop looper = new ReceiverLoop(dc, localEndpoint, 512, timeout, name + ":" + ((InetSocketAddress)dc.getLocalAddress()).getPort(), notifyResponse);
        CompletableFuture<Void> cf = CompletableFuture.runAsync(looper, executor);
        cf.exceptionally(t -> {
            looper.quit();
            return null;
        });
        return cf;
    }

    private CompletableFuture<Result<SearchResponse>> receiveAsync(DatagramChannel dc, InetSocketAddress serverCtrlEndpoint, Duration timeout) throws IOException {
        ReceiverLoop looper = new ReceiverLoop(dc, 512, timeout.plusSeconds(1L), serverCtrlEndpoint);
        InetSocketAddress local = (InetSocketAddress)dc.getLocalAddress();
        NetworkInterface netif = local.getAddress().isAnyLocalAddress() ? Net.defaultNetif : NetworkInterface.getByInetAddress(local.getAddress());
        CompletableFuture<Result<SearchResponse>> cf = ((CompletableFuture)CompletableFuture.runAsync(looper, executor).thenApply(__ -> new Result<SearchResponse>(looper.sr, netif, local, serverCtrlEndpoint))).orTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS);
        cf.exceptionally(t -> {
            looper.quit();
            return null;
        });
        return cf;
    }

    static {
        InetAddress a = null;
        try {
            a = InetAddress.getByName(SEARCH_MULTICAST);
        }
        catch (UnknownHostException e) {
            logger.error("on resolving system setup multicast 224.0.23.12", (Throwable)e);
        }
        SYSTEM_SETUP_MULTICAST = a;
        executor = Executors.newCachedThreadPool(runnable -> {
            Thread t = new Thread(runnable);
            t.setDaemon(true);
            return t;
        });
    }

    private final class Tunnel<T>
    extends KNXnetIPTunnel {
        private final CompletableFuture<Result<T>> cf;

        Tunnel(KNXnetIPTunnel.TunnelingLayer knxLayer, Connection connection, IndividualAddress tunnelingAddress, CompletableFuture<Result<T>> cf) throws KNXException, InterruptedException {
            super(knxLayer, connection, tunnelingAddress);
            this.cf = cf;
        }

        @Override
        protected boolean handleServiceType(KNXnetIPHeader h, byte[] data, int offset, InetAddress src, int port) throws KNXFormatException, IOException {
            int svc = h.getServiceType();
            if (svc == 524 || svc == 516) {
                ServiceType sr = svc == 524 ? SearchResponse.from(h, data, offset) : new DescriptionResponse(data, offset, h.getTotalLength() - h.getStructLength());
                Result<DescriptionResponse> result = new Result<DescriptionResponse>((DescriptionResponse)sr, NetworkInterface.getByInetAddress(Discoverer.this.connection.localEndpoint().getAddress()), Discoverer.this.connection.localEndpoint(), Discoverer.this.connection.server());
                this.complete(result);
                return true;
            }
            return super.handleServiceType(h, data, offset, src, port);
        }

        private void complete(Result<?> result) {
            this.cf.complete(result);
        }

        @Override
        public String getName() {
            String lock = new String(Character.toChars(128274));
            Object secure = Discoverer.this.session != null ? " " + lock : "";
            return "KNX IP" + (String)secure + " Tunneling " + Net.hostPort(this.ctrlEndpt);
        }

        @Override
        protected void connect(Connection c, CRI cri) throws KNXException, InterruptedException {
            if (Discoverer.this.session == null) {
                super.connect(c, cri);
                return;
            }
            Discoverer.this.session.ensureOpen();
            Discoverer.this.session.registerConnectRequest(this);
            try {
                super.connect(c.localEndpoint(), c.server(), cri, false);
            }
            finally {
                Discoverer.this.session.unregisterConnectRequest(this);
            }
        }

        void send(byte[] packet) throws IOException {
            this.send(packet, new InetSocketAddress(0));
        }

        @Override
        protected void send(byte[] packet, InetSocketAddress dst) throws IOException {
            byte[] send = packet;
            if (Discoverer.this.session != null) {
                send = SecureConnection.newSecurePacket(Discoverer.this.session.id(), Discoverer.this.session.nextSendSeq(), Discoverer.this.session.serialNumber(), 0, packet, Discoverer.this.session.secretKey);
            }
            super.send(send, dst);
        }
    }

    private final class ReceiverLoop
    extends UdpSocketLooper
    implements Runnable {
        private final boolean multicast;
        private final InetSocketAddress server;
        private final NetworkInterface nif;
        private final InetSocketAddress localEndpoint;
        private DescriptionResponse res;
        private SearchResponse sr;
        private KNXInvalidResponseException thrown;
        private final String id;
        private final Selector selector;
        private final Duration timeout;
        private final Consumer<Result<SearchResponse>> notifyResponse;

        ReceiverLoop(DatagramChannel dc, InetSocketAddress localEndpoint, int receiveBufferSize, Duration timeout, String name, Consumer<Result<SearchResponse>> notifyResponse) throws IOException {
            super(null, false, receiveBufferSize, 0, (int)timeout.toMillis());
            this.nif = dc.getOption(StandardSocketOptions.IP_MULTICAST_IF);
            this.localEndpoint = localEndpoint;
            this.multicast = true;
            this.server = null;
            this.id = name;
            this.selector = Selector.open();
            dc.register(this.selector, 1);
            this.timeout = timeout;
            this.notifyResponse = notifyResponse;
            Discoverer.this.receivers.add(this);
        }

        ReceiverLoop(DatagramChannel dc, int receiveBufferSize, Duration timeout, InetSocketAddress queriedServer) throws IOException {
            super(null, true, receiveBufferSize, 0, (int)timeout.toMillis());
            this.nif = null;
            this.localEndpoint = null;
            this.multicast = false;
            this.server = queriedServer;
            this.id = "" + dc.getLocalAddress();
            this.selector = Selector.open();
            dc.register(this.selector, 1);
            this.timeout = timeout;
            this.notifyResponse = null;
        }

        @Override
        public void run() {
            Thread.currentThread().setName("Discoverer " + this.id);
            try {
                this.loop();
            }
            catch (IOException e) {
                logger.error("while waiting for response", (Throwable)e);
            }
            finally {
                logger.trace("stopped on " + this.id);
                Thread.currentThread().setName("Discoverer (idle)");
                Discoverer.this.receivers.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(InetSocketAddress source, byte[] data, int offset, int length) {
            block21: {
                try {
                    KNXnetIPHeader h = new KNXnetIPHeader(data, offset);
                    int bodyLen = h.getTotalLength() - h.getStructLength();
                    int svc = h.getServiceType();
                    if (h.getTotalLength() > length) {
                        logger.warn("ignore received packet from {}, packet size {} > buffer size {}", new Object[]{source, h.getTotalLength(), length});
                        break block21;
                    }
                    if (this.multicast && (svc == 514 || svc == 524)) {
                        List<ReceiverLoop> list = Discoverer.this.receivers;
                        synchronized (list) {
                            if (Discoverer.this.receivers.contains(this)) {
                                SearchResponse response = SearchResponse.from(h, data, offset + h.getStructLength());
                                Result<SearchResponse> r = new Result<SearchResponse>(response, this.nif, this.localEndpoint, source);
                                this.notifyResponse.accept(r);
                                if (!Discoverer.this.responses.contains(r)) {
                                    Discoverer.this.responses.add(r);
                                }
                            }
                            break block21;
                        }
                    }
                    if (!this.multicast && svc == 516) {
                        if (!source.equals(this.server)) break block21;
                        try {
                            this.res = new DescriptionResponse(data, offset + h.getStructLength(), bodyLen);
                            break block21;
                        }
                        catch (KNXFormatException e) {
                            this.thrown = new KNXInvalidResponseException("invalid description response from " + Net.hostPort(source), e);
                            break block21;
                        }
                        finally {
                            this.quit();
                        }
                    }
                    if (this.multicast || svc != 524 || !source.equals(this.server)) break block21;
                    try {
                        this.sr = SearchResponse.from(h, data, offset + h.getStructLength());
                    }
                    catch (KNXFormatException e) {
                        this.thrown = new KNXInvalidResponseException("invalid search response from " + Net.hostPort(source), e);
                    }
                    finally {
                        this.quit();
                    }
                }
                catch (KNXFormatException e) {
                    logger.info("ignore received packet from {}, {}", (Object)source, (Object)e.getMessage());
                }
                catch (RuntimeException e) {
                    logger.warn("error parsing received packet from {}", (Object)source, (Object)e);
                }
            }
        }

        @Override
        protected void receive(byte[] buf) throws IOException {
            Duration remaining = this.timeout;
            Instant end = Instant.now().plus(remaining);
            while (remaining.toMillis() > 0L) {
                if (this.selector.select(remaining.toMillis()) > 0) {
                    Iterator<SelectionKey> i = this.selector.selectedKeys().iterator();
                    while (i.hasNext()) {
                        SelectionKey key = i.next();
                        SelectableChannel channel = key.channel();
                        ByteBuffer buffer = ByteBuffer.wrap(buf);
                        SocketAddress source = ((DatagramChannel)channel).receive(buffer);
                        buffer.flip();
                        this.onReceive((InetSocketAddress)source, buf, buffer.position(), buffer.remaining());
                        i.remove();
                    }
                    return;
                }
                remaining = Duration.between(Instant.now(), end);
            }
        }
    }

    public static final class Result<T> {
        private final T response;
        private final NetworkInterface ni;
        private final InetSocketAddress local;
        private final InetSocketAddress remote;

        Result(T r, NetworkInterface outgoing, InetSocketAddress local, InetSocketAddress remote) {
            this.response = r;
            this.ni = outgoing;
            this.local = local;
            this.remote = remote;
        }

        public T getResponse() {
            return this.response;
        }

        public NetworkInterface getNetworkInterface() {
            return this.ni;
        }

        @Deprecated
        public InetAddress getAddress() {
            return this.local.getAddress();
        }

        public InetSocketAddress localEndpoint() {
            return this.local;
        }

        public InetSocketAddress remoteEndpoint() {
            return this.remote;
        }

        public String toString() {
            return Net.hostPort(this.local) + " (" + this.ni.getName() + ") <- " + this.response;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Result)) {
                return false;
            }
            Result other = (Result)obj;
            return this.getNetworkInterface().equals(other.getNetworkInterface()) && this.localEndpoint().equals(other.localEndpoint()) && this.getResponse().equals(other.getResponse()) && this.remote.equals(other.remote);
        }

        public int hashCode() {
            int prime = 17;
            return 17 * (17 * (17 * this.getNetworkInterface().hashCode() + this.localEndpoint().hashCode()) + this.getResponse().hashCode()) + this.remote.hashCode();
        }
    }
}

