/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXAckTimeoutException;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.cemi.AdditionalInfo;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.cemi.CEMILDataEx;
import tuwien.auto.calimero.knxnetip.ClientConnection;
import tuwien.auto.calimero.knxnetip.Connection;
import tuwien.auto.calimero.knxnetip.KNXConnectionClosedException;
import tuwien.auto.calimero.knxnetip.KNXnetIPConnection;
import tuwien.auto.calimero.knxnetip.TunnelingListener;
import tuwien.auto.calimero.knxnetip.servicetype.KNXnetIPHeader;
import tuwien.auto.calimero.knxnetip.servicetype.PacketHelper;
import tuwien.auto.calimero.knxnetip.servicetype.ServiceAck;
import tuwien.auto.calimero.knxnetip.servicetype.ServiceRequest;
import tuwien.auto.calimero.knxnetip.servicetype.TunnelingFeature;
import tuwien.auto.calimero.knxnetip.util.TunnelCRI;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;
import tuwien.auto.calimero.log.LogService;

public class KNXnetIPTunnel
extends ClientConnection {
    public static final int TUNNEL_CONNECTION = 4;
    private static final int TUNNELING_REQ_TIMEOUT = 1;
    private final TunnelingLayer layer;

    public static KNXnetIPTunnel newTcpTunnel(TunnelingLayer knxLayer, Connection connection, IndividualAddress tunnelingAddress) throws KNXException, InterruptedException {
        return new KNXnetIPTunnel(knxLayer, connection, tunnelingAddress);
    }

    public KNXnetIPTunnel(TunnelingLayer knxLayer, InetSocketAddress localEP, InetSocketAddress serverCtrlEP, boolean useNAT) throws KNXException, InterruptedException {
        super(1056, 1057, 2, 1);
        this.layer = Objects.requireNonNull(knxLayer, "Tunneling Layer");
        if (knxLayer == TunnelingLayer.RawLayer) {
            throw new KNXIllegalArgumentException("Raw tunnel to KNX network not supported");
        }
        this.connect(localEP, serverCtrlEP, new TunnelCRI(knxLayer), useNAT);
    }

    KNXnetIPTunnel(TunnelingLayer knxLayer, InetSocketAddress localEP, InetSocketAddress serverCtrlEP, boolean useNAT, IndividualAddress tunnelingAddress) throws KNXException, InterruptedException {
        super(1056, 1057, 2, 1);
        this.layer = Objects.requireNonNull(knxLayer, "Tunneling Layer");
        if (knxLayer == TunnelingLayer.RawLayer) {
            throw new KNXIllegalArgumentException("Raw tunnel to KNX network not supported");
        }
        TunnelCRI cri = tunnelingAddress.equals(KNXMediumSettings.BackboneRouter) ? new TunnelCRI(knxLayer) : new TunnelCRI(knxLayer, tunnelingAddress);
        this.connect(localEP, serverCtrlEP, cri, useNAT);
    }

    protected KNXnetIPTunnel(TunnelingLayer knxLayer, Connection connection, IndividualAddress tunnelingAddress) throws KNXException, InterruptedException {
        super(1056, 1057, 1, 1, connection);
        this.layer = Objects.requireNonNull(knxLayer, "Tunneling Layer");
        if (knxLayer == TunnelingLayer.RawLayer) {
            throw new KNXIllegalArgumentException("Raw tunnel to KNX network not supported");
        }
        TunnelCRI cri = tunnelingAddress.equals(KNXMediumSettings.BackboneRouter) ? new TunnelCRI(knxLayer) : new TunnelCRI(knxLayer, tunnelingAddress);
        this.connect(connection, cri);
    }

    @Override
    public void send(CEMI frame, KNXnetIPConnection.BlockingMode mode) throws KNXTimeoutException, KNXConnectionClosedException, InterruptedException {
        if (this.layer == TunnelingLayer.BusMonitorLayer) {
            throw new IllegalStateException("send not permitted in busmonitor mode");
        }
        if (!(frame instanceof CEMILData)) {
            throw new KNXIllegalArgumentException("unsupported cEMI type " + frame.getClass());
        }
        super.send(frame, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(TunnelingFeature.InterfaceFeature feature) throws KNXConnectionClosedException, KNXAckTimeoutException, InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            TunnelingFeature get = TunnelingFeature.newGet(this.channelId, this.getSeqSend(), feature);
            this.send(get);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(TunnelingFeature.InterfaceFeature feature, byte ... featureValue) throws KNXConnectionClosedException, KNXAckTimeoutException, InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            TunnelingFeature set = TunnelingFeature.newSet(this.channelId, this.getSeqSend(), feature, featureValue);
            this.send(set);
        }
    }

    private void send(TunnelingFeature tunnelingFeature) throws KNXConnectionClosedException, KNXAckTimeoutException, InterruptedException {
        if (this.layer == TunnelingLayer.BusMonitorLayer) {
            throw new IllegalStateException("send not permitted in busmonitor mode");
        }
        if (this.state < 0) {
            throw new IllegalStateException("in error state, send aborted");
        }
        if (this.state == 1) {
            throw new KNXConnectionClosedException("send attempt on closed connection");
        }
        byte[] buf = PacketHelper.toPacket(tunnelingFeature);
        try {
            int attempt;
            for (attempt = 0; attempt < this.maxSendAttempts; ++attempt) {
                this.logger.trace("sending {}, attempt {}", (Object)tunnelingFeature, (Object)(attempt + 1));
                this.updateState = false;
                this.send(buf, this.dataEndpt);
                if (this.socket == null) {
                    this.internalState = 4;
                    break;
                }
                this.internalState = 2;
                this.state = 2;
                this.waitForStateChange(2, this.responseTimeout);
                if (this.internalState == 4 || this.internalState == 0) break;
            }
            if (attempt == this.maxSendAttempts) {
                KNXAckTimeoutException e = new KNXAckTimeoutException("maximum send attempts, no service acknowledgment received");
                this.close(3, "maximum send attempts", LogService.LogLevel.ERROR, e);
                throw e;
            }
        }
        catch (InterruptedIOException e) {
            throw new InterruptedException("interrupted I/O, " + e);
        }
        catch (IOException e) {
            this.close(3, "communication failure", LogService.LogLevel.ERROR, e);
            throw new KNXConnectionClosedException("connection closed");
        }
        finally {
            this.updateState = true;
            this.setState(0);
        }
    }

    @Override
    public String getName() {
        return "KNXnet/IP Tunneling " + super.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean handleServiceType(KNXnetIPHeader h, byte[] data, int offset, InetAddress src, int port) throws KNXFormatException, IOException {
        if (super.handleServiceType(h, data, offset, src, port)) {
            return true;
        }
        int svc = h.getServiceType();
        if (svc < this.serviceRequest || svc > 1061) {
            return false;
        }
        ServiceRequest req = this.getServiceRequest(h, data, offset);
        if (!this.checkChannelId(req.getChannelID(), "request")) {
            return true;
        }
        if (!this.tcp) {
            boolean repeated;
            boolean missed;
            int seq = req.getSequenceNumber();
            boolean bl = missed = (seq - 1 & 0xFF) == this.getSeqRcv();
            if (missed) {
                boolean resync;
                String s = System.getProperty("calimero.knxnetip.tunneling.resyncSkippedRcvSeq");
                boolean bl2 = resync = "".equals(s) || "true".equalsIgnoreCase(s);
                if (resync) {
                    this.logger.error("tunneling request with rcv-seq " + seq + ", expected " + this.getSeqRcv() + " -> re-sync with server (1 tunneled msg lost)");
                    this.incSeqRcv();
                }
            }
            boolean expected = seq == this.getSeqRcv();
            boolean bl3 = repeated = (seq + 1 & 0xFF) == this.getSeqRcv();
            if (expected || repeated) {
                int status = h.getVersion() == 16 ? 0 : 2;
                byte[] buf = PacketHelper.toPacket(new ServiceAck(this.serviceAck, this.channelId, seq, status));
                this.send(buf, this.dataEndpt);
                if (status == 2) {
                    this.close(3, "protocol version changed", LogService.LogLevel.ERROR, null);
                    return true;
                }
            } else {
                this.logger.warn("tunneling request with invalid rcv-seq {}, expected {}", (Object)seq, (Object)this.getSeqRcv());
                return true;
            }
            if (repeated) {
                this.logger.debug("skip tunneling request with rcv-seq {} (already received)", (Object)seq);
                return true;
            }
            this.incSeqRcv();
        }
        if (svc >= 1058 && svc <= 1061) {
            ByteBuffer buffer = ByteBuffer.wrap(data, offset, h.getTotalLength() - h.getStructLength());
            TunnelingFeature feature = TunnelingFeature.from(svc, buffer);
            this.logger.trace("received {}", (Object)feature);
            this.listeners.listeners().stream().filter(TunnelingListener.class::isInstance).map(TunnelingListener.class::cast).forEach(tl -> this.notifyFeatureReceived((TunnelingListener)tl, svc, feature));
            return true;
        }
        CEMI cemi = req.getCEMI();
        if (cemi == null) {
            return true;
        }
        int mc = cemi.getMessageCode();
        if (mc == 41 || mc == 43) {
            this.logger.trace("received request seq {} (channel {}) cEMI {}", new Object[]{req.getSequenceNumber(), this.channelId, DataUnitBuilder.toHex(cemi.toByteArray(), " ")});
            this.fireFrameReceived(cemi);
        } else if (mc == 46) {
            this.logger.debug("received request seq {} (channel {}) cEMI L-Data.con {}->{}", new Object[]{req.getSequenceNumber(), this.channelId, ((CEMILData)cemi).getSource(), ((CEMILData)cemi).getDestination()});
            this.fireFrameReceived(cemi);
            Object object = this.lock;
            synchronized (object) {
                CEMILData ldata = (CEMILData)this.keepForCon;
                if (ldata != null && this.internalState == 4) {
                    boolean emptySrc = ldata.getSource().getRawAddress() == 0;
                    List<Integer> types = KNXnetIPTunnel.additionalInfoTypesOf(ldata);
                    byte[] sent = this.unifyLData(ldata, emptySrc, types);
                    byte[] recv = this.unifyLData(cemi, emptySrc, types);
                    if (Arrays.equals(recv, sent)) {
                        this.keepForCon = null;
                        this.setStateNotify(0);
                    } else {
                        int sendCount = ldata.getHopCount() - 1;
                        sent[3] = (byte)(sent[3] & 0x8F | sendCount << 4);
                        if (Arrays.equals(recv, sent)) {
                            this.keepForCon = null;
                            this.setStateNotify(0);
                            this.logger.info("received L_Data.con with hop count decremented by 1 (sent {}, got {})", (Object)(sendCount + 1), (Object)sendCount);
                        }
                    }
                }
            }
        } else if (mc == 17) {
            this.logger.warn("received L-Data request - ignore {}", (Object)cemi);
        }
        return true;
    }

    private void notifyFeatureReceived(TunnelingListener tl, int svc, TunnelingFeature feature) {
        try {
            if (svc == 1059) {
                tl.featureResponse(feature);
            } else if (svc == 1061) {
                tl.featureInfo(feature);
            } else {
                this.logger.warn("unsupported {} - ignored", (Object)feature);
            }
        }
        catch (RuntimeException rte) {
            this.logger.warn("catch your runtime exceptions in {}!", (Object)tl.getClass().getName(), (Object)rte);
        }
    }

    private static List<Integer> additionalInfoTypesOf(CEMILData ldata) {
        if (ldata instanceof CEMILDataEx) {
            CEMILDataEx ext = (CEMILDataEx)ldata;
            return ext.additionalInfo().stream().map(AdditionalInfo::type).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] unifyLData(CEMI ldata, boolean emptySrc, List<Integer> types) {
        if (ldata instanceof CEMILDataEx) {
            List<AdditionalInfo> additionalInfo;
            CEMILDataEx ext = (CEMILDataEx)ldata;
            List<AdditionalInfo> list = additionalInfo = ext.additionalInfo();
            synchronized (list) {
                Iterator<AdditionalInfo> i = additionalInfo.iterator();
                while (i.hasNext()) {
                    AdditionalInfo info = i.next();
                    if (types.contains(info.type())) continue;
                    this.logger.warn("remove L-Data additional info {}", (Object)info);
                    i.remove();
                }
            }
        }
        byte[] data = ldata.toByteArray();
        data[0] = 0;
        data[1 + data[1] + 1] = 0;
        if (emptySrc) {
            data[1 + data[1] + 3] = 0;
            data[1 + data[1] + 4] = 0;
        }
        return data;
    }

    public static enum TunnelingLayer {
        BusMonitorLayer(128),
        LinkLayer(2),
        RawLayer(4);

        private final int code;

        public static TunnelingLayer from(int layer) {
            for (TunnelingLayer v : TunnelingLayer.values()) {
                if (layer != v.code) continue;
                return v;
            }
            throw new KNXIllegalArgumentException("unspecified tunneling layer + 0x" + Integer.toHexString(layer));
        }

        private TunnelingLayer(int code) {
            this.code = code;
        }

        public final int getCode() {
            return this.code;
        }
    }
}

