/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Net {
    private static final Logger logger = LoggerFactory.getLogger((String)"Net");
    static final NetworkInterface defaultNetif;

    private Net() {
    }

    static Optional<InetAddress> onSameSubnet(InetAddress remote) {
        try {
            return NetworkInterface.networkInterfaces().flatMap(ni -> ni.getInterfaceAddresses().stream()).filter(ia -> ia.getAddress() instanceof Inet4Address).peek(ia -> logger.trace("match local address {}/{} to {}", new Object[]{ia.getAddress(), ia.getNetworkPrefixLength(), remote})).filter(ia -> Net.matchesPrefix(ia.getAddress(), ia.getNetworkPrefixLength(), remote)).map(ia -> ia.getAddress()).findFirst();
        }
        catch (SocketException socketException) {
            return Optional.empty();
        }
    }

    static boolean matchesPrefix(InetAddress local, int maskLength, InetAddress remote) {
        byte[] a1 = local.getAddress();
        byte[] a2 = remote.getAddress();
        long mask = 0xFFFFFFFFL >> maskLength ^ 0xFFFFFFFFL;
        for (int i = 0; i < a1.length; ++i) {
            int byteMask = (int)(mask >> 24 - 8 * i & 0xFFL);
            if ((a1[i] & byteMask) == (a2[i] & byteMask)) continue;
            return false;
        }
        return true;
    }

    static String hostPort(InetSocketAddress addr) {
        return addr.getAddress().getHostAddress() + ":" + addr.getPort();
    }

    static {
        try (MulticastSocket s = new MulticastSocket();){
            defaultNetif = s.getNetworkInterface();
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError();
        }
    }
}

