/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.StandardSocketOptions;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.XECPublicKey;
import java.security.spec.NamedParameterSpec;
import java.security.spec.XECPublicKeySpec;
import java.time.Duration;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.LoggerFactory;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXListener;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.SerialNumber;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.knxnetip.Connection;
import tuwien.auto.calimero.knxnetip.KNXConnectionClosedException;
import tuwien.auto.calimero.knxnetip.KNXnetIPConnection;
import tuwien.auto.calimero.knxnetip.KNXnetIPDevMgmt;
import tuwien.auto.calimero.knxnetip.KNXnetIPRouting;
import tuwien.auto.calimero.knxnetip.KNXnetIPTunnel;
import tuwien.auto.calimero.knxnetip.Net;
import tuwien.auto.calimero.knxnetip.ReceiverLoop;
import tuwien.auto.calimero.knxnetip.servicetype.KNXnetIPHeader;
import tuwien.auto.calimero.knxnetip.servicetype.PacketHelper;
import tuwien.auto.calimero.knxnetip.util.CRI;
import tuwien.auto.calimero.knxnetip.util.HPAI;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.secure.KnxSecureException;

public final class SecureConnection
extends KNXnetIPRouting {
    private static final int SecureSvc = 2384;
    private static final int SecureSessionResponse = 2386;
    private static final int SecureSessionAuth = 2387;
    private static final int SecureSessionStatus = 2388;
    private static final int SecureGroupSync = 2389;
    private static final int macSize = 16;
    private static final int keyLength = 32;
    static final String secureSymbol = new String(Character.toChars(128274));
    private final SerialNumber sno;
    private Key secretKey;
    private int sessionId;
    private Connection.SecureSession session;
    private PrivateKey privateKey;
    private final byte[] publicKey = new byte[32];
    private static final int sessionSetupTimeout = 10000;
    private static final int SessionSetup = -1;
    private volatile int sessionStatus = -1;
    private DatagramSocket localSocket;
    private ReceiverLoop setupLoop;
    private final KNXnetIPConnection tunnel;
    private final int mcastLatencyTolerance;
    private final int syncLatencyTolerance;
    private final AtomicInteger routingCount = new AtomicInteger();
    private long timestampOffset = -System.nanoTime() / 1000000L;
    private volatile boolean syncedWithGroup;
    private volatile int sentGroupSyncTag;
    private static final int syncQueryInterval = 10000;
    private static final int minDelayTimeKeeperUpdateNotify = 100;
    private int minDelayUpdateNotify;
    private int maxDelayUpdateNotify;
    private int minDelayPeriodicNotify;
    private int maxDelayPeriodicNotify;
    private volatile boolean periodicSchedule = true;
    private SerialNumber timerNotifySN;
    private int timerNotifyTag;
    private Future<?> groupSync = CompletableFuture.completedFuture(Void.TYPE);
    private static final ScheduledThreadPoolExecutor groupSyncSender = new ScheduledThreadPoolExecutor(1, r -> {
        Thread t = new Thread(r);
        t.setName("KNX/IP secure group sync");
        t.setDaemon(true);
        return t;
    });

    public static KNXnetIPConnection newTunneling(KNXnetIPTunnel.TunnelingLayer knxLayer, InetSocketAddress localEP, InetSocketAddress serverCtrlEP, boolean useNat, byte[] deviceAuthCode, int userId, byte[] userKey) throws KNXException, InterruptedException {
        byte[] devAuth = deviceAuthCode.length == 0 ? new byte[16] : deviceAuthCode;
        IndividualAddress tunnelingAddress = KNXMediumSettings.BackboneRouter;
        return new SecureConnection(knxLayer, localEP, serverCtrlEP, useNat, devAuth, userId, userKey, tunnelingAddress);
    }

    public static KNXnetIPConnection newTunneling(KNXnetIPTunnel.TunnelingLayer knxLayer, final Connection.SecureSession session, IndividualAddress tunnelingAddress) throws KNXException, InterruptedException {
        session.ensureOpen();
        KNXnetIPTunnel tunnel = new KNXnetIPTunnel(knxLayer, session.connection(), tunnelingAddress){

            @Override
            public String getName() {
                return "KNX IP " + secureSymbol + " Tunneling " + Net.hostPort(this.ctrlEndpt);
            }

            @Override
            protected void connect(Connection c, CRI cri) throws KNXException, InterruptedException {
                session.registerConnectRequest(this);
                try {
                    super.connect(c.localEndpoint(), c.server(), cri, false);
                }
                finally {
                    session.unregisterConnectRequest(this);
                }
            }

            @Override
            protected void send(byte[] packet, InetSocketAddress dst) throws IOException {
                byte[] wrapped = SecureConnection.newSecurePacket(session.id(), session.nextSendSeq(), session.serialNumber(), 0, packet, session.secretKey);
                super.send(wrapped, dst);
            }
        };
        return tunnel;
    }

    public static KNXnetIPConnection newRouting(NetworkInterface netIf, InetAddress mcGroup, byte[] groupKey, Duration latencyTolerance) throws KNXException {
        return new SecureConnection(netIf, mcGroup, groupKey, latencyTolerance);
    }

    public static KNXnetIPConnection newDeviceManagement(InetSocketAddress localEP, InetSocketAddress serverCtrlEP, boolean useNat, byte[] deviceAuthCode, byte[] userKey) throws KNXException, InterruptedException {
        byte[] devAuth = deviceAuthCode.length == 0 ? new byte[16] : deviceAuthCode;
        return new SecureConnection(localEP, serverCtrlEP, useNat, devAuth, userKey);
    }

    public static KNXnetIPConnection newDeviceManagement(final Connection.SecureSession session) throws KNXException, InterruptedException {
        session.ensureOpen();
        KNXnetIPDevMgmt tunnel = new KNXnetIPDevMgmt(session.connection()){

            @Override
            public String getName() {
                return "KNX IP " + secureSymbol + " Management " + Net.hostPort(this.ctrlEndpt);
            }

            @Override
            protected void connect(Connection c, CRI cri) throws KNXException, InterruptedException {
                session.registerConnectRequest(this);
                try {
                    super.connect(c.localEndpoint(), c.server(), cri, false);
                }
                finally {
                    session.unregisterConnectRequest(this);
                }
            }

            @Override
            protected void send(byte[] packet, InetSocketAddress dst) throws IOException {
                byte[] wrapped = SecureConnection.newSecurePacket(session.id(), session.nextSendSeq(), session.serialNumber(), 0, packet, session.secretKey);
                super.send(wrapped, dst);
            }
        };
        return tunnel;
    }

    public static byte[] hashUserPassword(char[] password) {
        byte[] salt = "user-password.1.secure.ip.knx.org".getBytes(StandardCharsets.US_ASCII);
        return SecureConnection.pbkdf2WithHmacSha256(password, salt);
    }

    public static byte[] hashDeviceAuthenticationPassword(char[] password) {
        byte[] salt = "device-authentication-code.1.secure.ip.knx.org".getBytes(StandardCharsets.US_ASCII);
        return SecureConnection.pbkdf2WithHmacSha256(password, salt);
    }

    @Deprecated(forRemoval=true)
    public static byte[] hashDeviceAuthenticationCode(char[] authCode) {
        byte[] salt = "device-authentication-code.1.secure.ip.knx.org".getBytes(StandardCharsets.US_ASCII);
        return SecureConnection.pbkdf2WithHmacSha256(authCode, salt);
    }

    private static byte[] pbkdf2WithHmacSha256(char[] password, byte[] salt) {
        for (int i = 0; i < password.length; ++i) {
            char c = password[i];
            if (c >= ' ' && c <= '~') continue;
            password[i] = 63;
        }
        int iterations = 65536;
        int keyLength = 128;
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec spec = new PBEKeySpec(password, salt, 65536, 128);
            SecretKey key = skf.generateSecret(spec);
            byte[] byArray = key.getEncoded();
            return byArray;
        }
        catch (GeneralSecurityException e) {
            throw new KnxSecureException("PBKDF2WithHmacSHA256", e);
        }
        finally {
            Arrays.fill(password, '\u0000');
        }
    }

    private SecureConnection(NetworkInterface netif, InetAddress mcGroup, byte[] groupKey, Duration latencyTolerance) throws KNXException {
        super(mcGroup);
        this.sno = SecureConnection.deriveSerialNumber(netif);
        this.secretKey = SecureConnection.createSecretKey(groupKey);
        this.mcastLatencyTolerance = (int)latencyTolerance.toMillis();
        this.syncLatencyTolerance = this.mcastLatencyTolerance / 10;
        this.init(netif, true, true);
        this.scheduleGroupSync(0L);
        try {
            this.awaitGroupSync();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.tunnel = null;
    }

    private SecureConnection(KNXnetIPTunnel.TunnelingLayer knxLayer, InetSocketAddress localEP, InetSocketAddress serverCtrlEP, boolean useNat, byte[] deviceAuthCode, int userId, byte[] userKey, IndividualAddress tunnelingAddress) throws KNXException, InterruptedException {
        super(DefaultMulticast);
        InetSocketAddress local = localEP;
        if (local.isUnresolved()) {
            throw new KNXIllegalArgumentException("unresolved address " + local);
        }
        if (local.getAddress().isAnyLocalAddress()) {
            try {
                InetAddress addr = useNat ? null : Optional.ofNullable(serverCtrlEP.getAddress()).flatMap(Net::onSameSubnet).orElse(InetAddress.getLocalHost());
                local = new InetSocketAddress(addr, localEP.getPort());
            }
            catch (UnknownHostException e) {
                throw new KNXException("no local host address available", e);
            }
        }
        this.session = Connection.Udp.newSecureSession(userId, userKey, deviceAuthCode);
        this.sno = this.session.serialNumber();
        this.setupSecureSession(local, serverCtrlEP);
        this.tunnel = new KNXnetIPTunnel(knxLayer, localEP, serverCtrlEP, useNat, tunnelingAddress){

            @Override
            public String getName() {
                return "KNX/IP " + secureSymbol + " Tunneling " + Net.hostPort(this.ctrlEndpt);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            protected boolean handleServiceType(KNXnetIPHeader h, byte[] data, int offset, InetAddress src, int port) throws KNXFormatException, IOException {
                int svc = h.getServiceType();
                if (!h.isSecure()) {
                    this.logger.trace("received insecure service type 0x{} - ignore", (Object)Integer.toHexString(svc));
                    return true;
                }
                if (svc == 2384) {
                    Object[] fields = SecureConnection.this.unwrap(h, data, offset);
                    byte[] packet = (byte[])fields[4];
                    KNXnetIPHeader containedHeader = new KNXnetIPHeader(packet, 0);
                    if (containedHeader.getServiceType() != 2388) return super.handleServiceType(containedHeader, packet, containedHeader.getStructLength(), src, port);
                    int status = SecureConnection.newChannelStatus(containedHeader, packet, containedHeader.getStructLength());
                    LogService.log(this.logger, status == 0 ? LogService.LogLevel.TRACE : LogService.LogLevel.ERROR, "{}", SecureConnection.this.session);
                    SecureConnection.this.setupLoop.quit();
                    SecureConnection.this.sessionStatus = status;
                    if (status == 0) return true;
                    throw new KnxSecureException("secure session " + SecureConnection.statusMsg(status));
                }
                this.logger.warn("received unsupported secure service type 0x{} - ignore", (Object)Integer.toHexString(svc));
                return true;
            }

            @Override
            protected void send(byte[] packet, InetSocketAddress dst) throws IOException {
                byte[] wrapped = SecureConnection.this.newSecurePacket(SecureConnection.this.session.nextSendSeq(), 0, packet);
                super.send(wrapped, dst);
            }
        };
        this.mcastLatencyTolerance = 0;
        this.syncLatencyTolerance = 0;
    }

    private SecureConnection(InetSocketAddress localEP, InetSocketAddress serverCtrlEP, boolean useNat, byte[] deviceAuthCode, byte[] userKey) throws KNXException, InterruptedException {
        super(DefaultMulticast);
        InetSocketAddress local = localEP;
        if (local.isUnresolved()) {
            throw new KNXIllegalArgumentException("unresolved address " + local);
        }
        if (local.getAddress().isAnyLocalAddress()) {
            try {
                InetAddress addr = useNat ? null : Optional.ofNullable(serverCtrlEP.getAddress()).flatMap(Net::onSameSubnet).orElse(InetAddress.getLocalHost());
                local = new InetSocketAddress(addr, localEP.getPort());
            }
            catch (UnknownHostException e) {
                throw new KNXException("no local host address available", e);
            }
        }
        this.session = Connection.Udp.newSecureSession(1, userKey, deviceAuthCode);
        this.sno = this.session.serialNumber();
        this.setupSecureSession(local, serverCtrlEP);
        this.tunnel = new KNXnetIPDevMgmt(localEP, serverCtrlEP, useNat){

            @Override
            public String getName() {
                return "KNX/IP " + secureSymbol + " Management " + Net.hostPort(this.ctrlEndpt);
            }

            @Override
            protected void send(byte[] packet, InetSocketAddress dst) throws IOException {
                byte[] wrapped = SecureConnection.this.newSecurePacket(SecureConnection.this.session.nextSendSeq(), 0, packet);
                super.send(wrapped, dst);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            protected boolean handleServiceType(KNXnetIPHeader h, byte[] data, int offset, InetAddress src, int port) throws KNXFormatException, IOException {
                int svc = h.getServiceType();
                if (!h.isSecure()) {
                    this.logger.trace("received insecure service type 0x{} - ignore", (Object)Integer.toHexString(svc));
                    return true;
                }
                if (svc == 2384) {
                    Object[] fields = SecureConnection.this.unwrap(h, data, offset);
                    byte[] packet = (byte[])fields[4];
                    KNXnetIPHeader containedHeader = new KNXnetIPHeader(packet, 0);
                    if (containedHeader.getServiceType() != 2388) return super.handleServiceType(containedHeader, packet, containedHeader.getStructLength(), src, port);
                    int status = SecureConnection.newChannelStatus(containedHeader, packet, containedHeader.getStructLength());
                    LogService.log(this.logger, status == 0 ? LogService.LogLevel.TRACE : LogService.LogLevel.ERROR, "{}", SecureConnection.this.session);
                    SecureConnection.this.setupLoop.quit();
                    SecureConnection.this.sessionStatus = status;
                    if (status == 0) return true;
                    throw new KnxSecureException("secure session " + SecureConnection.statusMsg(status));
                }
                this.logger.warn("received unsupported secure service type 0x{} - ignore", (Object)Integer.toHexString(svc));
                return true;
            }
        };
        this.mcastLatencyTolerance = 0;
        this.syncLatencyTolerance = 0;
    }

    private static SerialNumber deriveSerialNumber(NetworkInterface netif) {
        try {
            byte[] hardwareAddress;
            if (netif != null && (hardwareAddress = netif.getHardwareAddress()) != null) {
                return SerialNumber.from(Arrays.copyOf(hardwareAddress, 6));
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return SerialNumber.Zero;
    }

    @Override
    public void addConnectionListener(KNXListener l) {
        if (this.tunnel != null) {
            this.tunnel.addConnectionListener(l);
        } else {
            super.addConnectionListener(l);
        }
    }

    @Override
    public void removeConnectionListener(KNXListener l) {
        if (this.tunnel != null) {
            this.tunnel.addConnectionListener(l);
        } else {
            super.removeConnectionListener(l);
        }
    }

    @Override
    public void send(CEMI frame, KNXnetIPConnection.BlockingMode mode) throws KNXConnectionClosedException {
        if (this.tunnel != null) {
            try {
                this.tunnel.send(frame, mode);
            }
            catch (InterruptedException | KNXTimeoutException e) {
                if (this.tunnel.getState() == 1) {
                    throw new KNXConnectionClosedException(e.getMessage());
                }
                this.logger.error("tunneling error", (Throwable)e);
            }
        } else {
            super.send(frame, mode);
        }
    }

    @Override
    public String getName() {
        if (this.tunnel != null) {
            return this.tunnel.getName();
        }
        return "KNX/IP " + secureSymbol + " Routing " + this.ctrlEndpt.getAddress().getHostAddress();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    protected void send(byte[] packet, InetSocketAddress dst) throws IOException {
        int tag = this.routingCount.getAndIncrement() % 65536;
        byte[] wrapped = this.newSecurePacket(this.timestamp(), tag, packet);
        this.channel().send(ByteBuffer.wrap(wrapped), dst);
        this.scheduleGroupSync(this.periodicNotifyDelay());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean handleServiceType(KNXnetIPHeader h, byte[] data, int offset, InetAddress src, int port) throws KNXFormatException, IOException {
        int svc = h.getServiceType();
        if (!h.isSecure()) {
            this.logger.trace("received insecure service type 0x{} - ignore", (Object)Integer.toHexString(svc));
            return true;
        }
        InetSocketAddress source = new InetSocketAddress(src, port);
        if (svc == 2386) {
            try {
                Object[] res = this.newSessionResponse(h, data, offset, source);
                byte[] serverPublicKey = (byte[])res[1];
                byte[] auth = this.newSessionAuth(serverPublicKey);
                byte[] packet = this.newSecurePacket(this.session.nextSendSeq(), 0, auth);
                this.logger.debug("secure session {}, request access for user {}", (Object)this.sessionId, (Object)this.session.user());
                if (this.localSocket != null) {
                    this.localSocket.send(new DatagramPacket(packet, packet.length, source));
                    return true;
                }
                this.session.connection().send(packet);
                return true;
            }
            catch (RuntimeException e) {
                this.sessionStatus = 1;
                this.setupLoop.quit();
                this.logger.error("negotiating session key failed", (Throwable)e);
            }
            return true;
        }
        if (svc == 2389) {
            try {
                Object[] fields = this.newGroupSync(h, data, offset);
                this.onGroupSync(src, (Long)fields[0], true, (SerialNumber)fields[1], (Integer)fields[2]);
                return true;
            }
            catch (KnxSecureException e) {
                this.logger.debug("group sync {}", (Object)e.getMessage());
                return true;
            }
        } else {
            if (svc == 2384) {
                Object[] fields = this.unwrap(h, data, offset);
                long timestamp = (Long)fields[1];
                if (this.sessionId == 0 && !this.withinTolerance(src, timestamp, (SerialNumber)fields[2], (Integer)fields[3])) {
                    this.logger.warn("{} timestamp {} outside latency tolerance of {} ms (local {}) - ignore", new Object[]{Net.hostPort(source), timestamp, this.mcastLatencyTolerance, this.timestamp()});
                    return true;
                }
                byte[] packet = (byte[])fields[4];
                KNXnetIPHeader containedHeader = new KNXnetIPHeader(packet, 0);
                if (containedHeader.getServiceType() != 2388) return super.handleServiceType(containedHeader, packet, containedHeader.getStructLength(), src, port);
                int status = SecureConnection.newChannelStatus(containedHeader, packet, containedHeader.getStructLength());
                LogService.log(this.logger, status == 0 ? LogService.LogLevel.DEBUG : LogService.LogLevel.ERROR, "{}", this.session);
                this.setupLoop.quit();
                this.sessionStatus = status;
                if (status == 0) return true;
                throw new KnxSecureException("secure session " + SecureConnection.statusMsg(status));
            }
            this.logger.warn("received unsupported secure service type 0x{} - ignore", (Object)Integer.toHexString(svc));
        }
        return true;
    }

    @Override
    protected void close(int initiator, String reason, LogService.LogLevel level, Throwable t) {
        if (this.tunnel != null) {
            this.tunnel.close();
        } else {
            this.groupSync.cancel(true);
            super.close(initiator, reason, level, t);
        }
    }

    private void setupSecureSession(InetSocketAddress localEP, InetSocketAddress serverCtrlEP) throws KNXException {
        this.logger = LoggerFactory.getLogger((String)("calimero.knxnetip.KNX/IP " + secureSymbol + " Session " + Net.hostPort(serverCtrlEP)));
        this.logger.debug("setup secure session with {}", (Object)serverCtrlEP);
        try {
            KeyPair keyPair = SecureConnection.generateKeyPair();
            this.privateKey = keyPair.getPrivate();
            BigInteger u = ((XECPublicKey)keyPair.getPublic()).getU();
            byte[] tmp = u.toByteArray();
            SecureConnection.reverse(tmp);
            System.arraycopy(tmp, 0, this.publicKey, 0, tmp.length);
        }
        catch (Throwable e) {
            throw new KnxSecureException("error creating secure key pair for " + serverCtrlEP, e);
        }
        try (DatagramSocket local = new DatagramSocket(localEP);){
            this.localSocket = local;
            HPAI hpai = new HPAI(1, this.useNat ? null : (InetSocketAddress)local.getLocalSocketAddress());
            byte[] sessionReq = PacketHelper.newChannelRequest(hpai, this.publicKey);
            local.send(new DatagramPacket(sessionReq, sessionReq.length, serverCtrlEP));
            this.setupLoop = new ReceiverLoop(this, local, 512, 0, 10000);
            this.setupLoop.run();
            if (this.sessionStatus == -1) {
                throw new KNXTimeoutException("timeout establishing secure session with " + serverCtrlEP);
            }
            if (this.sessionStatus != 0) {
                throw new KnxSecureException("secure session " + SecureConnection.statusMsg(this.sessionStatus));
            }
        }
        catch (IOException e) {
            throw new KNXException("I/O error establishing secure session with " + serverCtrlEP, e);
        }
        finally {
            Arrays.fill(this.publicKey, (byte)0);
        }
    }

    private boolean withinTolerance(InetAddress src, long timestamp, SerialNumber sn, int tag) {
        this.onGroupSync(src, timestamp, false, sn, tag);
        long diff = this.timestamp() - timestamp;
        return diff <= (long)this.mcastLatencyTolerance;
    }

    private void onGroupSync(InetAddress src, long timestamp, boolean byTimerNotify, SerialNumber sn, int tag) {
        long local = this.timestamp();
        if (timestamp > local) {
            this.logger.debug("sync timestamp +{} ms", (Object)(timestamp - local));
            this.timestampOffset += timestamp - local;
            this.syncedWithGroup(byTimerNotify, sn, tag);
        } else if (timestamp > local - (long)this.syncLatencyTolerance) {
            if (tag != this.sentGroupSyncTag || !this.isLocalIpAddress(src)) {
                this.syncedWithGroup(byTimerNotify, sn, tag);
            }
        } else if (timestamp <= local - (long)this.mcastLatencyTolerance && this.periodicSchedule) {
            this.timerNotifySN = sn;
            this.timerNotifyTag = tag;
            this.periodicSchedule = false;
            this.scheduleGroupSync(SecureConnection.randomClosedRange(this.minDelayUpdateNotify, this.maxDelayUpdateNotify));
        }
    }

    private synchronized void becomeTimeFollower() {
        int maxDelayTimeKeeperUpdateNotify = 100 + 1 * this.syncLatencyTolerance;
        int minDelayTimeKeeperPeriodicNotify = 10000;
        int maxDelayTimeKeeperPeriodicNotify = 10000 + 3 * this.syncLatencyTolerance;
        int minDelayTimeFollowerUpdateNotify = maxDelayTimeKeeperUpdateNotify + 1 * this.syncLatencyTolerance;
        int maxDelayTimeFollowerUpdateNotify = minDelayTimeFollowerUpdateNotify + 10 * this.syncLatencyTolerance;
        int minDelayTimeFollowerPeriodicNotify = maxDelayTimeKeeperPeriodicNotify + 1 * this.syncLatencyTolerance;
        int maxDelayTimeFollowerPeriodicNotify = minDelayTimeFollowerPeriodicNotify + 10 * this.syncLatencyTolerance;
        this.minDelayUpdateNotify = minDelayTimeFollowerUpdateNotify;
        this.maxDelayUpdateNotify = maxDelayTimeFollowerUpdateNotify;
        this.minDelayPeriodicNotify = minDelayTimeFollowerPeriodicNotify;
        this.maxDelayPeriodicNotify = maxDelayTimeFollowerPeriodicNotify;
    }

    private synchronized void becomeTimeKeeper() {
        int maxDelayTimeKeeperUpdateNotify = 100 + 1 * this.syncLatencyTolerance;
        int minDelayTimeKeeperPeriodicNotify = 10000;
        int maxDelayTimeKeeperPeriodicNotify = 10000 + 3 * this.syncLatencyTolerance;
        this.minDelayUpdateNotify = 100;
        this.maxDelayUpdateNotify = maxDelayTimeKeeperUpdateNotify;
        this.minDelayPeriodicNotify = 10000;
        this.maxDelayPeriodicNotify = maxDelayTimeKeeperPeriodicNotify;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncedWithGroup(boolean byTimerNotify, SerialNumber sn, int tag) {
        if (byTimerNotify) {
            this.becomeTimeFollower();
        }
        this.scheduleGroupSync(this.periodicNotifyDelay());
        if (!this.syncedWithGroup && tag == this.sentGroupSyncTag && this.sno.equals(sn)) {
            this.logger.info("synchronized with group {}", (Object)this.getRemoteAddress().getAddress().getHostAddress());
            this.syncedWithGroup = true;
            SecureConnection secureConnection = this;
            synchronized (secureConnection) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitGroupSync() throws InterruptedException {
        long wait = 2 * this.mcastLatencyTolerance + 100 + 12 * this.syncLatencyTolerance;
        long end = System.nanoTime() / 1000000L + wait;
        long remaining = wait;
        while (remaining > 0L && !this.syncedWithGroup) {
            SecureConnection secureConnection = this;
            synchronized (secureConnection) {
                this.wait(remaining);
            }
            remaining = end - System.nanoTime() / 1000000L;
        }
        this.syncedWithGroup = true;
        this.logger.trace("waited {} ms for group sync", (Object)(wait - remaining));
    }

    private boolean isLocalIpAddress(InetAddress addr) {
        Stream<NetworkInterface> netifs = Stream.empty();
        try {
            InetAddress local = ((InetSocketAddress)this.channel().getLocalAddress()).getAddress();
            if (addr.equals(local)) {
                return true;
            }
            NetworkInterface ni2 = this.channel().getOption(StandardSocketOptions.IP_MULTICAST_IF);
            boolean noneSet = ni2 == null || ni2.getInetAddresses().nextElement().isAnyLocalAddress();
            netifs = noneSet ? NetworkInterface.networkInterfaces() : Stream.of(ni2);
        }
        catch (IOException iOException) {
        }
        return netifs.flatMap(ni -> ni.inetAddresses()).anyMatch(addr::equals);
    }

    private void scheduleGroupSync(long initialDelay) {
        this.logger.trace("schedule group sync (initial delay {} ms)", (Object)initialDelay);
        this.groupSync.cancel(true);
        this.groupSync = groupSyncSender.scheduleWithFixedDelay(this::sendGroupSync, initialDelay, 10000L, TimeUnit.MILLISECONDS);
    }

    private void sendGroupSync() {
        try {
            long timestamp = this.timestamp();
            byte[] sync = this.newGroupSync(timestamp);
            this.logger.debug("sending group sync timestamp {} ms (S/N {}, tag {})", new Object[]{timestamp, this.periodicSchedule ? this.sno : this.timerNotifySN, this.periodicSchedule ? this.sentGroupSyncTag : this.timerNotifyTag});
            this.becomeTimeKeeper();
            this.scheduleGroupSync(this.periodicNotifyDelay());
            this.channel().send(ByteBuffer.wrap(sync), this.dataEndpt);
        }
        catch (IOException | RuntimeException e) {
            if (!this.channel().isOpen()) {
                this.groupSync.cancel(true);
                throw new CancellationException("stop group sync for " + this);
            }
            this.logger.warn("sending group sync failed", (Throwable)e);
        }
    }

    private long timestamp() {
        long now = System.nanoTime() / 1000000L;
        return now + this.timestampOffset;
    }

    private synchronized int periodicNotifyDelay() {
        this.periodicSchedule = true;
        return SecureConnection.randomClosedRange(this.minDelayPeriodicNotify, this.maxDelayPeriodicNotify);
    }

    private static int randomClosedRange(int min, int max) {
        return ThreadLocalRandom.current().nextInt(min, max + 1);
    }

    private byte[] newSecurePacket(long seq, int msgTag, byte[] knxipPacket) {
        if (seq < 0L || seq > 0xFFFFFFFFFFFFL) {
            throw new KNXIllegalArgumentException("sequence / group counter " + seq + " out of range [0..0xffffffffffff]");
        }
        if (msgTag < 0 || msgTag > 65535) {
            throw new KNXIllegalArgumentException("message tag " + msgTag + " out of range [0..0xffff]");
        }
        int svcLength = 16 + knxipPacket.length + 16;
        KNXnetIPHeader header = new KNXnetIPHeader(2384, svcLength);
        ByteBuffer buffer = ByteBuffer.allocate(header.getTotalLength());
        buffer.put(header.toByteArray());
        buffer.putShort((short)this.sessionId);
        buffer.putShort((short)(seq >> 32));
        buffer.putInt((int)seq);
        buffer.put(this.sno.array());
        buffer.putShort((short)msgTag);
        buffer.put(knxipPacket);
        byte[] secInfo = SecureConnection.securityInfo(buffer.array(), header.getStructLength() + 2, knxipPacket.length);
        byte[] mac = this.cbcMac(buffer.array(), 0, buffer.position(), secInfo);
        buffer.put(mac);
        this.encrypt(buffer.array(), header.getStructLength() + 2 + 6 + 6 + 2, SecureConnection.securityInfo(buffer.array(), 8, 65280));
        return buffer.array();
    }

    public static byte[] newSecurePacket(long sessionId, long seq, SerialNumber sno, int msgTag, byte[] knxipPacket, Key secretKey) {
        if (seq < 0L || seq > 0xFFFFFFFFFFFFL) {
            throw new KNXIllegalArgumentException("sequence / group counter " + seq + " out of range [0..0xffffffffffff]");
        }
        if (msgTag < 0 || msgTag > 65535) {
            throw new KNXIllegalArgumentException("message tag " + msgTag + " out of range [0..0xffff]");
        }
        int svcLength = 16 + knxipPacket.length + 16;
        KNXnetIPHeader header = new KNXnetIPHeader(2384, svcLength);
        ByteBuffer buffer = ByteBuffer.allocate(header.getTotalLength());
        buffer.put(header.toByteArray());
        buffer.putShort((short)sessionId);
        buffer.putShort((short)(seq >> 32));
        buffer.putInt((int)seq);
        buffer.put(sno.array());
        buffer.putShort((short)msgTag);
        buffer.put(knxipPacket);
        byte[] secInfo = SecureConnection.securityInfo(buffer.array(), header.getStructLength() + 2, knxipPacket.length);
        byte[] mac = SecureConnection.cbcMac(buffer.array(), 0, buffer.position(), secretKey, secInfo);
        buffer.put(mac);
        SecureConnection.encrypt(buffer.array(), header.getStructLength() + 2 + 6 + 6 + 2, secretKey, SecureConnection.securityInfo(buffer.array(), 8, 65280));
        return buffer.array();
    }

    private Object[] unwrap(KNXnetIPHeader h, byte[] data, int offset) throws KNXFormatException {
        long rcvSeq;
        Object[] fields = SecureConnection.unwrap(h, data, offset, this.secretKey);
        int sid = (Integer)fields[0];
        if (sid != this.sessionId) {
            throw new KnxSecureException("secure session mismatch: received ID " + sid + ", expected " + this.sessionId);
        }
        long seq = (Long)fields[1];
        if (this.sessionId != 0 && seq < (rcvSeq = this.session.nextReceiveSeq())) {
            throw new KnxSecureException("received secure packet with sequence " + seq + " < expected " + rcvSeq);
        }
        SerialNumber sn = (SerialNumber)fields[2];
        int tag = (Integer)fields[3];
        byte[] knxipPacket = (byte[])fields[4];
        this.logger.trace("received {} (session {} seq {} S/N {} tag {})", new Object[]{DataUnitBuilder.toHex(knxipPacket, " "), sid, seq, sn, tag});
        return new Object[]{fields[0], fields[1], sn, fields[3], fields[4]};
    }

    public static Object[] unwrap(KNXnetIPHeader h, byte[] data, int offset, Key secretKey) throws KNXFormatException {
        int hdrLength;
        int minLength;
        if ((h.getServiceType() & 0x950) != 2384) {
            throw new KNXIllegalArgumentException("not a secure service type");
        }
        int total = h.getTotalLength();
        if (total < (minLength = (hdrLength = h.getStructLength()) + 2 + 6 + 6 + 2 + hdrLength + 16)) {
            throw new KNXFormatException("secure packet length < required minimum length " + minLength, total);
        }
        ByteBuffer buffer = ByteBuffer.wrap(data, offset, total - hdrLength);
        int sid = buffer.getShort() & 0xFFFF;
        long seq = SecureConnection.uint48(buffer);
        SerialNumber sno = SerialNumber.of(SecureConnection.uint48(buffer));
        int tag = buffer.getShort() & 0xFFFF;
        ByteBuffer dec = SecureConnection.decrypt(buffer, secretKey, SecureConnection.securityInfo(data, offset + 2, 65280));
        byte[] knxipPacket = new byte[total - minLength + hdrLength];
        dec.get(knxipPacket);
        byte[] mac = new byte[16];
        dec.get(mac);
        byte[] frame = Arrays.copyOfRange(data, offset - hdrLength, offset - hdrLength + total);
        System.arraycopy(knxipPacket, 0, frame, hdrLength + 2 + 6 + 6 + 2, knxipPacket.length);
        SecureConnection.cbcMacVerify(frame, 0, total - 16, secretKey, SecureConnection.securityInfo(data, offset + 2, knxipPacket.length), mac);
        return new Object[]{sid, seq, sno, tag, knxipPacket};
    }

    private Object[] newSessionResponse(KNXnetIPHeader h, byte[] data, int offset, InetSocketAddress src) throws KNXFormatException {
        if (h.getServiceType() != 2386) {
            throw new IllegalArgumentException("no secure channel response");
        }
        if (h.getTotalLength() != 56 && h.getTotalLength() != 8) {
            throw new KNXFormatException("invalid length " + data.length + " for a secure channel response");
        }
        ByteBuffer buffer = ByteBuffer.wrap(data, offset, h.getTotalLength() - h.getStructLength());
        this.sessionId = buffer.getShort() & 0xFFFF;
        if (this.sessionId == 0) {
            throw new KnxSecureException("no more free secure channels / remote endpoint busy");
        }
        byte[] serverPublicKey = new byte[32];
        buffer.get(serverPublicKey);
        byte[] sharedSecret = SecureConnection.keyAgreement(this.privateKey, serverPublicKey);
        byte[] sessionKey = SecureConnection.sessionKey(sharedSecret);
        this.secretKey = SecureConnection.createSecretKey(sessionKey);
        boolean skipDeviceAuth = Arrays.equals(this.session.deviceAuthKey().getEncoded(), new byte[16]);
        if (skipDeviceAuth) {
            this.logger.warn("skipping device authentication of {} (no device key)", (Object)Net.hostPort(src));
        } else {
            ByteBuffer mac = SecureConnection.decrypt(buffer, this.session.deviceAuthKey(), SecureConnection.securityInfo(new byte[16], 0, 65280));
            int msgLen = h.getStructLength() + 2 + 32;
            ByteBuffer macInput = ByteBuffer.allocate(18 + msgLen);
            macInput.put(new byte[16]);
            macInput.put((byte)0);
            macInput.put((byte)msgLen);
            macInput.put(h.toByteArray());
            macInput.putShort((short)this.sessionId);
            macInput.put(SecureConnection.xor(serverPublicKey, 0, this.publicKey, 0, 32));
            byte[] verifyAgainst = this.cbcMacSimple(this.session.deviceAuthKey(), macInput.array(), 0, macInput.capacity());
            boolean authenticated = Arrays.equals(mac.array(), verifyAgainst);
            if (!authenticated) {
                String packet = DataUnitBuilder.toHex(Arrays.copyOfRange(data, offset - 6, offset - 6 + 56), " ");
                throw new KnxSecureException("authentication failed for session response " + packet);
            }
        }
        return new Object[]{this.sessionId, serverPublicKey};
    }

    private byte[] newSessionAuth(byte[] serverPublicKey) {
        KNXnetIPHeader header = new KNXnetIPHeader(2387, 18);
        ByteBuffer buffer = ByteBuffer.allocate(header.getTotalLength());
        buffer.put(header.toByteArray());
        buffer.putShort((short)this.session.user());
        int msgLen = 40;
        ByteBuffer macInput = ByteBuffer.allocate(58);
        macInput.put(new byte[16]);
        macInput.put((byte)0);
        macInput.put((byte)40);
        macInput.put(buffer.array(), 0, buffer.position());
        macInput.put(SecureConnection.xor(serverPublicKey, 0, this.publicKey, 0, 32));
        byte[] mac = this.cbcMacSimple(this.session.userKey(), macInput.array(), 0, macInput.capacity());
        SecureConnection.encrypt(mac, 0, this.session.userKey(), SecureConnection.securityInfo(new byte[16], 8, 65280));
        buffer.put(mac);
        return buffer.array();
    }

    static int newChannelStatus(KNXnetIPHeader h, byte[] data, int offset) throws KNXFormatException {
        if (h.getServiceType() != 2388) {
            throw new KNXIllegalArgumentException("no secure channel status");
        }
        if (h.getTotalLength() != 8) {
            throw new KNXFormatException("invalid length " + h.getTotalLength() + " for a secure channel status");
        }
        int status = data[offset] & 0xFF;
        return status;
    }

    private byte[] newGroupSync(long timestamp) {
        if (timestamp < 0L || timestamp > 0xFFFFFFFFFFFFL) {
            throw new KNXIllegalArgumentException("timestamp " + timestamp + " out of range [0..0xffffffffffff]");
        }
        KNXnetIPHeader header = new KNXnetIPHeader(2389, 30);
        ByteBuffer buffer = ByteBuffer.allocate(header.getTotalLength());
        buffer.put(header.toByteArray());
        buffer.putShort((short)(timestamp >> 32)).putInt((int)timestamp);
        if (this.periodicSchedule) {
            this.sentGroupSyncTag = SecureConnection.randomClosedRange(1, 65535);
            buffer.put(this.sno.array()).putShort((short)this.sentGroupSyncTag);
        } else {
            buffer.put(this.timerNotifySN.array()).putShort((short)this.timerNotifyTag);
        }
        byte[] mac = this.cbcMac(buffer.array(), 0, header.getStructLength() + 6 + 6 + 2, SecureConnection.securityInfo(buffer.array(), 6, 0));
        byte[] secInfo = SecureConnection.securityInfo(buffer.array(), 6, 65280);
        this.encrypt(mac, 0, secInfo);
        buffer.put(mac);
        return buffer.array();
    }

    private Object[] newGroupSync(KNXnetIPHeader h, byte[] data, int offset) throws KNXFormatException {
        if (h.getTotalLength() != 36) {
            throw new KNXFormatException("invalid length " + data.length + " for a secure group sync");
        }
        ByteBuffer buffer = ByteBuffer.wrap(data, offset, h.getTotalLength() - h.getStructLength());
        long timestamp = SecureConnection.uint48(buffer);
        byte[] sn = new byte[6];
        buffer.get(sn);
        int msgTag = buffer.getShort() & 0xFFFF;
        ByteBuffer mac = this.decrypt(buffer, SecureConnection.securityInfo(data, offset, 65280));
        byte[] secInfo = SecureConnection.securityInfo(buffer.array(), 6, 0);
        SecureConnection.cbcMacVerify(data, offset - h.getStructLength(), h.getTotalLength() - 16, this.secretKey, secInfo, mac.array());
        this.logger.trace("received group sync timestamp {} ms (S/N {}, tag {})", new Object[]{timestamp, DataUnitBuilder.toHex(sn, ""), msgTag});
        return new Object[]{timestamp, SerialNumber.from(sn), msgTag};
    }

    private void encrypt(byte[] data, int offset, byte[] secInfo) {
        SecureConnection.encrypt(data, offset, this.secretKey, secInfo);
    }

    public static void encrypt(byte[] data, int offset, Key secretKey, byte[] secInfo) {
        try {
            ByteBuffer encrypt = ByteBuffer.wrap(data, offset, data.length - offset);
            ByteBuffer result = SecureConnection.cipher(encrypt, secretKey, secInfo);
            System.arraycopy(result.array(), 0, data, offset, result.remaining());
        }
        catch (GeneralSecurityException e) {
            throw new KnxSecureException("encrypting error", e);
        }
    }

    private ByteBuffer decrypt(ByteBuffer buffer, byte[] secInfo) {
        return SecureConnection.decrypt(buffer, this.secretKey, secInfo);
    }

    static ByteBuffer decrypt(ByteBuffer buffer, Key secretKey, byte[] secInfo) {
        try {
            return SecureConnection.cipher(buffer, secretKey, secInfo);
        }
        catch (GeneralSecurityException e) {
            throw new KnxSecureException("decrypting error", e);
        }
    }

    private static ByteBuffer cipher(ByteBuffer buffer, Key secretKey, byte[] secInfo) throws GeneralSecurityException {
        int i;
        int blocks = buffer.remaining() + 15 >> 4;
        byte[] cipher = SecureConnection.cipherStream(blocks, secretKey, secInfo);
        ByteBuffer result = ByteBuffer.allocate(buffer.remaining());
        if (blocks > 1) {
            i = 0;
            while (result.remaining() > 16) {
                result.put((byte)(buffer.get() ^ cipher[16 + i]));
                ++i;
            }
        }
        i = 0;
        while (result.hasRemaining()) {
            result.put((byte)(buffer.get() ^ cipher[i]));
            ++i;
        }
        return result.flip();
    }

    private static byte[] cipherStream(int blocks, Key secretKey, byte[] secInfo) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
        cipher.init(1, secretKey);
        int blockSize = 16;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < blocks; ++i) {
            byte[] output = cipher.update(secInfo);
            baos.write(output, 0, 16);
            secInfo[15] = (byte)(secInfo[15] + 1);
        }
        return baos.toByteArray();
    }

    private static void cbcMacVerify(byte[] data, int offset, int length, Key secretKey, byte[] secInfo, byte[] verifyAgainst) {
        byte[] mac = SecureConnection.cbcMac(data, offset, length, secretKey, secInfo);
        boolean authenticated = Arrays.equals(mac, verifyAgainst);
        if (!authenticated) {
            String packet = DataUnitBuilder.toHex(Arrays.copyOfRange(data, offset, offset + length), " ");
            throw new KnxSecureException("authentication failed for " + packet);
        }
    }

    private byte[] cbcMac(byte[] data, int offset, int length, byte[] secInfo) {
        return SecureConnection.cbcMac(data, offset, length, this.secretKey, secInfo);
    }

    private static byte[] cbcMac(byte[] data, int offset, int length, Key secretKey, byte[] secInfo) {
        byte[] log = Arrays.copyOfRange(data, offset, offset + length);
        byte[] hdr = Arrays.copyOfRange(data, offset, offset + 6);
        int packetOffset = hdr.length + 2 + 6 + 6 + 2;
        byte[] session = new byte[]{};
        byte[] frame = new byte[]{};
        if (length > packetOffset) {
            session = Arrays.copyOfRange(data, offset + 6, offset + 8);
            frame = Arrays.copyOfRange(data, offset + packetOffset, offset + length);
        }
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            IvParameterSpec ivSpec = new IvParameterSpec(new byte[16]);
            cipher.init(1, secretKey, ivSpec);
            cipher.update(secInfo);
            byte[] lenBuf = new byte[]{0, (byte)(hdr.length + session.length)};
            cipher.update(lenBuf);
            cipher.update(hdr);
            cipher.update(session);
            int checkLength = 24 + session.length + frame.length;
            byte[] padded = Arrays.copyOfRange(frame, 0, frame.length + 15 - (checkLength + 15) % 16);
            byte[] result = cipher.doFinal(padded);
            byte[] mac = Arrays.copyOfRange(result, result.length - 16, result.length);
            return mac;
        }
        catch (GeneralSecurityException e) {
            throw new KnxSecureException("calculating CBC-MAC of " + DataUnitBuilder.toHex(log, " "), e);
        }
    }

    private byte[] cbcMacSimple(Key secretKey, byte[] data, int offset, int length) {
        byte[] exact = Arrays.copyOfRange(data, offset, offset + length);
        this.logger.trace("authenticating (length {}): {}", (Object)length, (Object)DataUnitBuilder.toHex(exact, " "));
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            IvParameterSpec ivSpec = new IvParameterSpec(new byte[16]);
            cipher.init(1, secretKey, ivSpec);
            byte[] padded = Arrays.copyOfRange(exact, 0, (length + 15) / 16 * 16);
            byte[] result = cipher.doFinal(padded);
            byte[] mac = Arrays.copyOfRange(result, result.length - 16, result.length);
            return mac;
        }
        catch (GeneralSecurityException e) {
            throw new KnxSecureException("calculating CBC-MAC of " + DataUnitBuilder.toHex(exact, " "), e);
        }
    }

    static byte[] securityInfo(byte[] data, int offset, int lengthInfo) {
        byte[] secInfo = Arrays.copyOfRange(data, offset, offset + 16);
        secInfo[14] = (byte)(lengthInfo >> 8);
        secInfo[15] = (byte)lengthInfo;
        return secInfo;
    }

    static String statusMsg(int status) {
        String[] msg = new String[]{"authorization success", "authorization failed", "unauthorized", "timeout", "keep-alive", "close"};
        if (status >= msg.length) {
            return "unknown status " + status;
        }
        return msg[status];
    }

    static SecretKey createSecretKey(byte[] key) {
        if (key.length != 16) {
            throw new KNXIllegalArgumentException("KNX key has to be 16 bytes in length");
        }
        SecretKeySpec spec = new SecretKeySpec(key, "AES");
        Arrays.fill(key, (byte)0);
        return spec;
    }

    private static KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator gen = KeyPairGenerator.getInstance("X25519");
        return gen.generateKeyPair();
    }

    static byte[] keyAgreement(PrivateKey privateKey, byte[] spk) {
        try {
            byte[] reversed = (byte[])spk.clone();
            SecureConnection.reverse(reversed);
            XECPublicKeySpec spec = new XECPublicKeySpec(NamedParameterSpec.X25519, new BigInteger(1, reversed));
            PublicKey pubKey = KeyFactory.getInstance("X25519").generatePublic(spec);
            KeyAgreement ka = KeyAgreement.getInstance("X25519");
            ka.init(privateKey);
            ka.doPhase(pubKey, true);
            return ka.generateSecret();
        }
        catch (GeneralSecurityException e) {
            throw new KnxSecureException("key agreement failed", e);
        }
    }

    static byte[] sessionKey(byte[] sharedSecret) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(sharedSecret);
            return Arrays.copyOfRange(hash, 0, 16);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KnxSecureException("platform does not support SHA-256 algorithm", e);
        }
    }

    static byte[] xor(byte[] a, int offsetA, byte[] b, int offsetB, int len) {
        if (a.length - len < offsetA || b.length - len < offsetB) {
            throw new KNXIllegalArgumentException("illegal offset or length");
        }
        byte[] res = new byte[len];
        for (int i = 0; i < len; ++i) {
            res[i] = (byte)(a[i + offsetA] ^ b[i + offsetB]);
        }
        return res;
    }

    private static long uint48(ByteBuffer buffer) {
        long l = ((long)buffer.getShort() & 0xFFFFL) << 32;
        return l |= (long)buffer.getInt() & 0xFFFFFFFFL;
    }

    private static void reverse(byte[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            byte b = array[i];
            array[i] = array[array.length - 1 - i];
            array[array.length - 1 - i] = b;
        }
    }

    static {
        groupSyncSender.setKeepAliveTime(30L, TimeUnit.SECONDS);
        groupSyncSender.allowCoreThreadTimeOut(true);
        groupSyncSender.setRemoveOnCancelPolicy(true);
    }
}

