/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.servicetype;

import java.io.ByteArrayOutputStream;
import java.net.InetAddress;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.knxnetip.servicetype.ServiceType;
import tuwien.auto.calimero.knxnetip.util.CRI;
import tuwien.auto.calimero.knxnetip.util.HPAI;

public class ConnectRequest
extends ServiceType {
    private final CRI cri;
    private final HPAI ctrlPt;
    private final HPAI dataPt;

    public ConnectRequest(byte[] data, int offset) throws KNXFormatException {
        super(517);
        this.ctrlPt = new HPAI(data, offset);
        int i = offset + this.ctrlPt.getStructLength();
        this.dataPt = new HPAI(data, i);
        this.cri = CRI.createRequest(data, i + this.dataPt.getStructLength());
    }

    public ConnectRequest(CRI requestInfo, HPAI ctrlEndpoint, HPAI dataEndpoint) {
        super(517);
        this.cri = requestInfo;
        this.ctrlPt = ctrlEndpoint;
        this.dataPt = dataEndpoint;
    }

    public ConnectRequest(CRI requestInfo, int localPort) {
        super(517);
        this.cri = requestInfo;
        this.dataPt = this.ctrlPt = new HPAI((InetAddress)null, localPort);
    }

    public final CRI getCRI() {
        return this.cri;
    }

    public final HPAI getControlEndpoint() {
        return this.ctrlPt;
    }

    public final HPAI getDataEndpoint() {
        return this.dataPt;
    }

    @Override
    int getStructLength() {
        return this.ctrlPt.getStructLength() + this.dataPt.getStructLength() + this.cri.getStructLength();
    }

    @Override
    byte[] toByteArray(ByteArrayOutputStream os) {
        byte[] buf = this.ctrlPt.toByteArray();
        os.write(buf, 0, buf.length);
        buf = this.dataPt.toByteArray();
        os.write(buf, 0, buf.length);
        buf = this.cri.toByteArray();
        os.write(buf, 0, buf.length);
        return os.toByteArray();
    }
}

