/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.servicetype;

import java.io.ByteArrayOutputStream;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.knxnetip.servicetype.ServiceType;

public class RoutingLostMessage
extends ServiceType {
    private final int lost;
    private final int state;

    public RoutingLostMessage(byte[] data, int offset) throws KNXFormatException {
        super(1329);
        if (data.length - offset < 4) {
            throw new KNXFormatException("buffer too short for lost messages info");
        }
        int size = data[offset] & 0xFF;
        if (size != 4) {
            throw new KNXFormatException("wrong size for lost messages info", size);
        }
        this.state = data[offset + 1] & 0xFF;
        this.lost = (data[offset + 2] & 0xFF) << 8 | data[offset + 3] & 0xFF;
    }

    public RoutingLostMessage(int lostMessages, int deviceState) {
        super(1329);
        if (lostMessages < 0 || lostMessages > 65535) {
            throw new KNXIllegalArgumentException("lost message count out of range [0..0xFFFF]");
        }
        if (deviceState < 0 || deviceState > 255) {
            throw new KNXIllegalArgumentException("device state field out of range [0..0xFF]");
        }
        if (deviceState > 3) {
            ServiceType.logger.info("Bits 2..7 not supported in device state");
        }
        this.lost = lostMessages;
        this.state = deviceState;
    }

    public final int getLostMessages() {
        return this.lost;
    }

    public final int getDeviceState() {
        return this.state;
    }

    public final boolean isKNXFault() {
        return (this.state & 1) != 0;
    }

    @Override
    int getStructLength() {
        return 4;
    }

    @Override
    byte[] toByteArray(ByteArrayOutputStream os) {
        os.write(4);
        os.write(this.state);
        os.write(this.lost >> 8);
        os.write(this.lost);
        return os.toByteArray();
    }
}

