/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.servicetype;

import java.io.ByteArrayOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.knxnetip.servicetype.KNXnetIPHeader;
import tuwien.auto.calimero.knxnetip.servicetype.ServiceType;
import tuwien.auto.calimero.knxnetip.util.HPAI;
import tuwien.auto.calimero.knxnetip.util.Srp;

public class SearchRequest
extends ServiceType {
    private final HPAI endpoint;
    private final List<Srp> srps = new ArrayList<Srp>();
    private static final int MinimumStructSize = 8;

    public static SearchRequest from(KNXnetIPHeader h, byte[] data, int offset) throws KNXFormatException {
        int svcType = h.getServiceType();
        if (svcType != 513 && svcType != 523) {
            throw new KNXIllegalArgumentException("not a search request");
        }
        return new SearchRequest(svcType, data, offset, h.getTotalLength() - h.getStructLength());
    }

    public static SearchRequest newTcpRequest(Srp ... searchParameters) {
        return new SearchRequest(searchParameters);
    }

    private SearchRequest(Srp ... searchParameters) {
        super(523);
        this.endpoint = HPAI.Tcp;
        for (Srp searchParameter : searchParameters) {
            this.srps.add(searchParameter);
        }
    }

    public SearchRequest(byte[] data, int offset) throws KNXFormatException {
        this(513, data, offset, 8);
    }

    private SearchRequest(int svc, byte[] data, int offset, int length) throws KNXFormatException {
        super(svc);
        if (length < 8) {
            throw new KNXFormatException("wrong size for search.req, requires 8 bytes", length);
        }
        this.endpoint = new HPAI(data, offset);
        if (svc == 523 && length > 8) {
            Srp srp;
            for (int index = this.endpoint.getStructLength(); index < length; index += srp.structLength()) {
                srp = new Srp(data, offset + index);
                this.srps.add(srp);
            }
        }
    }

    public SearchRequest(InetSocketAddress responseAddr) {
        super(513);
        this.endpoint = new HPAI(1, responseAddr);
    }

    public SearchRequest(InetSocketAddress responseAddr, Srp ... searchParameters) {
        super(523);
        this.endpoint = new HPAI(1, responseAddr);
        for (Srp searchParameter : searchParameters) {
            this.srps.add(searchParameter);
        }
    }

    public SearchRequest(int responsePort) {
        super(513);
        this.endpoint = new HPAI((InetAddress)null, responsePort);
    }

    public final HPAI getEndpoint() {
        return this.endpoint;
    }

    public final List<Srp> searchParameters() {
        return Collections.unmodifiableList(this.srps);
    }

    @Override
    int getStructLength() {
        return this.endpoint.getStructLength() + this.searchParametersSize();
    }

    @Override
    byte[] toByteArray(ByteArrayOutputStream os) {
        byte[] buf = this.endpoint.toByteArray();
        os.write(buf, 0, buf.length);
        if (this.svcType == 523) {
            for (Srp srp : this.srps) {
                buf = srp.toByteArray();
                os.write(buf, 0, buf.length);
            }
        }
        return os.toByteArray();
    }

    private int searchParametersSize() {
        if (this.svcType == 523) {
            return this.srps.stream().map(Srp::structLength).mapToInt(Integer::intValue).sum();
        }
        return 0;
    }
}

