/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.servicetype;

import java.io.ByteArrayOutputStream;
import java.util.Collection;
import java.util.List;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.knxnetip.servicetype.DescriptionResponse;
import tuwien.auto.calimero.knxnetip.servicetype.KNXnetIPHeader;
import tuwien.auto.calimero.knxnetip.servicetype.ServiceType;
import tuwien.auto.calimero.knxnetip.util.DIB;
import tuwien.auto.calimero.knxnetip.util.DeviceDIB;
import tuwien.auto.calimero.knxnetip.util.HPAI;
import tuwien.auto.calimero.knxnetip.util.ServiceFamiliesDIB;

public class SearchResponse
extends ServiceType {
    private final HPAI endpt;
    private final DescriptionResponse desc;

    public static SearchResponse from(KNXnetIPHeader h, byte[] data, int offset) throws KNXFormatException {
        int svcType = h.getServiceType();
        if (svcType != 514 && svcType != 524) {
            throw new KNXIllegalArgumentException("not a search response");
        }
        return new SearchResponse(svcType, data, offset, h.getTotalLength() - h.getStructLength());
    }

    public SearchResponse(byte[] data, int offset, int length) throws KNXFormatException {
        this(514, data, offset, length);
    }

    private SearchResponse(int svcType, byte[] data, int offset, int length) throws KNXFormatException {
        super(svcType);
        this.endpt = new HPAI(data, offset);
        this.desc = new DescriptionResponse(data, offset + this.endpt.getStructLength(), length - this.endpt.getStructLength());
    }

    public SearchResponse(HPAI ctrlEndpoint, DeviceDIB device, ServiceFamiliesDIB svcFamilies) {
        super(514);
        this.endpt = ctrlEndpoint;
        this.desc = new DescriptionResponse(device, svcFamilies, new DIB[0]);
    }

    public SearchResponse(boolean ext, HPAI ctrlEndpoint, List<DIB> dibs) {
        super(ext ? 524 : 514);
        this.endpt = ctrlEndpoint;
        if (dibs.size() < 2) {
            throw new KNXIllegalArgumentException("search response shall contain device & service families DIB");
        }
        this.desc = new DescriptionResponse((DeviceDIB)dibs.get(0), (ServiceFamiliesDIB)dibs.get(1), dibs.subList(2, dibs.size()).toArray(new DIB[0]));
    }

    public final HPAI getControlEndpoint() {
        return this.endpt;
    }

    public final DeviceDIB getDevice() {
        return this.desc.getDevice();
    }

    public final ServiceFamiliesDIB getServiceFamilies() {
        return this.desc.getServiceFamilies();
    }

    public final Collection<DIB> description() {
        return this.desc.getDescription();
    }

    public final boolean v2() {
        return this.svcType == 524;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SearchResponse)) {
            return false;
        }
        SearchResponse other = (SearchResponse)obj;
        return this.endpt.equals(other.endpt) && this.desc.equals(other.desc);
    }

    public int hashCode() {
        int prime = 17;
        return 17 * this.endpt.hashCode() + this.desc.hashCode();
    }

    @Override
    public String toString() {
        if (this.endpt.getHostProtocol() == 2) {
            return this.desc.toString();
        }
        return this.endpt + " " + this.desc;
    }

    @Override
    int getStructLength() {
        return this.endpt.getStructLength() + this.desc.getStructLength();
    }

    @Override
    byte[] toByteArray(ByteArrayOutputStream os) {
        byte[] buf = this.endpt.toByteArray();
        os.write(buf, 0, buf.length);
        for (DIB dib : this.desc.getDescription()) {
            buf = dib.toByteArray();
            os.write(buf, 0, buf.length);
        }
        return os.toByteArray();
    }
}

