/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.servicetype;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.cemi.CEMIFactory;
import tuwien.auto.calimero.knxnetip.servicetype.ServiceType;

public class ServiceRequest
extends ServiceType {
    private static final int CONN_HEADER_SIZE = 4;
    private final int channelid;
    private final int seq;
    private CEMI cemi;

    public ServiceRequest(int serviceType, byte[] data, int offset, int length) throws KNXFormatException {
        this(serviceType, data, offset, length, null);
        if (this.svcType == 1056) {
            this.cemi = CEMIFactory.create(data, offset + 4, length - 4);
        } else if (this.svcType == 784) {
            this.cemi = CEMIFactory.create(data, offset + 4, length - 4);
        } else if (this.svcType == 1058 || this.svcType == 1059 || this.svcType == 1060 || this.svcType == 1061) {
            this.cemi = null;
        } else {
            throw new KNXIllegalArgumentException("unsupported service request type");
        }
    }

    public ServiceRequest(int serviceType, int channelID, int seqNumber, CEMI frame) {
        super(serviceType);
        if (serviceType < 0 || serviceType > 65535) {
            throw new KNXIllegalArgumentException("service request out of range [0..0xffff]");
        }
        if (channelID < 0 || channelID > 255) {
            throw new KNXIllegalArgumentException("channel ID out of range [0..0xff]");
        }
        if (seqNumber < 0 || seqNumber > 255) {
            throw new KNXIllegalArgumentException("sequence number out of range [0..0xff]");
        }
        this.channelid = channelID;
        this.seq = seqNumber;
        this.cemi = CEMIFactory.copy(frame);
    }

    ServiceRequest(int serviceType, byte[] data, int offset, int length, CEMI frame) throws KNXFormatException {
        super(serviceType);
        if (length < 4) {
            throw new KNXFormatException("buffer too short for service request");
        }
        ByteArrayInputStream is = new ByteArrayInputStream(data, offset, length);
        if (is.read() != 4) {
            throw new KNXFormatException("unsupported connection header");
        }
        this.channelid = is.read();
        this.seq = is.read();
        is.read();
        this.cemi = frame;
    }

    public final int getServiceType() {
        return this.svcType;
    }

    public final int getChannelID() {
        return this.channelid;
    }

    public final int getSequenceNumber() {
        return this.seq;
    }

    public final CEMI getCEMI() {
        return CEMIFactory.copy(this.cemi);
    }

    @Override
    int getStructLength() {
        return 4 + (this.cemi != null ? this.cemi.getStructLength() : 0);
    }

    @Override
    byte[] toByteArray(ByteArrayOutputStream os) {
        os.write(4);
        os.write(this.channelid);
        os.write(this.seq);
        os.write(0);
        byte[] buf = this.cemi.toByteArray();
        os.write(buf, 0, buf.length);
        return os.toByteArray();
    }
}

