/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.servicetype;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Optional;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.ReturnCode;
import tuwien.auto.calimero.knxnetip.servicetype.KNXnetIPHeader;
import tuwien.auto.calimero.knxnetip.servicetype.ServiceType;

public final class TunnelingFeature
extends ServiceType {
    private static final int MinServiceSize = 6;
    private static final int ConnHeaderSize = 4;
    private final int channelId;
    private final int seq;
    private final InterfaceFeature featureId;
    private final ReturnCode status;
    private final byte[] data;

    public static TunnelingFeature newGet(int channelId, int seq, InterfaceFeature featureId) {
        return new TunnelingFeature(1058, channelId, seq, featureId, ReturnCode.Success, new byte[0]);
    }

    public static TunnelingFeature newResponse(int channelId, int seq, InterfaceFeature featureId, ReturnCode result, byte ... featureValue) {
        return new TunnelingFeature(1059, channelId, seq, featureId, result, featureValue);
    }

    public static TunnelingFeature newSet(int channelId, int seq, InterfaceFeature featureId, byte ... featureValue) {
        return new TunnelingFeature(1060, channelId, seq, featureId, ReturnCode.Success, featureValue);
    }

    public static TunnelingFeature newInfo(int channelId, int seq, InterfaceFeature featureId, byte ... featureValue) {
        return new TunnelingFeature(1061, channelId, seq, featureId, ReturnCode.Success, featureValue);
    }

    public static TunnelingFeature from(int svcType, ByteBuffer buffer) throws KNXFormatException {
        return new TunnelingFeature(svcType, buffer);
    }

    private TunnelingFeature(int serviceType, int channelId, int seq, InterfaceFeature featureId, ReturnCode status, byte ... data) {
        super(serviceType);
        this.channelId = channelId;
        this.seq = seq;
        this.featureId = featureId;
        this.status = status;
        this.data = (byte[])data.clone();
        this.validateFeatureValueLength();
    }

    private TunnelingFeature(int svcType, ByteBuffer bb) throws KNXFormatException {
        super(svcType);
        if (bb.remaining() < 6) {
            throw new KNXFormatException("buffer too short for tunneling feature service");
        }
        int connHeaderSize = bb.get() & 0xFF;
        if (connHeaderSize != 4) {
            throw new KNXFormatException("tunneling feature connection header has wrong size", connHeaderSize);
        }
        this.channelId = bb.get() & 0xFF;
        this.seq = bb.get() & 0xFF;
        bb.get();
        int id = bb.get() & 0xFF;
        if (id > InterfaceFeature.values().length) {
            throw new KNXFormatException(ReturnCode.AddressVoid.description(), id);
        }
        this.featureId = InterfaceFeature.values()[id - 1];
        this.status = ReturnCode.of(bb.get() & 0xFF);
        if (this.status.code() > 240) {
            logger.warn("channel {} feature {} responded with '{}'", new Object[]{this.channelId, this.featureId, this.status});
        }
        this.data = new byte[bb.remaining()];
        bb.get(this.data);
        this.validateFeatureValueLength();
    }

    private void validateFeatureValueLength() {
        int length;
        if (this.svcType == 1058) {
            length = 0;
        } else {
            switch (this.featureId) {
                case SupportedEmiTypes: 
                case DeviceDescriptorType0: 
                case Manufacturer: 
                case IndividualAddress: 
                case MaxApduLength: {
                    length = 2;
                    break;
                }
                case ConnectionStatus: 
                case ActiveEmiType: 
                case EnableFeatureInfoService: {
                    length = 1;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (this.data.length != length) {
            throw new KNXIllegalArgumentException(String.format("%s %s value %s with invalid length %d, expected %d", new Object[]{KNXnetIPHeader.getSvcName(this.svcType), this.featureId, DataUnitBuilder.toHex(this.data, ""), this.data.length, length}));
        }
    }

    public int channelId() {
        return this.channelId;
    }

    public int sequenceNumber() {
        return this.seq;
    }

    public InterfaceFeature featureId() {
        return this.featureId;
    }

    public Optional<byte[]> featureValue() {
        return this.data.length > 0 ? Optional.of(this.data) : Optional.empty();
    }

    public ReturnCode status() {
        return this.status;
    }

    @Override
    public String toString() {
        ReturnCode s = this.status == ReturnCode.Success ? DataUnitBuilder.toHex(this.featureValue().orElse(new byte[0]), "") : this.status;
        return String.format("%s (channel %d) %s %s", new Object[]{KNXnetIPHeader.getSvcName(this.svcType), this.channelId, this.featureId, s});
    }

    @Override
    int getStructLength() {
        return 6 + this.data.length;
    }

    @Override
    byte[] toByteArray(ByteArrayOutputStream os) {
        os.write(4);
        os.write(this.channelId);
        os.write(this.seq);
        os.write(0);
        os.write(this.featureId.id());
        os.write(this.status.code());
        os.write(this.data, 0, this.data.length);
        return os.toByteArray();
    }

    public static enum InterfaceFeature {
        SupportedEmiTypes,
        DeviceDescriptorType0,
        ConnectionStatus,
        Manufacturer,
        ActiveEmiType,
        IndividualAddress,
        MaxApduLength,
        EnableFeatureInfoService;


        int id() {
            return this.ordinal() + 1;
        }

        public String toString() {
            return this.friendly();
        }

        private String friendly() {
            return this.name().replaceAll("(\\p{Lower})\\B([A-Z0])", "$1 $2").toLowerCase();
        }
    }
}

