/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.util;

import java.nio.ByteBuffer;
import java.util.Objects;
import tuwien.auto.calimero.DeviceDescriptor;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.knxnetip.util.DIB;

public class AdditionalDeviceDib
extends DIB {
    private static final int dibSize = 8;
    private final int status;
    private final int maxApduLength;
    private final DeviceDescriptor.DD0 dd;

    public AdditionalDeviceDib(int mediumStatus, int maxLocalApduLength, DeviceDescriptor.DD0 dd) {
        super(8, 8);
        this.status = mediumStatus;
        this.maxApduLength = maxLocalApduLength;
        this.dd = dd;
    }

    public AdditionalDeviceDib(byte[] data, int offset, int length) throws KNXFormatException {
        super(data, offset);
        if (this.type != 8) {
            throw new KNXFormatException("not a device DIB", this.type);
        }
        if (length != 8) {
            throw new KNXFormatException("device DIB with wrong size, expected 8 bytes", length);
        }
        ByteBuffer buf = ByteBuffer.wrap(data, offset + 2, length - 2);
        this.status = buf.get() & 0xFF;
        buf.get();
        this.maxApduLength = buf.getShort() & 0xFFFF;
        this.dd = DeviceDescriptor.DD0.from(buf.getShort() & 0xFFFF);
    }

    public final int maxLocalApduLength() {
        return this.maxApduLength;
    }

    public final DeviceDescriptor.DD0 deviceDescriptor() {
        return this.dd;
    }

    public final boolean communicationPossible() {
        return (this.status & 1) == 0;
    }

    public String toString() {
        String s = this.communicationPossible() ? "possible" : "impossible";
        return "DD0 " + this.dd + " communication " + s + ", max local APDU length " + this.maxApduLength;
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer buf = ByteBuffer.wrap(super.toByteArray()).position(2);
        buf.put((byte)this.status);
        buf.put((byte)0);
        buf.putShort((short)this.maxApduLength);
        buf.put(this.dd.toByteArray());
        return buf.array();
    }

    public int hashCode() {
        return Objects.hash(this.status, this.maxApduLength, this.dd);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AdditionalDeviceDib)) {
            return false;
        }
        AdditionalDeviceDib other = (AdditionalDeviceDib)obj;
        return this.status == other.status && this.maxApduLength == other.maxApduLength && this.dd == other.dd;
    }
}

