/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.util;

import tuwien.auto.calimero.KNXFormatException;

public abstract class DIB {
    public static final int DEVICE_INFO = 1;
    public static final int SUPP_SVC_FAMILIES = 2;
    public static final int IP_CONFIG = 3;
    public static final int IP_CURRENT_CONFIG = 4;
    public static final int KNX_ADDRESSES = 5;
    public static final int SecureServiceFamilies = 6;
    public static final int TunnelingInfo = 7;
    public static final int AdditionalDeviceInfo = 8;
    public static final int MFR_DATA = 254;
    final int size;
    final int type;

    protected DIB(byte[] data, int offset) throws KNXFormatException {
        if (data.length - offset < 2) {
            throw new KNXFormatException("buffer too short for DIB header");
        }
        this.size = data[offset] & 0xFF;
        this.type = data[offset + 1] & 0xFF;
        if (this.size > data.length - offset) {
            throw new KNXFormatException("DIB size bigger than actual data length", this.size);
        }
    }

    protected DIB(int dibSize, int descriptionType) {
        this.size = dibSize;
        this.type = descriptionType;
    }

    public final int getDescTypeCode() {
        return this.type;
    }

    public final int getStructLength() {
        return this.size;
    }

    public byte[] toByteArray() {
        byte[] buf = new byte[this.size];
        buf[0] = (byte)this.size;
        buf[1] = (byte)this.type;
        return buf;
    }
}

