/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Objects;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.SerialNumber;
import tuwien.auto.calimero.knxnetip.util.CRBase;
import tuwien.auto.calimero.knxnetip.util.DIB;

public class DeviceDIB
extends DIB {
    public static final int MEDIUM_TP1 = 2;
    public static final int MEDIUM_PL110 = 4;
    public static final int MEDIUM_RF = 16;
    public static final int MEDIUM_KNXIP = 32;
    private static final int DIB_SIZE = 54;
    private final int status;
    private final int knxmedium;
    private final SerialNumber serial;
    private final int installationId;
    private final IndividualAddress address;
    private final byte[] mcast;
    private final byte[] mac;
    private final String name;

    public DeviceDIB(byte[] data, int offset) throws KNXFormatException {
        super(data, offset);
        if (this.type != 1) {
            throw new KNXFormatException("DIB is not of type device info", this.type);
        }
        if (this.size < 54) {
            throw new KNXFormatException("device info DIB too short", this.size);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(data, offset + 2, data.length - offset - 2);
        this.knxmedium = is.read();
        this.status = is.read();
        this.address = new IndividualAddress(new byte[]{(byte)is.read(), (byte)is.read()});
        this.installationId = is.read() << 8 | is.read();
        try {
            this.serial = SerialNumber.from(is.readNBytes(6));
            this.mcast = is.readNBytes(4);
            this.mac = is.readNBytes(6);
        }
        catch (IOException e) {
            throw new KNXFormatException("device DIB initialization", e);
        }
        StringBuilder sbuf = new StringBuilder(30);
        int c = is.read();
        for (int i = 30; i > 0 && c > 0; --i) {
            sbuf.append((char)c);
            c = is.read();
        }
        this.name = sbuf.toString();
    }

    public DeviceDIB(String friendlyName, int deviceStatus, int projectInstallationId, int knxMedium, IndividualAddress knxAddress, SerialNumber serialNumber, InetAddress routingMulticast, byte[] macAddress) {
        super(54, 1);
        try {
            this.name = new String(friendlyName.getBytes("ISO-8859-1"), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("missing ISO 8859-1 charset, " + e.getMessage());
        }
        if (this.name.length() > 29) {
            throw new KNXIllegalArgumentException("friendly name exceeds 29 ISO 8859-1 characters");
        }
        if (deviceStatus < 0 || deviceStatus > 255) {
            throw new KNXIllegalArgumentException("device status out of range [0..255]");
        }
        this.status = deviceStatus;
        if (this.status > 1) {
            CRBase.logger.warn("device DIB \"" + friendlyName + "\": device status (" + this.status + ") uses reserved bits");
        }
        if (knxMedium != 2 && knxMedium != 4 && knxMedium != 16 && knxMedium != 32) {
            throw new KNXIllegalArgumentException("KNX medium not supported");
        }
        this.knxmedium = knxMedium;
        this.serial = serialNumber;
        if (projectInstallationId < 0 || projectInstallationId > 65535) {
            throw new KNXIllegalArgumentException("project installation ID out of range [0..0xffff");
        }
        this.installationId = projectInstallationId;
        this.address = knxAddress;
        if (!(routingMulticast instanceof Inet4Address) || !routingMulticast.isAnyLocalAddress() && !routingMulticast.isMulticastAddress()) {
            throw new KNXIllegalArgumentException(routingMulticast.toString() + " is not an IPv4 multicast address");
        }
        this.mcast = routingMulticast.getAddress();
        if (macAddress.length != 6) {
            throw new KNXIllegalArgumentException("MAC address length not equal to 6 bytes");
        }
        this.mac = (byte[])macAddress.clone();
    }

    @Deprecated
    public DeviceDIB(String friendlyName, int deviceStatus, int projectInstallationId, int knxMedium, IndividualAddress knxAddress, byte[] serialNumber, InetAddress routingMulticast, byte[] macAddress) {
        this(friendlyName, deviceStatus, projectInstallationId, knxMedium, knxAddress, SerialNumber.from(serialNumber), routingMulticast, macAddress);
    }

    public final IndividualAddress getAddress() {
        return this.address;
    }

    public final int getDeviceStatus() {
        return this.status;
    }

    public final int getKNXMedium() {
        return this.knxmedium;
    }

    public String getKNXMediumString() {
        switch (this.knxmedium) {
            case 2: {
                return "TP1";
            }
            case 4: {
                return "PL110";
            }
            case 16: {
                return "RF";
            }
            case 32: {
                return "KNX IP";
            }
        }
        return "unknown";
    }

    public final byte[] getMACAddress() {
        return (byte[])this.mac.clone();
    }

    public final String getMACAddressString() {
        return DataUnitBuilder.toHex(this.mac, ":");
    }

    public final byte[] getMulticastAddress() {
        return (byte[])this.mcast.clone();
    }

    public final int getProjectInstallID() {
        return this.installationId;
    }

    public final int getProject() {
        return this.installationId >> 4;
    }

    public final int getInstallation() {
        return this.installationId & 0xF;
    }

    @Deprecated(forRemoval=true)
    public final byte[] getSerialNumber() {
        return this.serial.array();
    }

    public final SerialNumber serialNumber() {
        return this.serial;
    }

    @Deprecated(forRemoval=true)
    public final String getSerialNumberString() {
        return this.serial.toString();
    }

    public final String getName() {
        return this.name;
    }

    public String toString() {
        String mc = "-";
        try {
            mc = InetAddress.getByAddress(this.getMulticastAddress()).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return "\"" + this.name + "\", KNX address " + this.address + ", KNX medium " + this.getKNXMediumString() + ", Installation " + this.getInstallation() + " - Project " + this.getProject() + " (ID " + this.installationId + "), KNX IP multicast address " + mc + ", MAC address " + this.getMACAddressString() + ", S/N " + this.getSerialNumberString();
    }

    @Override
    public byte[] toByteArray() {
        int k;
        byte[] buf = super.toByteArray();
        int i = 2;
        buf[i++] = (byte)this.knxmedium;
        buf[i++] = (byte)this.status;
        byte[] addr = this.address.toByteArray();
        buf[i++] = addr[0];
        buf[i++] = addr[1];
        buf[i++] = (byte)(this.installationId >> 8);
        buf[i++] = (byte)this.installationId;
        byte[] sno = this.serial.array();
        for (k = 0; k < 6; ++k) {
            buf[i++] = sno[k];
        }
        for (k = 0; k < 4; ++k) {
            buf[i++] = this.mcast[k];
        }
        for (k = 0; k < 6; ++k) {
            buf[i++] = this.mac[k];
        }
        for (k = 0; k < this.name.length(); ++k) {
            buf[i++] = (byte)this.name.charAt(k);
        }
        return buf;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hash(this.status, this.knxmedium, this.installationId, this.address, this.name);
        result = 31 * result + this.serial.hashCode();
        result = 31 * result + Arrays.hashCode(this.mcast);
        result = 31 * result + Arrays.hashCode(this.mac);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DeviceDIB)) {
            return false;
        }
        DeviceDIB other = (DeviceDIB)obj;
        return this.address.equals(other.address) && this.name.equals(other.name) && this.status == other.status && this.knxmedium == other.knxmedium && this.serial.equals(other.serial) && this.installationId == other.installationId && Arrays.equals(this.mcast, other.mcast) && Arrays.equals(this.mac, other.mac) && this.name.equals(other.name);
    }
}

