/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.util;

import java.io.ByteArrayOutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Objects;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;

public class HPAI {
    public static final int IPV4_UDP = 1;
    public static final int IPV4_TCP = 2;
    public static final HPAI Tcp = new HPAI(2, null);
    private static final int HPAI_SIZE = 8;
    private final int length;
    private final int hostprot;
    private final InetSocketAddress addr;

    public HPAI(byte[] data, int offset) throws KNXFormatException {
        if (data.length - offset < 8) {
            throw new KNXFormatException("buffer too short for HPAI");
        }
        int i = offset;
        this.length = data[i++] & 0xFF;
        if (this.length != 8) {
            throw new KNXFormatException("unknown HPAI size", this.length);
        }
        this.hostprot = data[i++] & 0xFF;
        if (this.hostprot != 1 && this.hostprot != 2) {
            throw new KNXFormatException("unknown host protocol", this.hostprot);
        }
        byte[] address = Arrays.copyOfRange(data, i, i += 4);
        int port = (data[i++] & 0xFF) << 8 | data[i] & 0xFF;
        try {
            this.addr = new InetSocketAddress(InetAddress.getByAddress(address), port);
        }
        catch (UnknownHostException e) {
            throw new KNXFormatException("invalid IPv4 address", e);
        }
        if (this.hostprot == 2 && !this.isRouteBack()) {
            throw new KNXFormatException("HPAI for TCP does not contain route back endpoint", this.hostPort());
        }
    }

    public HPAI(InetAddress addr, int port) {
        this(1, HPAI.addrOrDefault(addr), port);
    }

    public HPAI(int hostProtocol, InetAddress addr, int port) {
        this(hostProtocol, new InetSocketAddress(addr, port));
    }

    public HPAI(int hostProtocol, InetSocketAddress addr) {
        this.length = 8;
        if (hostProtocol != 1 && hostProtocol != 2) {
            throw new KNXIllegalArgumentException("unknown host protocol");
        }
        this.hostprot = hostProtocol;
        if (addr != null) {
            InetAddress a = addr.getAddress();
            if (a == null) {
                throw new KNXIllegalArgumentException(addr + " is an unresolved IP address");
            }
            if (!(a instanceof Inet4Address)) {
                throw new KNXIllegalArgumentException(a + " is not an IPv4 address");
            }
            if (a.isAnyLocalAddress() && addr.getPort() != 0) {
                throw new KNXIllegalArgumentException(a + " is a wildcard IP address");
            }
            this.addr = addr;
            if (this.hostprot == 2 && !this.isRouteBack()) {
                throw new KNXIllegalArgumentException("HPAI for TCP does not contain route back endpoint: " + this.hostPort());
            }
        } else {
            this.addr = new InetSocketAddress(0);
        }
    }

    public final int getHostProtocol() {
        return this.hostprot;
    }

    public final boolean isRouteBack() {
        return this.addr.getAddress().isAnyLocalAddress() && this.addr.getPort() == 0;
    }

    public final InetSocketAddress endpoint() {
        return this.addr;
    }

    @Deprecated
    public final byte[] getRawAddress() {
        return this.addr.getAddress().getAddress();
    }

    public final InetAddress getAddress() {
        return this.addr.getAddress();
    }

    public final int getPort() {
        return this.addr.getPort();
    }

    public final int getStructLength() {
        return this.length;
    }

    public final byte[] toByteArray() {
        ByteArrayOutputStream os = new ByteArrayOutputStream(8);
        os.write(this.length);
        os.write(this.hostprot);
        os.write(this.addr.getAddress().getAddress(), 0, 4);
        os.write(this.addr.getPort() >> 8);
        os.write(this.addr.getPort());
        return os.toByteArray();
    }

    public String toString() {
        return this.hostPort() + " (IPv4 " + (this.hostprot == 1 ? "UDP" : "TCP") + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HPAI)) {
            return false;
        }
        HPAI other = (HPAI)obj;
        return this.length == other.length && this.hostprot == other.hostprot && this.addr.equals(other.addr);
    }

    public int hashCode() {
        return Objects.hash(this.length, this.hostprot, this.addr);
    }

    private String hostPort() {
        return this.addr.getAddress().getHostAddress() + ":" + this.addr.getPort();
    }

    private static InetAddress addrOrDefault(InetAddress addr) {
        try {
            return addr != null ? addr : InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            try {
                return InetAddress.getByAddress(new byte[4]);
            }
            catch (UnknownHostException unreachable) {
                throw new Error("raw IPv4 addresses should always work", unreachable);
            }
        }
    }
}

