/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.util;

import java.io.ByteArrayInputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Objects;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.knxnetip.util.DIB;

public final class IPConfigDIB
extends DIB {
    private static final int DIB_SIZE = 16;
    private final byte[] ip;
    private final byte[] subnet;
    private final byte[] gw;
    private final int caps;
    private final int assignment;

    public IPConfigDIB(byte[] data, int offset) throws KNXFormatException {
        super(data, offset);
        if (this.type != 3) {
            throw new KNXFormatException("no IP config DIB, wrong type ID " + this.type);
        }
        if (this.size < 16) {
            throw new KNXFormatException("IP config DIB too short, " + this.size + " < 16");
        }
        ByteArrayInputStream is = new ByteArrayInputStream(data, offset + 2, data.length - offset - 2);
        this.ip = new byte[4];
        this.subnet = new byte[4];
        this.gw = new byte[4];
        is.read(this.ip, 0, this.ip.length);
        is.read(this.subnet, 0, this.subnet.length);
        is.read(this.gw, 0, this.gw.length);
        this.caps = is.read();
        this.assignment = is.read();
    }

    public IPConfigDIB(Inet4Address ip, Inet4Address subnetMask, Inet4Address gateway, int ipCapabilities, int ipAssignmentMethods) {
        super(16, 3);
        this.ip = ip != null ? ip.getAddress() : new byte[4];
        this.subnet = subnetMask != null ? subnetMask.getAddress() : new byte[4];
        byte[] byArray = this.gw = gateway != null ? gateway.getAddress() : new byte[4];
        if (ipCapabilities < 0 || ipCapabilities > 7) {
            throw new KNXIllegalArgumentException("IP capabilities out of range [0..b111]: " + ipCapabilities);
        }
        this.caps = ipCapabilities;
        if (ipAssignmentMethods < 0 || ipAssignmentMethods > 21) {
            throw new KNXIllegalArgumentException("IP assignment methods out of range [0..b1111]: " + ipAssignmentMethods);
        }
        this.assignment = ipAssignmentMethods;
    }

    public Inet4Address getIPAddress() {
        return IPConfigDIB.asInet4Address(this.ip);
    }

    public Inet4Address getSubnetMask() {
        return IPConfigDIB.asInet4Address(this.subnet);
    }

    public Inet4Address getDefaultGateway() {
        return IPConfigDIB.asInet4Address(this.gw);
    }

    public int getIPCapabilities() {
        return this.caps;
    }

    public int getIPAssignmentMethods() {
        return this.assignment;
    }

    public String toString() {
        try {
            return "IP " + InetAddress.getByAddress(this.ip) + ", subnet mask " + InetAddress.getByAddress(this.subnet) + ", default gateway " + InetAddress.getByAddress(this.gw) + ", IP capabilities " + this.caps + ", enabled IP assignment methods " + this.assignment;
        }
        catch (UnknownHostException unknownHostException) {
            return "IP config DIB";
        }
    }

    @Override
    public byte[] toByteArray() {
        int k;
        byte[] buf = super.toByteArray();
        int i = 2;
        for (k = 0; k < 4; ++k) {
            buf[i++] = this.ip[k];
        }
        for (k = 0; k < 4; ++k) {
            buf[i++] = this.subnet[k];
        }
        for (k = 0; k < 4; ++k) {
            buf[i++] = this.gw[k];
        }
        buf[i++] = (byte)this.caps;
        buf[i++] = (byte)this.assignment;
        return buf;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.ip);
        result = 31 * result + Arrays.hashCode(this.subnet);
        result = 31 * result + Arrays.hashCode(this.gw);
        result = 31 * result + Objects.hash(this.caps, this.assignment);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IPConfigDIB)) {
            return false;
        }
        IPConfigDIB other = (IPConfigDIB)obj;
        return this.caps == other.caps && this.assignment == other.assignment && Arrays.equals(this.ip, other.ip) && Arrays.equals(this.subnet, other.subnet) && Arrays.equals(this.gw, other.gw);
    }

    private static Inet4Address asInet4Address(byte[] addr) {
        try {
            return (Inet4Address)InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException e) {
            throw new KNXIllegalArgumentException("illegal length of IPv4 address", e);
        }
    }
}

