/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.util;

import java.util.Arrays;
import java.util.Objects;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.knxnetip.util.DIB;

public class ManufacturerDIB
extends DIB {
    private final int id;
    private final byte[] mfrData;

    public ManufacturerDIB(byte[] data, int offset) throws KNXFormatException {
        super(data, offset);
        if (this.type != 254) {
            throw new KNXFormatException("DIB is not of type manufacturer data", this.type);
        }
        if (this.size < 4) {
            throw new KNXFormatException("manufacturer DIB too short");
        }
        this.id = (data[offset + 2] & 0xFF) << 8 | data[offset + 3] & 0xFF;
        this.mfrData = new byte[this.size - 4];
        for (int i = 0; i < this.mfrData.length; ++i) {
            this.mfrData[i] = data[4 + offset + i];
        }
    }

    public ManufacturerDIB(int mfrID, byte[] mfrSpecificData) {
        super(4 + mfrSpecificData.length, 254);
        if (mfrID < 0 || mfrID > 65535) {
            throw new KNXIllegalArgumentException("manufacturer ID out of range [0..0xffff]");
        }
        this.id = mfrID;
        this.mfrData = (byte[])mfrSpecificData.clone();
    }

    public final int getID() {
        return this.id;
    }

    public final byte[] getData() {
        return (byte[])this.mfrData.clone();
    }

    @Override
    public byte[] toByteArray() {
        byte[] buf = super.toByteArray();
        buf[2] = (byte)(this.id >> 8);
        buf[3] = (byte)this.id;
        for (int i = 0; i < this.mfrData.length; ++i) {
            buf[4 + i] = this.mfrData[i];
        }
        return buf;
    }

    public String toString() {
        return "KNX manufacturer ID 0x" + Integer.toHexString(this.id) + ", data 0x" + DataUnitBuilder.toHex(this.mfrData, "");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hash(this.id);
        result = 31 * result + Arrays.hashCode(this.mfrData);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ManufacturerDIB)) {
            return false;
        }
        ManufacturerDIB other = (ManufacturerDIB)obj;
        return this.id == other.id && Arrays.equals(this.mfrData, other.mfrData);
    }
}

