/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.util;

import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.StringJoiner;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.knxnetip.util.DIB;

public class ServiceFamiliesDIB
extends DIB {
    @Deprecated
    public static final int CORE = 2;
    @Deprecated
    public static final int DEVICE_MANAGEMENT = 3;
    @Deprecated
    public static final int TUNNELING = 4;
    @Deprecated
    public static final int ROUTING = 5;
    @Deprecated
    public static final int REMOTE_LOGGING = 6;
    @Deprecated
    public static final int REMOTE_CONFIGURATION_DIAGNOSIS = 7;
    @Deprecated
    public static final int OBJECT_SERVER = 8;
    @Deprecated
    public static final int Security = 9;
    private final EnumMap<ServiceFamily, Integer> families = new EnumMap(ServiceFamily.class);

    public ServiceFamiliesDIB(byte[] data, int offset) throws KNXFormatException {
        super(data, offset);
        if (this.type != 2 && this.type != 6) {
            throw new KNXFormatException("not a supported service families DIB", this.type);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(data, offset + 2, this.size - 2);
        int length = this.size / 2 - 1;
        try {
            for (int i = 0; i < length; ++i) {
                int familyId = is.read();
                this.families.put(ServiceFamily.of(familyId), is.read());
            }
        }
        catch (KNXIllegalArgumentException e) {
            throw new KNXFormatException(e.getMessage());
        }
    }

    public static ServiceFamiliesDIB newSecureServiceFamilies(Map<ServiceFamily, Integer> families) {
        return new ServiceFamiliesDIB(true, families);
    }

    @Deprecated
    public ServiceFamiliesDIB(int[] familyIDs, int[] familyVersions) {
        this(false, ServiceFamiliesDIB.toEnumMap(familyIDs, familyVersions));
    }

    public ServiceFamiliesDIB(Map<ServiceFamily, Integer> families) {
        super(2 + 2 * families.size(), 2);
        for (Map.Entry<ServiceFamily, Integer> entry : families.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    private ServiceFamiliesDIB(boolean secure, Map<ServiceFamily, Integer> families) {
        super(2 + 2 * families.size(), secure ? 6 : 2);
        this.families.putAll(families);
    }

    public final Map<ServiceFamily, Integer> families() {
        return Collections.unmodifiableMap(this.families);
    }

    @Deprecated(forRemoval=true)
    public final int[] getFamilyIds() {
        return this.families.keySet().stream().mapToInt(ServiceFamily::id).toArray();
    }

    @Deprecated(forRemoval=true)
    public final int getVersion(int familyId) {
        return this.families.getOrDefault((Object)ServiceFamily.of(familyId), 0);
    }

    @Deprecated(forRemoval=true)
    public final String getFamilyName(int familyId) {
        return ServiceFamily.of(familyId).toString();
    }

    @Override
    public byte[] toByteArray() {
        byte[] buf = super.toByteArray();
        int k = 2;
        for (Map.Entry<ServiceFamily, Integer> entry : this.families.entrySet()) {
            buf[k++] = (byte)entry.getKey().id();
            buf[k++] = (byte)entry.getValue().intValue();
        }
        return buf;
    }

    public String toString() {
        if (this.type == 6 && this.families.isEmpty()) {
            return "KNX IP Secure n/a";
        }
        StringJoiner buf = new StringJoiner(", ");
        String prefix = this.type == 6 ? "Secure " : "";
        for (Map.Entry<ServiceFamily, Integer> entry : this.families.entrySet()) {
            buf.add(prefix + (Object)((Object)entry.getKey()) + " (v" + entry.getValue() + ")");
        }
        return buf.toString();
    }

    public int hashCode() {
        return this.families.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ServiceFamiliesDIB)) {
            return false;
        }
        ServiceFamiliesDIB other = (ServiceFamiliesDIB)obj;
        return this.families.equals((Object)other.families);
    }

    private void add(ServiceFamily familyId, int familyVersion) {
        if (familyVersion < 0 || familyVersion > 255) {
            throw new KNXIllegalArgumentException("version out of range [0..255]");
        }
        this.families.put(familyId, familyVersion);
    }

    private static EnumMap<ServiceFamily, Integer> toEnumMap(int[] familyIDs, int[] familyVersions) {
        EnumMap<ServiceFamily, Integer> map = new EnumMap<ServiceFamily, Integer>(ServiceFamily.class);
        for (int i = 0; i < familyIDs.length; ++i) {
            map.put(ServiceFamily.of(familyIDs[i]), familyVersions[i]);
        }
        return map;
    }

    public static enum ServiceFamily {
        Core,
        DeviceManagement,
        Tunneling,
        Routing,
        RemoteLogging,
        RemoteConfigurationDiagnosis,
        ObjectServer,
        Security;


        public int id() {
            return this.ordinal() + 2;
        }

        public String toString() {
            return this.name().replaceAll("(\\p{Lower})\\B([A-Z])", "$1 $2");
        }

        public static ServiceFamily of(int familyId) {
            if (familyId < 2 || familyId > 9) {
                throw new KNXIllegalArgumentException(familyId + " is not a supported service family");
            }
            return ServiceFamily.values()[familyId - 2];
        }
    }
}

