/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.util;

import java.nio.ByteBuffer;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.knxnetip.util.ServiceFamiliesDIB;

public final class Srp {
    private final int size;
    private final boolean mandatory;
    private final Type type;
    private final byte[] data;
    private static final int SrpHeaderSize = 2;

    public Srp(Type srpType, boolean isMandatory, byte ... data) {
        this.type = srpType;
        this.mandatory = isMandatory;
        switch (srpType) {
            case Invalid: 
            case SelectByProgrammingMode: {
                this.size = 2;
                this.data = new byte[0];
                break;
            }
            case SelectByMacAddress: {
                if (data.length != 6) {
                    throw new KNXIllegalArgumentException("MAC size does not match expected value");
                }
                this.size = 8;
                this.data = data;
                break;
            }
            case SelectByService: {
                if (data.length != 2) {
                    throw new KNXIllegalArgumentException("service info size does not match expected value");
                }
                this.size = 4;
                this.data = data;
                break;
            }
            case RequestDibs: {
                if (data.length < 1) {
                    throw new KNXIllegalArgumentException("requested DIBs size does not match expected value");
                }
                this.data = new byte[data.length % 2 == 0 ? data.length : data.length + 1];
                System.arraycopy(data, 0, this.data, 0, data.length);
                this.size = 2 + this.data.length;
                break;
            }
            default: {
                throw new KNXIllegalArgumentException("illegal SRP type + 0x" + Integer.toHexString(srpType.getValue()));
            }
        }
    }

    public Srp(byte[] data, int offset) throws KNXFormatException {
        if (data.length - offset < 2) {
            throw new KNXFormatException("buffer too short for SRP header");
        }
        this.size = data[offset] & 0xFF;
        if (this.size > data.length - offset) {
            throw new KNXFormatException("SRP size bigger than actual data length", this.size);
        }
        this.mandatory = (data[offset + 1] & 0x80) == 128;
        this.type = Type.from(data[offset + 1] & 0x7F);
        if (this.size - 2 > 0) {
            this.data = new byte[this.size - 2];
            System.arraycopy(data, offset + 2, this.data, 0, this.size - 2);
        } else {
            this.data = new byte[0];
        }
    }

    public static Srp withProgrammingMode() {
        return new Srp(Type.SelectByProgrammingMode, true, new byte[0]);
    }

    public static Srp withMacAddress(byte[] macAddress) {
        return new Srp(Type.SelectByMacAddress, true, macAddress);
    }

    @Deprecated
    public static Srp withService(int familyId, int familyVersion) {
        return new Srp(Type.SelectByService, true, (byte)familyId, (byte)familyVersion);
    }

    public static Srp withService(ServiceFamiliesDIB.ServiceFamily family, int familyVersion) {
        return new Srp(Type.SelectByService, true, (byte)family.id(), (byte)familyVersion);
    }

    public static Srp withDeviceDescription(int descriptionType, int ... additionalDescriptionTypes) {
        ByteBuffer buffer = ByteBuffer.allocate(additionalDescriptionTypes.length + 1);
        for (int dt : additionalDescriptionTypes) {
            buffer.put((byte)dt);
        }
        buffer.put((byte)descriptionType);
        return new Srp(Type.RequestDibs, true, buffer.array());
    }

    public int structLength() {
        return this.size;
    }

    public Type type() {
        return this.type;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public byte[] data() {
        return (byte[])this.data.clone();
    }

    public byte[] toByteArray() {
        byte[] buf = new byte[this.size];
        buf[0] = (byte)this.size;
        buf[1] = (byte)(this.mandatory ? 128 : 0);
        buf[1] = (byte)(buf[1] | (byte)(this.type.getValue() & 7));
        if (this.data.length > 0) {
            System.arraycopy(this.data, 0, buf, 2, this.data.length);
        }
        return buf;
    }

    public static enum Type {
        Invalid(0),
        SelectByProgrammingMode(1),
        SelectByMacAddress(2),
        SelectByService(3),
        RequestDibs(4);

        private final int type;

        private int getValue() {
            return this.type;
        }

        private static Type from(int code) {
            for (Type t : Type.values()) {
                if (code != t.type) continue;
                return t;
            }
            throw new KNXIllegalArgumentException("unspecified SRP type + 0x" + Integer.toHexString(code));
        }

        private Type(int type) {
            this.type = type;
        }
    }
}

