/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.util;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.knxnetip.util.DIB;

public class TunnelingDib
extends DIB {
    private final short maxApduLength;
    private final IndividualAddress[] addresses;
    private final int[] status;

    public TunnelingDib(List<IndividualAddress> addresses, int[] status) {
        this(254, addresses, status);
    }

    public TunnelingDib(short maxApduLength, List<IndividualAddress> addresses, int[] status) {
        super(4 + 4 * addresses.size(), 7);
        if (addresses.isEmpty()) {
            throw new KNXIllegalArgumentException("at least one address must be given");
        }
        if (addresses.size() != status.length) {
            throw new KNXIllegalArgumentException("list sizes of addresses and status must be equal");
        }
        this.maxApduLength = maxApduLength;
        this.addresses = addresses.toArray(new IndividualAddress[0]);
        this.status = (int[])status.clone();
    }

    public TunnelingDib(byte[] data, int offset, int length) throws KNXFormatException {
        super(data, offset);
        if (this.type != 7) {
            throw new KNXFormatException("not a tunneling DIB", this.type);
        }
        if (length < 8) {
            throw new KNXFormatException("tunneling DIB too short", length);
        }
        ByteBuffer buf = ByteBuffer.wrap(data, offset + 2, length - 2);
        this.maxApduLength = buf.getShort();
        int entries = buf.remaining() / 4;
        this.addresses = new IndividualAddress[entries];
        this.status = new int[entries];
        for (int i = 0; i < entries; ++i) {
            this.addresses[i] = new IndividualAddress(buf.getShort() & 0xFFFF);
            buf.get();
            this.status[i] = buf.get() & 7;
        }
    }

    private static String formatStatus(int status) {
        ArrayList<String> l = new ArrayList<String>();
        l.add((status & 1) == 1 ? "free" : "occupied");
        if ((status & 2) == 2) {
            l.add("authorized");
        }
        if ((status & 4) == 4) {
            l.add("usable");
        }
        return l.stream().collect(Collectors.joining(", "));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("maximum APDU length: " + this.maxApduLength + ", addresses ");
        for (int i = 0; i < this.addresses.length; ++i) {
            sb.append(this.addresses[i] + " (" + TunnelingDib.formatStatus(this.status[i]) + ") ");
        }
        return sb.toString();
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer buf = ByteBuffer.wrap(super.toByteArray()).position(2);
        buf.putShort(this.maxApduLength);
        for (int k = 0; k < this.addresses.length; ++k) {
            buf.put(this.addresses[k].toByteArray());
            buf.put((byte)-1);
            buf.put((byte)(this.status[k] | 0xF8));
        }
        return buf.array();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hash(this.maxApduLength);
        result = 31 * result + Arrays.hashCode(this.addresses);
        result = 31 * result + Arrays.hashCode(this.status);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TunnelingDib)) {
            return false;
        }
        TunnelingDib other = (TunnelingDib)obj;
        return this.maxApduLength == other.maxApduLength && Arrays.equals(this.addresses, other.addresses) && Arrays.equals(this.status, other.status);
    }
}

