/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.link;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.baos.BaosService;
import tuwien.auto.calimero.cemi.AdditionalInfo;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.cemi.CEMIDevMgmt;
import tuwien.auto.calimero.cemi.CEMIFactory;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.cemi.CEMILDataEx;
import tuwien.auto.calimero.cemi.RFMediumInfo;
import tuwien.auto.calimero.link.BcuSwitcher;
import tuwien.auto.calimero.link.EventNotifier;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.link.LinkEvent;
import tuwien.auto.calimero.link.NetworkLinkListener;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;
import tuwien.auto.calimero.link.medium.PLSettings;
import tuwien.auto.calimero.link.medium.RFSettings;
import tuwien.auto.calimero.link.medium.TPSettings;
import tuwien.auto.calimero.log.LogService;

public abstract class AbstractLink<T extends AutoCloseable>
implements KNXNetworkLink {
    protected final Logger logger;
    protected final EventNotifier<NetworkLinkListener> notifier;
    protected boolean cEMI = true;
    protected boolean sendCEmiAsByteArray;
    private final String name;
    private volatile boolean closed;
    private volatile int hopCount = 6;
    private KNXMediumSettings medium;
    final T conn;
    private CEMIDevMgmt devMgmt;
    final Map<Class<?>, Set<MethodHandle>> customEvents = new ConcurrentHashMap();
    static final int cemiServerObject = 8;
    private static final MethodHandles.Lookup lookup = MethodHandles.lookup();

    protected AbstractLink(T connection, String name, KNXMediumSettings settings) {
        this.conn = connection;
        this.name = name;
        this.logger = LogService.getLogger("calimero.link." + this.getName());
        this.notifier = new LinkNotifier();
        this.setKNXMedium(settings);
        this.notifier.start();
    }

    protected AbstractLink(String name, KNXMediumSettings settings) {
        this.conn = null;
        this.name = name;
        this.logger = LogService.getLogger("calimero.link." + this.getName());
        this.notifier = new LinkNotifier();
        this.setKNXMedium(settings);
    }

    @Override
    public final synchronized void setKNXMedium(KNXMediumSettings settings) {
        if (settings == null) {
            throw new KNXIllegalArgumentException("medium settings are mandatory");
        }
        if (this.medium != null && !settings.getClass().isAssignableFrom(this.medium.getClass()) && !this.medium.getClass().isAssignableFrom(settings.getClass())) {
            throw new KNXIllegalArgumentException("medium differs");
        }
        this.medium = settings;
    }

    @Override
    public final synchronized KNXMediumSettings getKNXMedium() {
        return this.medium;
    }

    @Override
    public void addLinkListener(NetworkLinkListener l) {
        this.notifier.addListener(l);
        this.registerCustomEvents(l);
    }

    @Override
    public void removeLinkListener(NetworkLinkListener l) {
        this.notifier.removeListener(l);
    }

    @Override
    public final void setHopCount(int count) {
        if (count < 0 || count > 7) {
            throw new KNXIllegalArgumentException("hop count out of range [0..7]");
        }
        this.hopCount = count;
        this.logger.debug("hop count set to {}", (Object)count);
    }

    @Override
    public final int getHopCount() {
        return this.hopCount;
    }

    @Override
    public void sendRequest(KNXAddress dst, Priority p, byte[] nsdu) throws KNXTimeoutException, KNXLinkClosedException {
        this.send(17, dst, p, nsdu, false);
    }

    @Override
    public void sendRequestWait(KNXAddress dst, Priority p, byte[] nsdu) throws KNXTimeoutException, KNXLinkClosedException {
        this.send(17, dst, p, nsdu, true);
    }

    @Override
    public void send(CEMILData msg, boolean waitForCon) throws KNXTimeoutException, KNXLinkClosedException {
        if (this.closed) {
            throw new KNXLinkClosedException("link closed");
        }
        if (this.cEMI && !this.sendCEmiAsByteArray) {
            CEMILData adjusted = this.adjustMsgType(msg);
            this.addMediumInfo(adjusted);
            this.onSend(adjusted, waitForCon);
            return;
        }
        this.onSend(msg.getDestination(), this.createEmi(msg, waitForCon), waitForCon);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final boolean isOpen() {
        return !this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        AbstractLink abstractLink = this;
        synchronized (abstractLink) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.onClose();
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.notifier.quit();
    }

    public String toString() {
        return "link" + (this.closed ? " (closed) " : " ") + this.getName() + " " + this.medium + ", hopcount " + this.hopCount;
    }

    protected void send(int mc, KNXAddress dst, Priority p, byte[] nsdu, boolean waitForCon) throws KNXTimeoutException, KNXLinkClosedException {
        if (this.closed) {
            throw new KNXLinkClosedException("link closed");
        }
        if (this.cEMI && !this.sendCEmiAsByteArray) {
            CEMILData f = this.cEMI(mc, dst, p, nsdu);
            this.onSend(f, waitForCon);
            return;
        }
        this.onSend(dst, this.createEmi(mc, dst, p, nsdu), waitForCon);
    }

    protected abstract void onSend(KNXAddress var1, byte[] var2, boolean var3) throws KNXTimeoutException, KNXLinkClosedException;

    protected abstract void onSend(CEMILData var1, boolean var2) throws KNXTimeoutException, KNXLinkClosedException;

    protected CEMI onReceive(FrameEvent e) throws KNXFormatException {
        CEMI cemi = e.getFrame();
        if (cemi != null) {
            return cemi;
        }
        byte[] frameBytes = e.getFrameBytes();
        return this.cEMI ? CEMIFactory.create(frameBytes, 0, frameBytes.length) : CEMIFactory.fromEmi(frameBytes);
    }

    protected void onClose() {
    }

    void onSend(CEMIDevMgmt frame) throws KNXException, InterruptedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onDevMgmt(CEMIDevMgmt f) {
        int mc = f.getMessageCode();
        if (mc == 245 && f.isNegativeResponse()) {
            this.logger.error("L-DM negative response, " + f.getErrorMessage());
        }
        AbstractLink abstractLink = this;
        synchronized (abstractLink) {
            this.devMgmt = f;
            this.notifyAll();
        }
    }

    void mediumType() throws KNXException, InterruptedException {
        int pidMediumType = 51;
        int supplied = this.getKNXMedium().getMedium();
        int types = this.read(8, 51).map(AbstractLink::unsigned).orElse(supplied);
        if ((types & supplied) != supplied) {
            this.logger.warn("wrong communication medium setting: using {} to access {} medium", (Object)KNXMediumSettings.getMediumString(supplied), (Object)AbstractLink.mediumTypes(types));
        }
    }

    private static String mediumTypes(int types) {
        StringJoiner joiner = new StringJoiner(", ").setEmptyValue("unknown");
        if ((types & 2) > 0) {
            joiner.add("TP1");
        }
        if ((types & 4) > 0) {
            joiner.add("PL110");
        }
        if ((types & 0x10) > 0) {
            joiner.add("RF");
        }
        if ((types & 0x20) > 0) {
            joiner.add("IP");
        }
        return joiner.toString();
    }

    void setMaxApduLength() throws KNXException, InterruptedException {
        KNXMediumSettings settings = this.getKNXMedium();
        this.maxApduLength().ifPresent(settings::setMaxApduLength);
        if (settings.maxApduLength() != 15) {
            this.logger.debug("using max. APDU length of {}", (Object)settings.maxApduLength());
        }
    }

    Optional<Integer> maxApduLength() throws KNXException, InterruptedException {
        int pidMaxApduLength = 56;
        return this.read(0, 56).map(AbstractLink::unsigned);
    }

    void baosMode(boolean enable) throws KNXException, InterruptedException {
        IndividualAddress dst = KNXMediumSettings.BackboneRouter;
        if (this.cEMI) {
            int pidBaosSupport = 201;
            CEMIDevMgmt check = new CEMIDevMgmt(252, 8, 1, 201, 1, 1);
            this.onSend(check);
            boolean supported = this.responseFor(251, 201).isPresent();
            if (!supported) {
                throw new KNXException("device does not support BAOS mode");
            }
            CEMIDevMgmt frame = BcuSwitcher.cemiCommModeRequest(enable ? 240 : 0);
            this.onSend(frame);
            this.responseFor(245, 52);
            CEMIDevMgmt recheck = new CEMIDevMgmt(252, 8, 1, 52, 1, 1);
            this.onSend(recheck);
            this.responseFor(251, 52).ifPresent(mode -> this.logger.debug("comm mode {}", (Object)((mode[0] & 0xFF) == 240 ? "BAOS" : DataUnitBuilder.toHex(mode, ""))));
        } else {
            int PeiIdentifyReq = 167;
            this.onSend(dst, new byte[]{-89}, true);
        }
    }

    Optional<byte[]> read(int objectType, int pid) throws KNXException, InterruptedException {
        if (!this.cEMI) {
            return Optional.empty();
        }
        boolean objectInstance = true;
        this.onSend(new CEMIDevMgmt(252, objectType, 1, pid, 1, 1));
        return this.responseFor(251, pid);
    }

    static int unsigned(byte ... data) {
        int value = 0;
        for (byte b : data) {
            value = value << 8 | b & 0xFF;
        }
        return value;
    }

    synchronized Optional<byte[]> responseFor(int messageCode, int pid) throws InterruptedException {
        long remaining = 1000L;
        long end = System.nanoTime() / 1000000L + remaining;
        while (remaining > 0L) {
            if (this.devMgmt != null) {
                CEMIDevMgmt f = this.devMgmt;
                this.devMgmt = null;
                if (f.getMessageCode() == messageCode && f.getPID() == pid) {
                    byte[] data = f.getPayload();
                    if (f.isNegativeResponse() || data.length == 0) break;
                    return Optional.of(data);
                }
            }
            this.wait(remaining);
            remaining = end - System.nanoTime() / 1000000L;
        }
        return Optional.empty();
    }

    private CEMILData adjustMsgType(CEMILData msg) {
        boolean srcOk;
        boolean bl = srcOk = msg.getSource().getRawAddress() != 0;
        if ((srcOk || this.medium.getDeviceAddress().getRawAddress() == 0) && (this.medium instanceof TPSettings || msg instanceof CEMILDataEx)) {
            return msg;
        }
        return CEMIFactory.create(srcOk ? null : this.medium.getDeviceAddress(), null, msg, true);
    }

    private void addMediumInfo(CEMILData msg) {
        String s = "";
        if (this.medium instanceof PLSettings) {
            CEMILDataEx f = (CEMILDataEx)msg;
            if (f.getAdditionalInfo(1) != null) {
                return;
            }
            f.additionalInfo().add(AdditionalInfo.of(1, ((PLSettings)this.medium).getDomainAddress()));
        } else if (this.medium.getMedium() == 16) {
            CEMILDataEx f = (CEMILDataEx)msg;
            if (f.getAdditionalInfo(2) != null) {
                return;
            }
            RFSettings rf = (RFSettings)this.medium;
            byte[] sn = f.isDomainBroadcast() ? rf.getDomainAddress() : rf.serialNumber().array();
            f.additionalInfo().add(new RFMediumInfo(true, rf.isUnidirectional(), sn, 255, f.isSystemBroadcast()));
            s = f.isDomainBroadcast() ? " (using domain address)" : " (using device SN)";
        } else {
            return;
        }
        this.logger.trace("add cEMI additional info for {}{}", (Object)this.medium.getMediumString(), (Object)s);
    }

    private byte[] createEmi(int mc, KNXAddress dst, Priority p, byte[] nsdu) {
        if (this.cEMI) {
            return this.cEMI(mc, dst, p, nsdu).toByteArray();
        }
        boolean repeat = true;
        boolean ackRequest = false;
        boolean posCon = true;
        return CEMIFactory.toEmi(mc, dst, p, true, false, true, this.hopCount, nsdu);
    }

    private byte[] createEmi(CEMILData f, boolean waitForCon) {
        if (this.cEMI) {
            CEMILData adjusted = this.adjustMsgType(f);
            this.addMediumInfo(adjusted);
            this.logger.debug("send {}{}", (Object)(waitForCon ? "(wait for confirmation) " : ""), (Object)adjusted);
            return adjusted.toByteArray();
        }
        return CEMIFactory.toEmi(f);
    }

    private CEMILData cEMI(int mc, KNXAddress dst, Priority p, byte[] nsdu) {
        boolean tp;
        IndividualAddress src = this.medium.getDeviceAddress();
        KNXAddress d = dst == null ? GroupAddress.Broadcast : dst;
        boolean repeat = mc != 41;
        boolean bl = tp = this.medium.getMedium() == 2;
        if (nsdu.length <= 16 && tp) {
            return new CEMILData(mc, src, d, nsdu, p, repeat, this.hopCount);
        }
        CEMILDataEx f = new CEMILDataEx(mc, src, d, nsdu, p, repeat, this.domainBcast(dst), false, this.hopCount);
        this.addMediumInfo(f);
        return f;
    }

    private boolean domainBcast(KNXAddress dst) {
        if (this.medium.getMedium() == 2) {
            return true;
        }
        if (this.medium.getMedium() == 4) {
            return dst != null;
        }
        if (this.medium.getMedium() == 16) {
            RFSettings rfSettings = (RFSettings)this.medium;
            if (rfSettings.isUnidirectional()) {
                return false;
            }
            return dst instanceof IndividualAddress;
        }
        return true;
    }

    private void registerCustomEvents(NetworkLinkListener listener) {
        for (Class<?> clazz : listener.getClass().getInterfaces()) {
            for (Method method : clazz.getDeclaredMethods()) {
                this.inspectMethodForLinkEvent(method, listener);
            }
        }
        for (GenericDeclaration genericDeclaration : listener.getClass().getDeclaredMethods()) {
            this.inspectMethodForLinkEvent((Method)genericDeclaration, listener);
        }
    }

    private void inspectMethodForLinkEvent(Method method, NetworkLinkListener listener) {
        if (method.getAnnotation(LinkEvent.class) == null) {
            return;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length != 1) {
            this.logger.warn("cannot register {}: parameter count not 1", (Object)method);
            return;
        }
        Class<?> paramType = paramTypes[0];
        if (!this.customEvents.containsKey(paramType)) {
            this.logger.warn("unsupported event type {}", (Object)method);
            return;
        }
        try {
            MethodHandles.Lookup privateLookup = MethodHandles.privateLookupIn(listener.getClass(), lookup);
            MethodHandle boundMethod = privateLookup.unreflect(method).bindTo(listener);
            this.customEvents.get(paramType).add(boundMethod);
            this.logger.debug("registered {} for {}s", (Object)method, (Object)paramType.getSimpleName());
        }
        catch (Exception e) {
            this.logger.warn("failed to register {}", (Object)method, (Object)e);
        }
    }

    void dispatchCustomEvent(Object event) {
        this.customEvents.get(event.getClass()).forEach(mh -> {
            try {
                mh.invoke(event);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
    }

    private final class LinkNotifier
    extends EventNotifier<NetworkLinkListener> {
        private static final int PeiIdentifyCon = 168;
        private static final int BaosMainService = 240;

        LinkNotifier() {
            super(AbstractLink.this, AbstractLink.this.logger);
        }

        @Override
        public void frameReceived(FrameEvent e) {
            try {
                CEMI cemi;
                byte[] frame = e.getFrameBytes();
                if (frame != null) {
                    if (BcuSwitcher.isEmi1GetValue(frame[0] & 0xFF)) {
                        return;
                    }
                    if ((frame[0] & 0xFF) == 168) {
                        this.logger.info("PEI identify {}", (Object)DataUnitBuilder.toHex(frame, " "));
                        int manufacturer = AbstractLink.unsigned(frame[3], frame[4]);
                        if (manufacturer == 197) {
                            this.logger.info("link connected to weinzierl device");
                        }
                    }
                    if ((frame[0] & 0xFF) == 240) {
                        BaosService baosEvent = BaosService.from(ByteBuffer.wrap(frame));
                        AbstractLink.this.dispatchCustomEvent(baosEvent);
                        return;
                    }
                }
                if ((cemi = AbstractLink.this.onReceive(e)) instanceof CEMIDevMgmt) {
                    AbstractLink.this.onDevMgmt((CEMIDevMgmt)cemi);
                }
                if (!(cemi instanceof CEMILData)) {
                    return;
                }
                CEMILData ldata = (CEMILData)cemi;
                int mc = cemi.getMessageCode();
                if (mc == 41) {
                    this.addEvent(l -> l.indication(new FrameEvent(this.source, ldata)));
                    this.logger.debug("indication {}", (Object)ldata);
                } else if (mc == 46) {
                    this.addEvent(l -> l.confirmation(new FrameEvent(this.source, ldata)));
                    if (ldata.isPositiveConfirmation()) {
                        this.logger.debug("confirmation of {}", (Object)ldata.getDestination());
                    } else {
                        this.logger.warn("negative confirmation of {}: {}", (Object)ldata.getDestination(), (Object)DataUnitBuilder.toHex(ldata.toByteArray(), " "));
                    }
                } else {
                    this.logger.warn("unspecified frame event - ignored, msg code = 0x" + Integer.toHexString(mc));
                }
            }
            catch (RuntimeException | KNXFormatException ex) {
                this.logger.warn("received unspecified frame {}", (Object)DataUnitBuilder.toHex(e.getFrameBytes(), " "), (Object)ex);
            }
        }

        @Override
        public void connectionClosed(CloseEvent e) {
            AbstractLink.this.closed = true;
            super.connectionClosed(e);
            this.logger.debug("link closed");
        }
    }
}

