/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.link;

import java.util.Arrays;
import java.util.EnumSet;
import org.slf4j.Logger;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXListener;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.cemi.CEMIDevMgmt;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.serial.FT12Connection;
import tuwien.auto.calimero.serial.KNXPortClosedException;
import tuwien.auto.calimero.serial.usb.HidReport;
import tuwien.auto.calimero.serial.usb.TransferProtocolHeader;
import tuwien.auto.calimero.serial.usb.UsbConnection;

final class BcuSwitcher {
    static final int AddrSystemState = 96;
    static final int AddrBaseConfig = 257;
    static final int AddrDomainAddress = 258;
    static final int AddrExpectedPeiType = 265;
    static final int AddrStartAddressTable = 278;
    static final int AddrIndividualAddress = 279;
    private static final int getValue_req = 76;
    private static final int getValue_con = 75;
    private static final int setValue_req = 70;
    private static final int frameOffsetData = 4;
    private static final int responseTimeout = 1000;
    private byte[] response;
    private final UsbConnection c;
    private final Logger logger;
    private static final long txInterframeSpacing = 30L;
    private long tsLastTx;
    private static final int peiSwitch_req = 169;
    private static final int cemiServerObjectType = 8;
    private static final int objectInstance = 1;
    static final int pidCommMode = 52;
    static final int DataLinkLayer = 0;
    static final int Busmonitor = 1;
    static final int BaosMode = 240;
    static final int NoLayer = 255;
    private final FT12Connection conn;

    static boolean isEmi1GetValue(int messageCode) {
        return messageCode == 75;
    }

    BcuSwitcher(UsbConnection c, Logger l) {
        this.c = c;
        this.logger = l;
        this.conn = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enter(BcuMode mode) throws KNXFormatException, KNXPortClosedException, KNXTimeoutException, InterruptedException {
        KNXListener l = new KNXListener(){

            @Override
            public void frameReceived(FrameEvent e) {
                BcuSwitcher.this.setResponse(e.getFrameBytes());
            }

            @Override
            public void connectionClosed(CloseEvent e) {
            }
        };
        this.c.addConnectionListener(l);
        try {
            byte[] data = this.read(BcuSwitcher.createGetValue(265, 1));
            this.logger.info("PEI type {}", (Object)(data[0] & 0xFF));
            data = this.read(BcuSwitcher.createGetValue(278, 1));
            this.logger.debug("Address Table location {}", (Object)DataUnitBuilder.toHex(data, ""));
            data = this.read(BcuSwitcher.createGetValue(96, 1));
            this.logger.debug("Current operation mode {}", (Object)OperationMode.of(data[0] & 0xFF));
            this.writeVerify(265, new byte[]{1});
            this.setExtBusmon(mode == BcuMode.ExtBusmonitor);
            OperationMode set = mode == BcuMode.LinkLayer ? OperationMode.LinkLayer : OperationMode.Busmonitor;
            this.writeVerify(96, new byte[]{(byte)set.mode});
            this.writeVerify(278, new byte[]{0});
            data = this.read(BcuSwitcher.createGetValue(279, 2));
            this.logger.info("KNX individual address " + new IndividualAddress(data));
        }
        finally {
            this.c.removeConnectionListener(l);
        }
    }

    void reset() throws KNXPortClosedException, KNXTimeoutException, InterruptedException {
        this.write(BcuSwitcher.createSetValue(96, new byte[]{(byte)OperationMode.Reset.mode}));
    }

    static String print(byte[] frame) {
        StringBuilder sb = new StringBuilder();
        switch (frame[0] & 0xFF) {
            case 76: {
                sb.append("PC_Get_Value.req");
                break;
            }
            case 75: {
                sb.append("PC_Get_Value.con");
                break;
            }
            case 70: {
                sb.append("PC_Set_Value.req");
                break;
            }
            default: {
                sb.append("unknown msg code");
            }
        }
        sb.append(", length ").append(frame[1] & 0xFF);
        int address = (frame[2] & 0xFF) << 8 | frame[3] & 0xFF;
        sb.append(", address 0x").append(Integer.toHexString(address));
        sb.append(", data = ");
        for (int i = 4; i < frame.length; ++i) {
            sb.append(String.format("%02x", frame[i] & 0xFF));
        }
        return sb.toString();
    }

    private static byte[] createSetValue(int address, byte[] data) {
        if (data.length > 15) {
            throw new KNXIllegalArgumentException("data length exceeds maximum of 15 bytes");
        }
        byte[] frame = new byte[4 + data.length];
        frame[0] = 70;
        frame[1] = (byte)data.length;
        frame[2] = (byte)(address >> 8);
        frame[3] = (byte)address;
        for (int i = 0; i < data.length; ++i) {
            frame[i + 4] = data[i];
        }
        return frame;
    }

    private static byte[] createGetValue(int address, int length) {
        byte[] frame = new byte[]{76, (byte)length, (byte)(address >> 8), (byte)address};
        return frame;
    }

    private static byte[] dataOfGetValueCon(byte[] frame) throws KNXFormatException {
        if (frame.length < 4) {
            throw new KNXFormatException("frame too short for Get-Value.con", frame.length);
        }
        int mc = frame[0] & 0xFF;
        if (mc != 75) {
            throw new KNXFormatException("no Get-Value.con message", mc);
        }
        int length = frame[1] & 0xFF;
        if (length + 4 != frame.length) {
            throw new KNXFormatException("invalid length for frame size " + frame.length, length);
        }
        byte[] data = new byte[length];
        for (int i = 0; i < length; ++i) {
            data[i] = frame[4 + i];
        }
        return data;
    }

    private void setExtBusmon(boolean ext) throws KNXPortClosedException, KNXTimeoutException, KNXFormatException, InterruptedException {
        byte[] data = this.read(BcuSwitcher.createGetValue(257, 1));
        this.logger.debug("Base configuration flags {}", (Object)Integer.toBinaryString(data[0] & 0xFF));
        int config = data[0] & 0xFF;
        config = ext ? (config &= 0xFFFFFFF7) : (config |= 8);
        this.writeVerify(257, new byte[]{(byte)config});
    }

    private byte[] read(byte[] frame) throws KNXPortClosedException, KNXTimeoutException, KNXFormatException, InterruptedException {
        this.write(frame);
        return BcuSwitcher.dataOfGetValueCon(this.waitForResponse());
    }

    private void write(byte[] frame) throws KNXPortClosedException, KNXTimeoutException, InterruptedException {
        long now = System.currentTimeMillis();
        long wait = 30L - now + this.tsLastTx;
        if (wait > 0L) {
            this.logger.trace("enforce transmission interframe spacing, wait {} ms", (Object)wait);
            Thread.sleep(wait);
        }
        this.tsLastTx = now;
        this.c.send(HidReport.create(TransferProtocolHeader.KnxTunnelEmi.Emi1, frame).get(0), true);
    }

    private boolean writeVerify(int address, byte[] data) throws KNXPortClosedException, KNXTimeoutException, KNXFormatException, InterruptedException {
        this.write(BcuSwitcher.createSetValue(address, data));
        byte[] read = this.read(BcuSwitcher.createGetValue(address, data.length));
        boolean equal = Arrays.equals(data, read);
        if (!equal) {
            this.logger.error("verify write failed for address " + Integer.toHexString(address) + ": " + DataUnitBuilder.toHex(data, "") + " vs " + DataUnitBuilder.toHex(read, ""));
        }
        return equal;
    }

    private synchronized byte[] waitForResponse() throws KNXTimeoutException, InterruptedException {
        long remaining = 1000L;
        long end = System.currentTimeMillis() + remaining;
        while (remaining > 0L) {
            if (this.response != null) {
                byte[] r = this.response;
                this.response = null;
                return r;
            }
            this.wait(remaining);
            remaining = end - System.currentTimeMillis();
        }
        throw new KNXTimeoutException("expected service confirmation msg code 0x" + Integer.toHexString(75));
    }

    private synchronized void setResponse(byte[] frame) {
        int msgCode = frame[0] & 0xFF;
        if (msgCode == 75) {
            this.response = frame;
            this.notify();
        }
    }

    static CEMIDevMgmt cemiCommModeRequest(int commMode) {
        return new CEMIDevMgmt(246, 8, 1, 52, 1, 1, new byte[]{(byte)commMode});
    }

    static byte[] commModeRequest(int commMode) {
        return BcuSwitcher.cemiCommModeRequest(commMode).toByteArray();
    }

    BcuSwitcher(FT12Connection conn) {
        this.conn = conn;
        this.c = null;
        this.logger = null;
    }

    void normalMode(boolean cEMI) throws KNXTimeoutException, KNXPortClosedException, KNXLinkClosedException {
        byte[] switchNormal = new byte[]{-87, 30, 18, 52, 86, 120, -102};
        this.switchLayer(cEMI, 255, switchNormal);
    }

    void linkLayerMode(boolean cEMI) throws KNXException {
        byte[] switchLinkLayer = new byte[]{-87, 0, 24, 52, 86, 120, 10};
        this.switchLayer(cEMI, 0, switchLinkLayer);
    }

    void baosMode(boolean cEMI) throws KNXException {
        byte[] normalMode = new byte[]{-87, 0, 18, 52, 86, 120, -102};
        this.switchLayer(cEMI, 240, normalMode);
    }

    void enterBusmonitor(boolean cEMI) throws KNXTimeoutException, KNXPortClosedException, KNXLinkClosedException {
        byte[] switchBusmon = new byte[]{-87, -112, 24, 52, 86, 120, 10};
        this.switchLayer(cEMI, 1, switchBusmon);
    }

    void leaveBusmonitor(boolean cEMI) throws KNXTimeoutException, KNXPortClosedException, KNXLinkClosedException {
        this.normalMode(cEMI);
    }

    private void switchLayer(boolean cEMI, int cemiCommMode, byte[] peiSwitch) throws KNXTimeoutException, KNXPortClosedException, KNXLinkClosedException {
        try {
            this.conn.send(cEMI ? BcuSwitcher.commModeRequest(cemiCommMode) : peiSwitch, true);
        }
        catch (InterruptedException e) {
            this.conn.close();
            Thread.currentThread().interrupt();
            throw new KNXLinkClosedException(e.getMessage() != null ? e.getMessage() : "thread interrupted");
        }
        catch (KNXTimeoutException e) {
            this.conn.close();
            throw e;
        }
    }

    static enum OperationMode {
        Busmonitor(144),
        LinkLayer(18),
        TransportLayer(150),
        ApplicationLayer(30),
        Reset(192);

        final int mode;

        private OperationMode(int mode) {
            this.mode = mode;
        }

        static OperationMode of(int mode) {
            for (OperationMode v : EnumSet.allOf(OperationMode.class)) {
                if (v.mode != mode) continue;
                return v;
            }
            throw new KNXIllegalArgumentException("invalid operation mode 0x" + Integer.toHexString(mode));
        }
    }

    static enum BcuMode {
        LinkLayer,
        Busmonitor,
        ExtBusmonitor;

    }
}

