/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.link;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXRemoteException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.link.KNXNetworkMonitor;
import tuwien.auto.calimero.link.LinkListener;
import tuwien.auto.calimero.link.NetworkLinkListener;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;

public final class Connector {
    private boolean onSend = true;
    private long reconnectDelay = 2000L;
    private boolean initialError;
    private boolean serverError = true;
    private boolean internalError = true;
    public static final long NoMaxAttempts = Long.MAX_VALUE;
    private long maxAttempts = Long.MAX_VALUE;
    private Consumer<Boolean> connectionStatusChanged;

    public Connector() {
        this.connectionStatusChanged = __ -> {};
    }

    private Connector(Connector rhs) {
        this.connectionStatusChanged = __ -> {};
        this.onSend = rhs.onSend;
        this.reconnectDelay = rhs.reconnectDelay;
        this.initialError = rhs.initialError;
        this.serverError = rhs.serverError;
        this.internalError = rhs.internalError;
        this.maxAttempts = rhs.maxAttempts;
        this.connectionStatusChanged = rhs.connectionStatusChanged;
    }

    public Connector maxConnectAttempts(long maxAttempts) {
        if (maxAttempts < 1L) {
            throw new KNXIllegalArgumentException("max. connect attempts " + maxAttempts + " < 1");
        }
        this.maxAttempts = maxAttempts;
        return this;
    }

    public Connector connectOnSend(boolean connect) {
        this.onSend = connect;
        return this;
    }

    public Connector reconnectDelay(Duration delay) {
        this.reconnectDelay = delay.toMillis();
        return this;
    }

    public Connector reconnectOn(boolean errorOnCreation, boolean serverDisconnect, boolean internalDisconnect) {
        this.initialError = errorOnCreation;
        this.serverError = serverDisconnect;
        this.internalError = internalDisconnect;
        return this;
    }

    public Connector connectionStatusNotifier(Consumer<Boolean> notifiable) {
        this.connectionStatusChanged = notifiable;
        return this;
    }

    public KNXNetworkLink newLink(TSupplier<? extends KNXNetworkLink> creator) throws KNXException, InterruptedException {
        return new Link<KNXNetworkLink>(creator, this);
    }

    public KNXNetworkMonitor newMonitor(TSupplier<? extends KNXNetworkMonitor> creator) throws KNXException, InterruptedException {
        return new Link<KNXNetworkMonitor>(creator, this);
    }

    public static final class Link<T extends AutoCloseable>
    implements KNXNetworkLink,
    KNXNetworkMonitor,
    NetworkLinkListener {
        private volatile T impl;
        private final List<LinkListener> listeners = new ArrayList<LinkListener>();
        private volatile KNXMediumSettings settings;
        private volatile int hopCount;
        private volatile boolean decodeRawFrames;
        private final TSupplier<? extends T> creator;
        private static ScheduledThreadPoolExecutor reconnect = new ScheduledThreadPoolExecutor(4, runnable -> {
            Thread t = new Thread(runnable);
            t.setName("Calimero Connector " + t.getId());
            t.setDaemon(true);
            return t;
        });
        private final Connector connector;
        private volatile boolean closed;
        private volatile Future<?> f = CompletableFuture.completedFuture(Void.TYPE);
        private final AtomicBoolean connecting = new AtomicBoolean();
        private final Object lock = new Object();

        private Link(TSupplier<? extends T> creator, Connector options) throws KNXException, InterruptedException {
            this.creator = creator;
            this.connector = new Connector(options);
            try {
                this.connect();
            }
            catch (KNXException e) {
                if (!this.connector.initialError) {
                    throw e;
                }
                this.logger().error("initial connection attempt", (Throwable)e);
                this.scheduleConnect(this.connector.maxAttempts - 1L);
            }
        }

        public AutoCloseable target() {
            return this.impl;
        }

        @Override
        public void setKNXMedium(KNXMediumSettings settings) {
            T t = this.impl;
            if (t instanceof KNXNetworkLink) {
                ((KNXNetworkLink)t).setKNXMedium(settings);
            } else if (t instanceof KNXNetworkMonitor) {
                ((KNXNetworkMonitor)t).setKNXMedium(settings);
            }
            this.settings = settings;
        }

        @Override
        public KNXMediumSettings getKNXMedium() {
            T t = this.impl;
            if (t instanceof KNXNetworkLink) {
                return ((KNXNetworkLink)t).getKNXMedium();
            }
            if (t instanceof KNXNetworkMonitor) {
                return ((KNXNetworkMonitor)t).getKNXMedium();
            }
            return this.settings;
        }

        @Override
        public void addLinkListener(NetworkLinkListener l) {
            if (this.impl instanceof KNXNetworkLink) {
                ((KNXNetworkLink)this.impl).addLinkListener(l);
            }
            this.listeners.add(l);
        }

        @Override
        public void removeLinkListener(NetworkLinkListener l) {
            this.listeners.remove(l);
            if (this.impl instanceof KNXNetworkLink) {
                ((KNXNetworkLink)this.impl).removeLinkListener(l);
            }
        }

        @Override
        public void addMonitorListener(LinkListener l) {
            if (this.impl instanceof KNXNetworkMonitor) {
                ((KNXNetworkMonitor)this.impl).addMonitorListener(l);
            }
            this.listeners.add(l);
        }

        @Override
        public void removeMonitorListener(LinkListener l) {
            this.listeners.remove(l);
            if (this.impl instanceof KNXNetworkMonitor) {
                ((KNXNetworkMonitor)this.impl).removeMonitorListener(l);
            }
        }

        @Override
        public void setDecodeRawFrames(boolean decode) {
            this.decodeRawFrames = decode;
            if (this.impl instanceof KNXNetworkMonitor) {
                ((KNXNetworkMonitor)this.impl).setDecodeRawFrames(decode);
            }
        }

        @Override
        public void setHopCount(int count) {
            if (this.impl instanceof KNXNetworkLink) {
                ((KNXNetworkLink)this.impl).setHopCount(count);
            }
            this.hopCount = count;
        }

        @Override
        public int getHopCount() {
            return this.impl != null ? ((KNXNetworkLink)this.impl).getHopCount() : this.hopCount;
        }

        @Override
        public void sendRequest(KNXAddress dst, Priority p, byte[] nsdu) throws KNXTimeoutException, KNXLinkClosedException {
            this.link().sendRequest(dst, p, nsdu);
        }

        @Override
        public void sendRequestWait(KNXAddress dst, Priority p, byte[] nsdu) throws KNXTimeoutException, KNXLinkClosedException {
            this.link().sendRequestWait(dst, p, nsdu);
        }

        @Override
        public void send(CEMILData msg, boolean waitForCon) throws KNXTimeoutException, KNXLinkClosedException {
            this.link().send(msg, waitForCon);
        }

        @Override
        public String getName() {
            T t = this.impl;
            if (t instanceof KNXNetworkLink) {
                return ((KNXNetworkLink)t).getName();
            }
            if (t instanceof KNXNetworkMonitor) {
                return ((KNXNetworkMonitor)t).getName();
            }
            return "connector";
        }

        @Override
        public boolean isOpen() {
            return !this.closed;
        }

        @Override
        public void close() {
            this.closed = true;
            this.f.cancel(true);
            try {
                if (this.impl != null) {
                    this.impl.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void linkClosed(CloseEvent e) {
            this.connector.connectionStatusChanged.accept(false);
            if (e.getInitiator() == 3 && this.connector.internalError || e.getInitiator() == 1 && this.connector.serverError) {
                this.scheduleConnect(this.connector.maxAttempts);
            }
        }

        public String toString() {
            T v = this.impl;
            return v != null ? v.toString() : "link connecting...";
        }

        private KNXNetworkLink link() throws KNXLinkClosedException {
            try {
                KNXNetworkLink l = (KNXNetworkLink)this.impl;
                return (KNXNetworkLink)(l == null ? this.connect() : (l.isOpen() ? l : (this.connector.onSend ? this.connect() : l)));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new KNXLinkClosedException("interrupt on reconnecting link", e);
            }
            catch (KNXLinkClosedException e) {
                throw e;
            }
            catch (KNXException e) {
                throw new KNXLinkClosedException("reconnecting link", e);
            }
        }

        private void scheduleConnect(long remainingAttempts) {
            if (this.closed || remainingAttempts <= 0L) {
                return;
            }
            long max = this.connector.maxAttempts;
            long remaining = remainingAttempts - 1L;
            long attempt = max - remaining;
            Runnable s = () -> {
                try {
                    Object maxSuffix = this.connector.maxAttempts == Long.MAX_VALUE ? " (no max)" : "/" + max + " (" + remaining + " remaining)";
                    this.logger().debug("execute scheduled connect {}{}", (Object)attempt, maxSuffix);
                    this.connect();
                }
                catch (InterruptedException | RuntimeException | KNXException e) {
                    if (attempt == 1L) {
                        this.logger().warn("connection attempt {}", (Object)attempt, (Object)e);
                    } else {
                        Throwable cause = e.getCause();
                        String detail = cause != null && cause.getMessage() != null ? " (" + cause.getMessage() + ")" : "";
                        this.logger().warn("connection attempt {}: {}{}", new Object[]{attempt, e.getMessage(), detail});
                    }
                    this.scheduleConnect(remaining);
                }
            };
            this.f = reconnect.schedule(s, this.connector.reconnectDelay, TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AutoCloseable connect() throws InterruptedException, KNXException {
            if (this.targetOpen()) {
                return this.impl;
            }
            if (this.connecting.compareAndSet(false, true)) {
                try {
                    AutoCloseable t = (AutoCloseable)this.creator.get();
                    if (t instanceof KNXNetworkLink) {
                        KNXNetworkLink link = (KNXNetworkLink)t;
                        if (this.impl == null) {
                            this.settings = link.getKNXMedium();
                            this.hopCount = link.getHopCount();
                        }
                        link.setKNXMedium(this.settings);
                        link.setHopCount(this.hopCount);
                        link.addLinkListener(this);
                        this.listeners.forEach(l -> link.addLinkListener((NetworkLinkListener)l));
                    } else if (t instanceof KNXNetworkMonitor) {
                        KNXNetworkMonitor monitor = (KNXNetworkMonitor)t;
                        monitor.setDecodeRawFrames(this.decodeRawFrames);
                        monitor.addMonitorListener(this);
                        this.listeners.forEach(monitor::addMonitorListener);
                    }
                    this.impl = t;
                }
                catch (KNXRemoteException e) {
                    KNXLinkClosedException lce = new KNXLinkClosedException(e.getMessage());
                    lce.initCause(e);
                    throw lce;
                }
                finally {
                    this.connecting.set(false);
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.notifyAll();
                    }
                }
                this.connector.connectionStatusChanged.accept(true);
            } else {
                Object object = this.lock;
                synchronized (object) {
                    while (this.connecting.get()) {
                        this.lock.wait();
                    }
                }
                if (!this.targetOpen()) {
                    throw new KNXLinkClosedException("ongoing connect attempt we waited for failed");
                }
            }
            return this.impl;
        }

        private boolean targetOpen() {
            T t = this.impl;
            if (t instanceof KNXNetworkLink) {
                return ((KNXNetworkLink)t).isOpen();
            }
            if (t instanceof KNXNetworkMonitor) {
                return ((KNXNetworkMonitor)t).isOpen();
            }
            return false;
        }

        private Logger logger() {
            return LoggerFactory.getLogger((String)("calimero.link." + this.getName()));
        }

        static {
            reconnect.setKeepAliveTime(61L, TimeUnit.SECONDS);
            reconnect.allowCoreThreadTimeOut(true);
        }
    }

    @FunctionalInterface
    public static interface TSupplier<T> {
        public T get() throws KNXException, InterruptedException;
    }
}

