/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.link;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Consumer;
import org.slf4j.Logger;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.KNXListener;
import tuwien.auto.calimero.internal.EventListeners;
import tuwien.auto.calimero.link.LinkListener;

public abstract class EventNotifier<T extends LinkListener>
extends Thread
implements KNXListener {
    final Logger logger;
    final Object source;
    private final EventListeners<T> listeners;
    private final Deque<Consumer<? super T>> events = new ArrayDeque<Consumer<? super T>>();
    private volatile boolean running = true;

    EventNotifier(Object source, Logger logger) {
        super("Calimero link notifier");
        this.logger = logger;
        this.source = source;
        this.listeners = new EventListeners(logger);
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try {
            while (this.running) {
                Consumer<? super T> c;
                Deque<Consumer<? super T>> deque = this.events;
                synchronized (deque) {
                    while (this.events.isEmpty()) {
                        this.events.wait();
                    }
                    c = this.events.remove();
                }
                this.fire(c);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.drainEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainEvents() {
        while (true) {
            Consumer<? super T> c;
            Deque<Consumer<? super T>> deque = this.events;
            synchronized (deque) {
                if (this.events.isEmpty()) {
                    return;
                }
                c = this.events.remove();
            }
            this.fire(c);
        }
    }

    @Override
    public abstract void frameReceived(FrameEvent var1);

    @Override
    public void connectionClosed(CloseEvent e) {
        this.addEvent(l -> l.linkClosed(new CloseEvent(this.source, e.getInitiator(), e.getReason())));
        this.quit();
    }

    public EventListeners<T> getListeners() {
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addEvent(Consumer<? super T> c) {
        Deque<Consumer<? super T>> deque = this.events;
        synchronized (deque) {
            this.events.add(c);
            this.events.notify();
        }
    }

    final void addListener(T l) {
        this.listeners.add(l);
    }

    final void removeListener(T l) {
        this.listeners.remove(l);
    }

    final void quit() {
        this.running = false;
        this.interrupt();
        if (EventNotifier.currentThread() != this) {
            try {
                this.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void fire(Consumer<? super T> c) {
        this.listeners.fire(c);
    }
}

