/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.link;

import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.link.AbstractLink;
import tuwien.auto.calimero.link.BcuSwitcher;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;
import tuwien.auto.calimero.serial.FT12Connection;
import tuwien.auto.calimero.serial.KNXPortClosedException;

public class KNXNetworkLinkFT12
extends AbstractLink<FT12Connection> {
    public static KNXNetworkLinkFT12 newCemiLink(String portId, KNXMediumSettings settings) throws KNXException, InterruptedException {
        return new KNXNetworkLinkFT12(new FT12Connection(portId, 19200, true), settings, true);
    }

    public KNXNetworkLinkFT12(String portID, KNXMediumSettings settings) throws KNXException, InterruptedException {
        this(new FT12Connection(portID), settings);
    }

    public KNXNetworkLinkFT12(int portNumber, KNXMediumSettings settings) throws KNXException, InterruptedException {
        this(new FT12Connection(portNumber), settings);
    }

    protected KNXNetworkLinkFT12(FT12Connection c, KNXMediumSettings settings) throws KNXException {
        this(c, settings, false);
    }

    protected KNXNetworkLinkFT12(FT12Connection c, KNXMediumSettings settings, boolean cEMI) throws KNXException {
        super(c, c.getPortID(), settings);
        this.cEMI = cEMI;
        this.sendCEmiAsByteArray = true;
        this.linkLayerMode();
        ((FT12Connection)this.conn).addConnectionListener(this.notifier);
    }

    @Override
    protected void onSend(KNXAddress dst, byte[] msg, boolean waitForCon) throws KNXTimeoutException, KNXLinkClosedException {
        try {
            this.logger.debug("send message to {}{}", (Object)dst, (Object)(waitForCon ? ", wait for ack" : ""));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("EMI {}", (Object)DataUnitBuilder.toHex(msg, " "));
            }
            ((FT12Connection)this.conn).send(msg, waitForCon);
            this.logger.trace("send to {} succeeded", (Object)dst);
        }
        catch (InterruptedException | KNXPortClosedException e) {
            this.logger.error("send error, closing link", (Throwable)e);
            this.close();
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new KNXLinkClosedException("link closed, " + e.getMessage());
        }
    }

    @Override
    protected void onSend(CEMILData msg, boolean waitForCon) {
    }

    @Override
    protected void onClose() {
        try {
            this.normalMode();
        }
        catch (Exception e) {
            this.logger.warn("could not switch BCU back to normal mode", (Throwable)e);
        }
    }

    private void linkLayerMode() throws KNXException {
        new BcuSwitcher((FT12Connection)this.conn).linkLayerMode(this.cEMI);
    }

    private void normalMode() throws KNXTimeoutException, KNXPortClosedException, KNXLinkClosedException {
        new BcuSwitcher((FT12Connection)this.conn).normalMode(this.cEMI);
    }
}

