/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.link;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXAckTimeoutException;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXListener;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.KnxRuntimeException;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.ReturnCode;
import tuwien.auto.calimero.cemi.CEMIDevMgmt;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.knxnetip.Connection;
import tuwien.auto.calimero.knxnetip.KNXConnectionClosedException;
import tuwien.auto.calimero.knxnetip.KNXnetIPConnection;
import tuwien.auto.calimero.knxnetip.KNXnetIPDevMgmt;
import tuwien.auto.calimero.knxnetip.KNXnetIPRouting;
import tuwien.auto.calimero.knxnetip.KNXnetIPTunnel;
import tuwien.auto.calimero.knxnetip.LostMessageEvent;
import tuwien.auto.calimero.knxnetip.RoutingBusyEvent;
import tuwien.auto.calimero.knxnetip.RoutingListener;
import tuwien.auto.calimero.knxnetip.SecureConnection;
import tuwien.auto.calimero.knxnetip.TunnelingListener;
import tuwien.auto.calimero.knxnetip.servicetype.TunnelingFeature;
import tuwien.auto.calimero.link.AbstractLink;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;

public class KNXNetworkLinkIP
extends AbstractLink<KNXnetIPConnection> {
    public static final InetAddress DefaultMulticast;
    protected static final int TUNNELING = 1;
    protected static final int TunnelingV2 = 3;
    protected static final int ROUTING = 2;
    private final int mode;
    private KNXnetIPDevMgmt mgmt;
    private InetSocketAddress mgmtLocalEp;
    private InetSocketAddress mgmtRemoteEp;
    private boolean mgmtNat;

    public static KNXNetworkLinkIP newTunnelingLink(InetSocketAddress localEP, InetSocketAddress remoteEP, boolean useNAT, KNXMediumSettings settings) throws KNXException, InterruptedException {
        return new KNXNetworkLinkIP(1, localEP, remoteEP, useNAT, settings);
    }

    public static KNXNetworkLinkIP newTunnelingLink(Connection connection, KNXMediumSettings settings) throws KNXException, InterruptedException {
        return new KNXNetworkLinkIP(3, KNXnetIPTunnel.newTcpTunnel(KNXnetIPTunnel.TunnelingLayer.LinkLayer, connection, settings.getDeviceAddress()), settings);
    }

    public static KNXNetworkLinkIP newSecureTunnelingLink(InetSocketAddress localEP, InetSocketAddress remoteEP, boolean useNat, byte[] deviceAuthCode, int userId, byte[] userKey, KNXMediumSettings settings) throws KNXException, InterruptedException {
        KNXnetIPConnection c = SecureConnection.newTunneling(KNXnetIPTunnel.TunnelingLayer.LinkLayer, localEP, remoteEP, useNat, deviceAuthCode, userId, userKey);
        return new KNXNetworkLinkIP(3, c, settings);
    }

    public static KNXNetworkLinkIP newSecureTunnelingLink(Connection.SecureSession session, KNXMediumSettings settings) throws KNXException, InterruptedException {
        KNXnetIPConnection c = SecureConnection.newTunneling(KNXnetIPTunnel.TunnelingLayer.LinkLayer, session, settings.getDeviceAddress());
        return new KNXNetworkLinkIP(3, c, settings);
    }

    public static KNXNetworkLinkIP newRoutingLink(NetworkInterface netIf, InetAddress mcGroup, KNXMediumSettings settings) throws KNXException {
        try {
            return new KNXNetworkLinkIP(2, new KNXnetIPRouting(netIf, mcGroup), settings);
        }
        catch (InterruptedException unreachable) {
            throw new IllegalStateException();
        }
    }

    public static KNXNetworkLinkIP newRoutingLink(InetAddress localEP, InetAddress mcGroup, KNXMediumSettings settings) throws KNXException {
        try {
            return KNXNetworkLinkIP.newRoutingLink(NetworkInterface.getByInetAddress(localEP), mcGroup, settings);
        }
        catch (SocketException e) {
            throw new KNXException("error getting network interface: " + e.getMessage());
        }
    }

    public static KNXNetworkLinkIP newSecureRoutingLink(NetworkInterface netif, InetAddress mcGroup, byte[] groupKey, Duration latencyTolerance, KNXMediumSettings settings) throws KNXException {
        try {
            return new KNXNetworkLinkIP(2, SecureConnection.newRouting(netif, mcGroup, groupKey, latencyTolerance), settings);
        }
        catch (InterruptedException unreachable) {
            throw new IllegalStateException();
        }
    }

    protected KNXNetworkLinkIP(int serviceMode, InetSocketAddress localEP, InetSocketAddress remoteEP, boolean useNAT, KNXMediumSettings settings) throws KNXException, InterruptedException {
        this(serviceMode, KNXNetworkLinkIP.newConnection(serviceMode, localEP, remoteEP, useNAT), settings);
        if (serviceMode == 1) {
            this.configureWithServerSettings(localEP, remoteEP, useNAT);
        }
    }

    protected KNXNetworkLinkIP(int serviceMode, KNXnetIPConnection c, KNXMediumSettings settings) throws KNXAckTimeoutException, KNXConnectionClosedException, InterruptedException {
        super(c, KNXNetworkLinkIP.createLinkName(c.getRemoteAddress()), settings);
        this.cEMI = true;
        this.mode = serviceMode;
        ((KNXnetIPConnection)this.conn).addConnectionListener(this.notifier);
        if (c instanceof KNXnetIPTunnel && this.mode == 3) {
            this.customEvents.put(TunnelingFeature.class, ConcurrentHashMap.newKeySet());
            KNXnetIPTunnel tunnel = (KNXnetIPTunnel)c;
            tunnel.addConnectionListener(new TunnelingListener(){

                @Override
                public void featureResponse(TunnelingFeature feature) {
                    if (this.valid(feature)) {
                        if (feature.featureId() == TunnelingFeature.InterfaceFeature.MaxApduLength) {
                            KNXNetworkLinkIP.this.getKNXMedium().setMaxApduLength(AbstractLink.unsigned(feature.featureValue().get()));
                        }
                        if (feature.featureId() == TunnelingFeature.InterfaceFeature.IndividualAddress) {
                            this.setTunnelingAddress(feature);
                        }
                    }
                    KNXNetworkLinkIP.this.dispatchCustomEvent(feature);
                }

                @Override
                public void featureInfo(TunnelingFeature feature) {
                    if (!this.valid(feature)) {
                        return;
                    }
                    if (feature.featureId() == TunnelingFeature.InterfaceFeature.ConnectionStatus) {
                        boolean connected;
                        boolean bl = connected = feature.featureValue().get()[0] == 1;
                        if (connected) {
                            KNXNetworkLinkIP.this.logger.info("subnet connected");
                        } else {
                            KNXNetworkLinkIP.this.logger.warn("no connection to subnet");
                        }
                    }
                    if (feature.featureId() == TunnelingFeature.InterfaceFeature.IndividualAddress) {
                        this.setTunnelingAddress(feature);
                    }
                    KNXNetworkLinkIP.this.dispatchCustomEvent(feature);
                }

                private boolean valid(TunnelingFeature feature) {
                    boolean valid;
                    boolean bl = valid = feature.status() == ReturnCode.Success;
                    if (!valid) {
                        KNXNetworkLinkIP.this.logger.warn("received {}", (Object)feature);
                    }
                    return valid;
                }

                @Override
                public void frameReceived(FrameEvent e) {
                }

                @Override
                public void connectionClosed(CloseEvent e) {
                }

                private void setTunnelingAddress(TunnelingFeature feature) {
                    KNXNetworkLinkIP.this.getKNXMedium().setDeviceAddress(new IndividualAddress(feature.featureValue().get()));
                }
            });
            tunnel.send(TunnelingFeature.InterfaceFeature.EnableFeatureInfoService, 1);
            tunnel.send(TunnelingFeature.InterfaceFeature.IndividualAddress);
            tunnel.send(TunnelingFeature.InterfaceFeature.MaxApduLength);
            tunnel.send(TunnelingFeature.InterfaceFeature.DeviceDescriptorType0);
        } else if (c instanceof KNXnetIPRouting) {
            this.customEvents.put(LostMessageEvent.class, ConcurrentHashMap.newKeySet());
            this.customEvents.put(RoutingBusyEvent.class, ConcurrentHashMap.newKeySet());
            c.addConnectionListener(new RoutingListener(){

                @Override
                public void frameReceived(FrameEvent e) {
                }

                @Override
                public void connectionClosed(CloseEvent e) {
                }

                @Override
                public void routingBusy(RoutingBusyEvent e) {
                    KNXNetworkLinkIP.this.dispatchCustomEvent(e);
                }

                @Override
                public void lostMessage(LostMessageEvent e) {
                    KNXNetworkLinkIP.this.dispatchCustomEvent(e);
                }
            });
        }
    }

    @Override
    public void sendRequest(KNXAddress dst, Priority p, byte[] nsdu) throws KNXLinkClosedException, KNXTimeoutException {
        int mc = this.mode == 2 ? 41 : 17;
        this.send(mc, dst, p, nsdu, false);
    }

    @Override
    public void sendRequestWait(KNXAddress dst, Priority p, byte[] nsdu) throws KNXTimeoutException, KNXLinkClosedException {
        int mc = this.mode == 2 ? 41 : 17;
        this.send(mc, dst, p, nsdu, true);
    }

    @Override
    public String toString() {
        return (this.mode == 2 ? "routing " : "tunneling ") + super.toString();
    }

    @Override
    protected void onSend(KNXAddress dst, byte[] msg, boolean waitForCon) {
        throw new IllegalStateException("KNXnet/IP uses cEMI only");
    }

    @Override
    protected void onSend(CEMILData msg, boolean waitForCon) throws KNXTimeoutException, KNXLinkClosedException {
        try {
            this.logger.debug("send {}{}", (Object)(waitForCon ? "(wait for confirmation) " : ""), (Object)msg);
            ((KNXnetIPConnection)this.conn).send(msg, waitForCon ? KNXnetIPConnection.BlockingMode.WaitForCon : KNXnetIPConnection.BlockingMode.WaitForAck);
            this.logger.trace("send {}->{} succeeded", (Object)msg.getSource(), (Object)msg.getDestination());
        }
        catch (InterruptedException e) {
            this.close();
            Thread.currentThread().interrupt();
            throw new KNXLinkClosedException("link closed (interrupted)");
        }
        catch (KNXConnectionClosedException e) {
            this.logger.error("send error, closing link", (Throwable)e);
            this.close();
            throw new KNXLinkClosedException("link closed, " + e.getMessage());
        }
    }

    @Override
    void baosMode(boolean enable) throws KNXException, InterruptedException {
        try (KNXnetIPDevMgmt __ = this.newMgmt(this.mgmtLocalEp, this.mgmtRemoteEp, this.mgmtNat);){
            super.baosMode(enable);
        }
    }

    @Override
    void onSend(CEMIDevMgmt frame) throws KNXTimeoutException, KNXConnectionClosedException, InterruptedException {
        this.mgmt.send(frame, KNXnetIPConnection.BlockingMode.WaitForCon);
    }

    private void configureWithServerSettings(InetSocketAddress localEP, InetSocketAddress serverCtrlEP, boolean useNat) throws InterruptedException {
        this.mgmtLocalEp = localEP;
        this.mgmtRemoteEp = serverCtrlEP;
        this.mgmtNat = useNat;
        try (KNXnetIPDevMgmt __ = this.newMgmt(localEP, serverCtrlEP, useNat);){
            this.mediumType();
            this.setMaxApduLength();
        }
        catch (RuntimeException | KNXException e) {
            this.logger.warn("skip link configuration (use defaults)", (Throwable)e);
        }
    }

    private KNXnetIPDevMgmt newMgmt(InetSocketAddress localEP, InetSocketAddress serverCtrlEP, boolean useNat) throws KNXException, InterruptedException {
        this.mgmt = new KNXnetIPDevMgmt(new InetSocketAddress(localEP.getAddress(), 0), serverCtrlEP, useNat);
        this.mgmt.addConnectionListener(new KNXListener(){

            @Override
            public void frameReceived(FrameEvent e) {
                KNXNetworkLinkIP.this.onDevMgmt((CEMIDevMgmt)e.getFrame());
            }

            @Override
            public void connectionClosed(CloseEvent e) {
            }
        });
        return this.mgmt;
    }

    private static KNXnetIPConnection newConnection(int serviceMode, InetSocketAddress localEP, InetSocketAddress remoteEP, boolean useNAT) throws KNXException, InterruptedException {
        switch (serviceMode) {
            case 1: 
            case 3: {
                InetSocketAddress local = localEP == null ? new InetSocketAddress(0) : localEP;
                return new KNXnetIPTunnel(KNXnetIPTunnel.TunnelingLayer.LinkLayer, local, remoteEP, useNAT);
            }
            case 2: {
                NetworkInterface netIf = null;
                if (localEP != null && !localEP.isUnresolved()) {
                    try {
                        netIf = NetworkInterface.getByInetAddress(localEP.getAddress());
                    }
                    catch (SocketException e) {
                        throw new KNXException("error getting network interface: " + e.getMessage());
                    }
                }
                InetAddress mcast = remoteEP != null ? remoteEP.getAddress() : null;
                return new KNXnetIPRouting(netIf, mcast);
            }
        }
        throw new KNXIllegalArgumentException("unknown service mode " + serviceMode);
    }

    private static String createLinkName(InetSocketAddress endpt) {
        if (endpt == null) {
            return "224.0.23.12";
        }
        String host = endpt.isUnresolved() ? endpt.getHostString() : endpt.getAddress().getHostAddress();
        int p = endpt.getPort();
        if (p > 0) {
            return host + ":" + p;
        }
        return host;
    }

    static {
        try {
            DefaultMulticast = InetAddress.getByName("224.0.23.12");
        }
        catch (UnknownHostException e) {
            throw new KnxRuntimeException("KNXnet/IP system setup multicast address", e);
        }
    }
}

