/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.link;

import java.util.ArrayList;
import java.util.Collection;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.link.AbstractLink;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;
import tuwien.auto.calimero.serial.KNXPortClosedException;
import tuwien.auto.calimero.serial.TpuartConnection;

public class KNXNetworkLinkTpuart
extends AbstractLink<TpuartConnection> {
    public KNXNetworkLinkTpuart(String portId, KNXMediumSettings settings, Collection<? extends KNXAddress> acknowledge) throws KNXException {
        super(new TpuartConnection(portId, KNXNetworkLinkTpuart.ensureDeviceAck(settings, acknowledge)), "tpuart:" + portId, settings);
        this.sendCEmiAsByteArray = true;
        ((TpuartConnection)this.conn).addConnectionListener(this.notifier);
    }

    protected KNXNetworkLinkTpuart(TpuartConnection conn, KNXMediumSettings settings) {
        super(conn, "tpuart:user", settings);
        if (settings.getMedium() != 2) {
            throw new KNXIllegalArgumentException("TP-UART link supports only TP1 medium");
        }
        this.sendCEmiAsByteArray = true;
        conn.addConnectionListener(this.notifier);
    }

    public final void addAddress(KNXAddress ack) {
        ((TpuartConnection)this.conn).addAddress(ack);
    }

    public final void removeAddress(KNXAddress ack) {
        ((TpuartConnection)this.conn).removeAddress(ack);
    }

    @Override
    protected void onSend(KNXAddress dst, byte[] msg, boolean waitForCon) throws KNXTimeoutException, KNXLinkClosedException {
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("cEMI {}", (Object)DataUnitBuilder.toHex(msg, " "));
            }
            ((TpuartConnection)this.conn).send(msg, waitForCon);
        }
        catch (InterruptedException | KNXPortClosedException e) {
            this.close();
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new KNXLinkClosedException(this.getName(), e);
        }
    }

    @Override
    protected void onSend(CEMILData msg, boolean waitForCon) {
    }

    private static Collection<? extends KNXAddress> ensureDeviceAck(KNXMediumSettings settings, Collection<? extends KNXAddress> acknowledge) {
        if (settings.getMedium() != 2) {
            throw new KNXIllegalArgumentException("TP-UART link supports only TP1 medium");
        }
        IndividualAddress device = settings.getDeviceAddress();
        if (device.getDevice() == 0 || device.getDevice() == 255) {
            return acknowledge;
        }
        ArrayList<? extends KNXAddress> l = new ArrayList<KNXAddress>(acknowledge);
        l.add(device);
        return l;
    }
}

