/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.link;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.DeviceDescriptor;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.cemi.CEMIDevMgmt;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.knxnetip.KNXConnectionClosedException;
import tuwien.auto.calimero.link.AbstractLink;
import tuwien.auto.calimero.link.BcuSwitcher;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;
import tuwien.auto.calimero.serial.KNXPortClosedException;
import tuwien.auto.calimero.serial.usb.HidReport;
import tuwien.auto.calimero.serial.usb.TransferProtocolHeader;
import tuwien.auto.calimero.serial.usb.UsbConnection;

public class KNXNetworkLinkUsb
extends AbstractLink<UsbConnection> {
    private static final int PEI_SWITCH = 169;
    private final EnumSet<UsbConnection.EmiType> emiTypes;
    private UsbConnection.EmiType activeEmi;

    public KNXNetworkLinkUsb(int vendorId, int productId, KNXMediumSettings settings) throws KNXException, InterruptedException {
        this(new UsbConnection(vendorId, productId), settings);
    }

    public KNXNetworkLinkUsb(String device, KNXMediumSettings settings) throws KNXException, InterruptedException {
        this(new UsbConnection(device), settings);
    }

    protected KNXNetworkLinkUsb(UsbConnection c, KNXMediumSettings settings) throws KNXException, InterruptedException {
        super(c, c.getName(), settings);
        try {
            if (!((UsbConnection)this.conn).isKnxConnectionActive()) {
                throw new KNXConnectionClosedException("USB interface is not connected to KNX network");
            }
            this.emiTypes = ((UsbConnection)this.conn).getSupportedEmiTypes();
            if (!(this.trySetActiveEmi(UsbConnection.EmiType.CEmi) || this.trySetActiveEmi(UsbConnection.EmiType.Emi2) || this.trySetActiveEmi(UsbConnection.EmiType.Emi1))) {
                throw new KNXConnectionClosedException("failed to set active any supported EMI type");
            }
            try {
                DeviceDescriptor.DD0 dd0 = ((UsbConnection)this.conn).deviceDescriptor();
                this.logger.info("Device Descriptor (Mask Version) {}", (Object)dd0);
            }
            catch (KNXTimeoutException dd0) {
                // empty catch block
            }
            ((UsbConnection)this.conn).addConnectionListener(this.notifier);
            this.linkLayerMode();
        }
        catch (KNXException e) {
            this.notifier.quit();
            ((UsbConnection)this.conn).close();
            throw e;
        }
        this.cEMI = this.emiTypes.contains((Object)UsbConnection.EmiType.CEmi);
        this.sendCEmiAsByteArray = true;
        this.supportedCommModes();
        this.deviceAddr();
        this.mediumType();
        this.setMaxApduLength();
        this.disableFilters();
    }

    @Override
    protected void onSend(KNXAddress dst, byte[] msg, boolean waitForCon) throws KNXTimeoutException, KNXLinkClosedException {
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("EMI {}", (Object)DataUnitBuilder.toHex(msg, " "));
            }
            List<HidReport> reports = HidReport.create(this.activeEmi.emi, msg);
            for (HidReport r : reports) {
                ((UsbConnection)this.conn).send(r, waitForCon);
            }
            this.logger.trace("send to {} succeeded", (Object)dst);
        }
        catch (KNXPortClosedException e) {
            this.logger.error("send error, closing link", (Throwable)e);
            this.close();
            throw new KNXLinkClosedException("link closed, " + e.getMessage());
        }
    }

    @Override
    protected void onSend(CEMILData msg, boolean waitForCon) {
    }

    @Override
    protected void onClose() {
        try {
            this.normalMode();
        }
        catch (Exception e) {
            this.logger.error("could not switch BCU back to normal mode", (Throwable)e);
        }
    }

    @Override
    void onSend(CEMIDevMgmt frame) throws KNXPortClosedException, KNXTimeoutException {
        ((UsbConnection)this.conn).send(HidReport.create(TransferProtocolHeader.KnxTunnelEmi.CEmi, frame.toByteArray()).get(0), true);
    }

    private boolean trySetActiveEmi(UsbConnection.EmiType active) throws KNXPortClosedException, KNXTimeoutException, InterruptedException {
        if (this.emiTypes.contains((Object)active)) {
            ((UsbConnection)this.conn).setActiveEmiType(active);
            this.activeEmi = ((UsbConnection)this.conn).getActiveEmiType();
            return this.activeEmi == active;
        }
        return false;
    }

    private void linkLayerMode() throws KNXException, InterruptedException {
        if (this.activeEmi == UsbConnection.EmiType.CEmi) {
            byte[] frame = BcuSwitcher.commModeRequest(0);
            ((UsbConnection)this.conn).send(HidReport.create(TransferProtocolHeader.KnxTunnelEmi.CEmi, frame).get(0), true);
            this.responseFor(245, 52);
        } else if (this.activeEmi == UsbConnection.EmiType.Emi1) {
            new BcuSwitcher((UsbConnection)this.conn, this.logger).enter(BcuSwitcher.BcuMode.LinkLayer);
        } else {
            byte[] switchLinkLayer = new byte[]{-87, 0, 24, 52, 86, 120, 10};
            ((UsbConnection)this.conn).send(HidReport.create(this.activeEmi.emi, switchLinkLayer).get(0), true);
        }
    }

    private void normalMode() throws KNXPortClosedException, KNXTimeoutException, InterruptedException {
        if (this.activeEmi == UsbConnection.EmiType.CEmi) {
            CEMIDevMgmt frame = new CEMIDevMgmt(241);
            ((UsbConnection)this.conn).send(HidReport.create(TransferProtocolHeader.KnxTunnelEmi.CEmi, frame.toByteArray()).get(0), true);
        } else if (this.activeEmi == UsbConnection.EmiType.Emi1) {
            new BcuSwitcher((UsbConnection)this.conn, this.logger).reset();
        } else {
            byte[] switchNormal = new byte[]{-87, 30, 18, 52, 86, 120, -102};
            ((UsbConnection)this.conn).send(HidReport.create(this.activeEmi.emi, switchNormal).get(0), true);
        }
    }

    private void supportedCommModes() throws KNXException, InterruptedException {
        int pidSupportedCommModes = 64;
        this.read(8, 64).map(AbstractLink::unsigned).ifPresent(this::logCommModes);
    }

    private void logCommModes(int modes) {
        this.logger.debug("KNX interface supports {}", (Object)Stream.of(KNXNetworkLinkUsb.bool(modes & 8, "transport link layer"), KNXNetworkLinkUsb.bool(modes & 4, "raw mode"), KNXNetworkLinkUsb.bool(modes & 2, "busmonitor"), KNXNetworkLinkUsb.bool(modes & 1, "data link layer")).filter(s -> !s.isEmpty()).collect(Collectors.joining(", ")));
    }

    private static String bool(int condition, String ifTrue) {
        return condition != 0 ? ifTrue : "";
    }

    private void deviceAddr() throws KNXException, InterruptedException {
        int pidSubnet = 57;
        int pidDeviceAddr = 58;
        Optional<byte[]> subnet = this.read(0, 57);
        if (subnet.isPresent()) {
            int addr = this.read(0, 58).map(data -> KNXNetworkLinkUsb.unsigned(((byte[])subnet.get())[0], data[0])).orElse(0);
            this.logger.debug("KNX interface address {}", (Object)new IndividualAddress(addr));
        }
    }

    private void disableFilters() throws KNXException {
        if (this.getKNXMedium().getMedium() != 16) {
            return;
        }
        int pidFilteringModeSelect = 66;
        this.write(8, 66, new byte[]{0, 15});
    }

    private void write(int objectType, int pid, byte[] data) throws KNXException {
        if (!this.cEMI) {
            return;
        }
        boolean objectInstance = true;
        CEMIDevMgmt frame = new CEMIDevMgmt(246, objectType, 1, pid, 1, 1, data);
        this.logger.trace("write mgmt OT {} PID {} data 0x{}", new Object[]{objectType, pid, DataUnitBuilder.toHex(data, "")});
        ((UsbConnection)this.conn).send(HidReport.create(TransferProtocolHeader.KnxTunnelEmi.CEmi, frame.toByteArray()).get(0), true);
    }
}

