/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.link;

import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.link.AbstractMonitor;
import tuwien.auto.calimero.link.BcuSwitcher;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;
import tuwien.auto.calimero.serial.FT12Connection;
import tuwien.auto.calimero.serial.KNXPortClosedException;

public class KNXNetworkMonitorFT12
extends AbstractMonitor<FT12Connection> {
    private final boolean cEMI;

    public static KNXNetworkMonitorFT12 newCemiMonitor(String portId, KNXMediumSettings settings) throws KNXException, InterruptedException {
        return new KNXNetworkMonitorFT12(new FT12Connection(portId), settings, true);
    }

    public KNXNetworkMonitorFT12(String portID, KNXMediumSettings settings) throws KNXException, InterruptedException {
        this(new FT12Connection(portID), settings);
    }

    public KNXNetworkMonitorFT12(int portNumber, KNXMediumSettings settings) throws KNXException, InterruptedException {
        this(new FT12Connection(portNumber), settings);
    }

    protected KNXNetworkMonitorFT12(FT12Connection conn, KNXMediumSettings settings) throws KNXException {
        this(conn, settings, false);
    }

    protected KNXNetworkMonitorFT12(FT12Connection conn, KNXMediumSettings settings, boolean cEMI) throws KNXException {
        super(conn, "monitor " + conn.getPortID(), settings);
        this.cEMI = cEMI;
        this.enterBusmonitor();
        this.logger.info("in busmonitor mode - ready to receive");
        conn.addConnectionListener(this.notifier);
    }

    private void enterBusmonitor() throws KNXTimeoutException, KNXPortClosedException, KNXLinkClosedException {
        new BcuSwitcher((FT12Connection)this.conn).enterBusmonitor(this.cEMI);
    }

    @Override
    protected void leaveBusmonitor() {
        try {
            new BcuSwitcher((FT12Connection)this.conn).leaveBusmonitor(this.cEMI);
        }
        catch (KNXTimeoutException | KNXLinkClosedException | KNXPortClosedException kNXException) {
            // empty catch block
        }
    }
}

