/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.link;

import java.net.InetSocketAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.knxnetip.KNXnetIPConnection;
import tuwien.auto.calimero.knxnetip.KNXnetIPTunnel;
import tuwien.auto.calimero.knxnetip.SecureConnection;
import tuwien.auto.calimero.link.AbstractMonitor;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;

public class KNXNetworkMonitorIP
extends AbstractMonitor<KNXnetIPConnection> {
    public static KNXNetworkMonitorIP newSecureMonitorLink(InetSocketAddress localEP, InetSocketAddress remoteEP, boolean useNat, byte[] deviceAuthCode, int userId, byte[] userKey, KNXMediumSettings settings) throws KNXException, InterruptedException {
        KNXnetIPConnection c = SecureConnection.newTunneling(KNXnetIPTunnel.TunnelingLayer.BusMonitorLayer, localEP, remoteEP, useNat, deviceAuthCode, userId, userKey);
        return new KNXNetworkMonitorIP(c, settings);
    }

    public KNXNetworkMonitorIP(InetSocketAddress localEP, InetSocketAddress remoteEP, boolean useNAT, KNXMediumSettings settings) throws KNXException, InterruptedException {
        this(new KNXnetIPTunnel(KNXnetIPTunnel.TunnelingLayer.BusMonitorLayer, KNXNetworkMonitorIP.localEndpoint(localEP), remoteEP, useNAT), settings);
    }

    protected KNXNetworkMonitorIP(KNXnetIPConnection conn, KNXMediumSettings settings) {
        super(conn, KNXNetworkMonitorIP.monitorName(conn.getRemoteAddress()), settings);
        this.logger.info("in busmonitor mode - ready to receive");
        conn.addConnectionListener(this.notifier);
    }

    private static InetSocketAddress localEndpoint(InetSocketAddress local) {
        if (local != null) {
            return local;
        }
        return new InetSocketAddress(0);
    }

    private static String monitorName(InetSocketAddress remote) {
        String host = remote.isUnresolved() ? remote.getHostString() : remote.getAddress().getHostAddress();
        return "monitor " + host + ":" + remote.getPort();
    }
}

