/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.link;

import java.io.IOException;
import java.util.Collections;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.link.AbstractMonitor;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;
import tuwien.auto.calimero.link.medium.TPSettings;
import tuwien.auto.calimero.serial.TpuartConnection;

public class KNXNetworkMonitorTpuart
extends AbstractMonitor<TpuartConnection> {
    private static final KNXMediumSettings medium = new TPSettings();

    public KNXNetworkMonitorTpuart(String portId, boolean decodeRawFrames) throws KNXException {
        this(new TpuartConnection(portId, Collections.emptyList()), "tpuart:" + portId, decodeRawFrames);
    }

    protected KNXNetworkMonitorTpuart(TpuartConnection conn, String name, boolean decodeRawFrames) throws KNXLinkClosedException {
        super(conn, name, medium);
        this.enterBusmonitor();
        this.setDecodeRawFrames(decodeRawFrames);
        conn.addConnectionListener(this.notifier);
    }

    private void enterBusmonitor() throws KNXLinkClosedException {
        try {
            ((TpuartConnection)this.conn).activateBusmonitor();
        }
        catch (IOException e) {
            this.close();
            throw new KNXLinkClosedException("on activating TP-UART busmonitor", e);
        }
    }
}

