/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.link.medium;

import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.link.medium.KnxIPSettings;
import tuwien.auto.calimero.link.medium.PLSettings;
import tuwien.auto.calimero.link.medium.RFSettings;
import tuwien.auto.calimero.link.medium.TPSettings;

public abstract class KNXMediumSettings {
    public static final int MEDIUM_TP1 = 2;
    public static final int MEDIUM_PL110 = 4;
    public static final int MEDIUM_RF = 16;
    public static final int MEDIUM_KNXIP = 32;
    public static final IndividualAddress BackboneRouter = new IndividualAddress(0);
    private IndividualAddress dev;
    private volatile int maxApduLength = 15;

    public static KNXMediumSettings create(int medium, IndividualAddress device) {
        switch (medium) {
            case 2: {
                return new TPSettings(device);
            }
            case 4: {
                return new PLSettings(device, null);
            }
            case 16: {
                return new RFSettings(device);
            }
            case 32: {
                return new KnxIPSettings(device);
            }
        }
        throw new KNXIllegalArgumentException("unknown medium type " + medium);
    }

    protected KNXMediumSettings(IndividualAddress device) {
        this.dev = device;
    }

    public final synchronized void setDeviceAddress(IndividualAddress device) {
        this.dev = device;
    }

    public final synchronized IndividualAddress getDeviceAddress() {
        return this.dev;
    }

    public abstract int getMedium();

    public static int getMedium(String mediumName) {
        if ("tp1".equalsIgnoreCase(mediumName)) {
            return 2;
        }
        if ("p110".equalsIgnoreCase(mediumName) || "pl110".equalsIgnoreCase(mediumName)) {
            return 4;
        }
        if ("rf".equalsIgnoreCase(mediumName)) {
            return 16;
        }
        if ("knxip".equalsIgnoreCase(mediumName) || "knx ip".equalsIgnoreCase(mediumName)) {
            return 32;
        }
        throw new KNXIllegalArgumentException("unknown medium type " + mediumName);
    }

    public String getMediumString() {
        return KNXMediumSettings.getMediumString(this.getMedium());
    }

    public static String getMediumString(int knxMedium) {
        switch (knxMedium) {
            case 2: {
                return "TP1";
            }
            case 4: {
                return "PL110";
            }
            case 16: {
                return "RF";
            }
            case 32: {
                return "KNX IP";
            }
        }
        return "unknown";
    }

    public final int maxApduLength() {
        return this.maxApduLength;
    }

    public void setMaxApduLength(int maxApduLength) {
        if (maxApduLength < 15 || maxApduLength > 254) {
            throw new KNXIllegalArgumentException("invalid maximum APDU setting of " + maxApduLength);
        }
        this.maxApduLength = maxApduLength;
    }

    public int timeFactor() {
        return 0;
    }

    public String toString() {
        return this.getMediumString() + " medium, device " + this.dev;
    }
}

