/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.link.medium;

import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.SerialNumber;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;

public class RFSettings
extends KNXMediumSettings {
    private static final byte[] broadcastDomain = new byte[6];
    private byte[] doa;
    private final SerialNumber sno;
    private final boolean unidir;

    public RFSettings(IndividualAddress device) {
        super(device);
        this.doa = broadcastDomain;
        this.sno = SerialNumber.Zero;
        this.unidir = false;
    }

    public RFSettings(IndividualAddress device, byte[] domain, SerialNumber serialNumber, boolean unidirectional) {
        super(device);
        this.setDomainAddress(domain);
        this.sno = serialNumber;
        this.unidir = unidirectional;
    }

    @Deprecated
    public RFSettings(IndividualAddress device, byte[] domain, byte[] serialNumber, boolean unidirectional) {
        this(device, domain, SerialNumber.from(serialNumber), unidirectional);
    }

    public final synchronized void setDomainAddress(byte[] domain) {
        if (domain == null) {
            this.doa = broadcastDomain;
        } else {
            if (domain.length != 6) {
                throw new KNXIllegalArgumentException("invalid length of domain address");
            }
            this.doa = (byte[])domain.clone();
        }
    }

    public final synchronized byte[] getDomainAddress() {
        return (byte[])this.doa.clone();
    }

    @Deprecated
    public final byte[] getSerialNumber() {
        return this.sno.array();
    }

    public final SerialNumber serialNumber() {
        return this.sno;
    }

    public final boolean isUnidirectional() {
        return this.unidir;
    }

    @Override
    public int getMedium() {
        return 16;
    }

    @Override
    public String toString() {
        return super.toString() + " domain 0x" + DataUnitBuilder.toHex(this.doa, null) + " s/n " + this.sno + (this.unidir ? " unidirectional" : "");
    }
}

