/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.link.medium;

import java.io.ByteArrayInputStream;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.link.medium.RawFrameBase;

public class TP1LData
extends RawFrameBase {
    private static final int MIN_LENGTH = 7;

    public TP1LData(byte[] data, int offset) throws KNXFormatException {
        ByteArrayInputStream is = this.asStream(data, offset, 7, "L-data");
        int len = this.init(is, false);
        if (this.ext && len == 255) {
            throw new KNXFormatException("escape-code in length field not supported");
        }
        this.tpdu = new byte[len + 1];
        if (is.read(this.tpdu, 0, this.tpdu.length) != this.tpdu.length) {
            throw new KNXFormatException("data too short for L-data TPDU");
        }
        this.fcs = is.read();
    }

    @Override
    public String toString() {
        return super.toString() + ", tpdu " + DataUnitBuilder.toHex(this.tpdu, " ");
    }
}

