/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.link.medium;

import java.io.ByteArrayInputStream;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.link.medium.RawFrameBase;

public class TP1LPollData
extends RawFrameBase {
    private static final int MIN_LENGTH = 7;
    private final int expData;

    public TP1LPollData(byte[] data, int offset) throws KNXFormatException {
        int len;
        ByteArrayInputStream is = this.asStream(data, offset, 7, "L-polldata");
        int ctrl = is.read();
        if (ctrl != 240) {
            throw new KNXFormatException("invalid control field", ctrl);
        }
        this.type = 1;
        this.p = Priority.get(ctrl >> 2 & 3);
        int addr = is.read() << 8 | is.read();
        this.src = new IndividualAddress(addr);
        addr = is.read() << 8 | is.read();
        this.dst = new GroupAddress(addr);
        this.expData = len = is.read() & 0xF;
        this.fcs = is.read();
        if (this.expData <= is.available()) {
            this.tpdu = new byte[this.expData];
            is.read(this.tpdu, 0, this.expData);
        }
    }

    public final int getExpectedDataLength() {
        return this.expData;
    }

    @Override
    public String toString() {
        return super.toString() + " exp. polldata " + this.expData;
    }
}

