/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.log;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.log.AsyncLogger;

public final class LogService {
    private static final String loggerThreadName = "Calimero Async Logging";
    private static final ExecutorService dispatcher = Executors.newFixedThreadPool(1, r -> {
        Thread t = Executors.defaultThreadFactory().newThread(r);
        t.setName(loggerThreadName);
        t.setDaemon(true);
        return t;
    });

    private LogService() {
    }

    public static Logger getLogger(String name) {
        return LoggerFactory.getLogger((String)name);
    }

    public static Logger getAsyncLogger(String name) {
        return new AsyncLogger(LogService.getLogger(name));
    }

    static void async(Logger l, LogLevel level, String msg, Throwable t) {
        LogService.async(l, level, (Marker)null, "{}", msg, t);
    }

    static void async(Logger l, LogLevel level, Marker m, String msg, Throwable t) {
        LogService.async(l, level, (Marker)null, "{}", msg, t);
    }

    static void async(Logger l, LogLevel level, String format, Object ... o) {
        LogService.async(l, level, null, format, o);
    }

    static void async(Logger l, LogLevel level, Marker m, String format, Object ... o) {
        if (!LogService.isEnabled(l, level)) {
            return;
        }
        Thread thread = Thread.currentThread();
        dispatcher.execute(() -> {
            Thread logger = Thread.currentThread();
            logger.setName(thread.getName());
            LogService.log(l, level, m, format, o);
            logger.setName(loggerThreadName);
        });
    }

    public static void log(Logger logger, LogLevel level, String format, Object ... arguments) {
        LogService.log(logger, level, (Marker)null, format, arguments);
    }

    private static void log(Logger logger, LogLevel level, Marker marker, String format, Object ... o) {
        switch (level) {
            case DEBUG: {
                logger.debug(marker, format, o);
                break;
            }
            case TRACE: {
                logger.trace(marker, format, o);
                break;
            }
            case INFO: {
                logger.info(marker, format, o);
                break;
            }
            case WARN: {
                logger.warn(marker, format, o);
                break;
            }
            case ERROR: {
                logger.error(marker, format, o);
            }
        }
    }

    private static boolean isEnabled(Logger logger, LogLevel level) {
        switch (level) {
            case TRACE: {
                return logger.isTraceEnabled();
            }
            case DEBUG: {
                return logger.isDebugEnabled();
            }
            case INFO: {
                return logger.isInfoEnabled();
            }
            case WARN: {
                return logger.isWarnEnabled();
            }
            case ERROR: {
                return logger.isErrorEnabled();
            }
        }
        throw new KNXIllegalArgumentException("unknown log level");
    }

    public static enum LogLevel {
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

