/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.mgmt;

import java.io.Serializable;

public final class Description {
    private final int oindex;
    private final int otype;
    private final int objectInstance;
    private final int id;
    private final int pindex;
    private final int maxElems;
    private final int currElems;
    private int pdt;
    private final int rLevel;
    private final int wLevel;
    private final boolean write;

    static Description of(int objectIndex, byte[] data) {
        return new Description(true, objectIndex, (byte[])data.clone());
    }

    public Description(int objType, byte[] data) {
        this(objType, 0, data);
    }

    public Description(int objType, int currentElements, byte[] data) {
        this.otype = objType;
        this.objectInstance = 0;
        this.oindex = data[0] & 0xFF;
        this.id = data[1] & 0xFF;
        this.pindex = data[2] & 0xFF;
        this.write = (data[3] & 0x80) == 128;
        this.pdt = data[3] & 0x3F;
        this.maxElems = (data[4] & 0xFF) << 8 | data[5] & 0xFF;
        this.currElems = currentElements;
        this.rLevel = (data[6] & 0xFF) >> 4;
        this.wLevel = data[6] & 0xF;
    }

    public Description(int objIndex, int objType, int pid, int propIndex, int pdt, boolean writeEnabled, int currentElements, int maxElements, int readLevel, int writeLevel) {
        this.otype = objType;
        this.objectInstance = 0;
        this.oindex = objIndex;
        this.id = pid;
        this.pindex = propIndex;
        this.pdt = pdt;
        this.write = writeEnabled;
        this.currElems = currentElements;
        this.maxElems = maxElements;
        this.rLevel = readLevel;
        this.wLevel = writeLevel;
    }

    private Description(boolean ext, int objectIndex, byte[] data) {
        this.oindex = objectIndex;
        this.otype = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
        this.objectInstance = (data[2] & 0xFF) << 4 | (data[3] & 0xF0) >> 4;
        this.id = (data[3] & 0xF) << 8 | data[4] & 0xFF;
        this.pdt = data[5] >> 4 & 0xF;
        this.pindex = (data[5] & 0xF) << 8 | data[6] & 0xFF;
        int dptMain = (data[7] & 0xFF) << 8 | data[8] & 0xFF;
        int dptSub = (data[9] & 0xFF) << 8 | data[10] & 0xFF;
        String dpt = dptMain + "." + dptSub;
        this.write = (data[11] & 0x80) == 128;
        this.pdt = data[11] & 0x2F;
        this.maxElems = (data[12] & 0xFF) << 8 | data[13] & 0xFF;
        this.rLevel = (data[14] & 0xF0) >> 4;
        this.wLevel = data[14] & 0xF;
        this.currElems = 0;
    }

    public int getObjectIndex() {
        return this.oindex;
    }

    public int getObjectType() {
        return this.otype;
    }

    public int getPropIndex() {
        return this.pindex;
    }

    public int getPID() {
        return this.id;
    }

    public int getPDT() {
        return this.pdt;
    }

    public int getCurrentElements() {
        return this.currElems;
    }

    public int getMaxElements() {
        return this.maxElems;
    }

    public int getReadLevel() {
        return this.rLevel;
    }

    public int getWriteLevel() {
        return this.wLevel;
    }

    public boolean isWriteEnabled() {
        return this.write;
    }

    public String toString() {
        return "OT " + this.otype + " OI " + this.oindex + " PID " + this.id + " PI " + this.pindex + " PDT " + (Serializable)(this.pdt == -1 ? "-" : Integer.valueOf(this.pdt)) + ", " + this.currElems + " elements (max " + this.maxElems + "), r/w access " + this.rLevel + "/" + (Serializable)(this.wLevel == -1 ? "-" : Integer.valueOf(this.wLevel)) + (this.write ? " write-enabled" : " read-only");
    }

    public byte[] toByteArray() {
        byte[] data = new byte[7];
        data[0] = (byte)this.oindex;
        data[1] = (byte)this.id;
        data[2] = (byte)this.pindex;
        data[3] = (byte)(this.write ? 128 : 0);
        data[3] = (byte)(data[3] | this.pdt & 0x3F);
        data[4] = (byte)(this.maxElems >> 8);
        data[5] = (byte)this.maxElems;
        data[6] = (byte)(this.rLevel << 4 | this.wLevel & 0xF);
        return data;
    }

    static int parseCurrentElements(byte[] data) {
        int elems = 0;
        for (int i = 0; i < data.length; ++i) {
            elems = elems << 8 | data[i] & 0xFF;
        }
        return elems;
    }

    void setPDT(int type) {
        this.pdt = type;
    }
}

