/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.mgmt;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.mgmt.TransportLayer;

public class Destination
implements AutoCloseable {
    private static final int TIMEOUT = 6000;
    private static final ScheduledThreadPoolExecutor disconnect = new ScheduledThreadPoolExecutor(0);
    static final int USER_REQUEST = 0;
    static final int REMOTE_ENDPOINT = 1;
    static final int LOCAL_ENDPOINT = 2;
    volatile int disconnectedBy = -1;
    private final TransportLayer tl;
    private final IndividualAddress addr;
    private volatile State state = State.Disconnected;
    private int seqRcv;
    private int seqSend;
    private final boolean co;
    private final boolean alive;
    private final boolean verify;
    private volatile int[] interfaceObjectList;
    private volatile int maxApduLength;

    public Destination(AggregatorProxy aggregator, IndividualAddress remote, boolean connectionOriented) {
        this(aggregator, remote, connectionOriented, false, false);
    }

    public Destination(AggregatorProxy aggregator, IndividualAddress remote, boolean connectionOriented, boolean keepAlive, boolean verifyMode) {
        this.tl = aggregator.aggr;
        aggregator.setDestination(this);
        this.addr = remote;
        this.co = connectionOriented;
        this.alive = this.co ? keepAlive : false;
        this.verify = verifyMode;
    }

    public final IndividualAddress getAddress() {
        return this.addr;
    }

    public final State getState() {
        return this.state;
    }

    public final boolean isConnectionOriented() {
        return this.co;
    }

    public final boolean isKeepAlive() {
        return this.alive;
    }

    public final boolean isVerifyMode() {
        return this.verify;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Destination destination = this;
        synchronized (destination) {
            if (this.state == State.Destroyed) {
                return;
            }
            if (this.state != State.Disconnected) {
                try {
                    this.tl.disconnect(this);
                }
                catch (KNXLinkClosedException kNXLinkClosedException) {
                    // empty catch block
                }
            }
            this.setState(State.Destroyed, null);
        }
        this.tl.destroyDestination(this);
    }

    @Override
    public void close() {
        this.destroy();
    }

    public String toString() {
        String s = "destination " + this.addr + " (" + this.tl.getName() + ") ";
        if (this.state == State.Destroyed) {
            return s + this.getStateString();
        }
        s = this.co ? s + this.getStateString() + ", conn.-oriented," + (this.alive ? "" : " no") + " keep-alive, " : s + "connectionless, ";
        return s + (this.verify ? "" : "no") + " verify mode";
    }

    Optional<int[]> interfaceObjectList() {
        int[] ioList = this.interfaceObjectList;
        return ioList == null ? Optional.empty() : Optional.of((int[])ioList.clone());
    }

    void setInterfaceObjectList(int[] ioList) {
        this.interfaceObjectList = (int[])ioList.clone();
    }

    final Optional<Integer> maxApduLength() {
        int max = this.maxApduLength;
        return max == 0 ? Optional.empty() : Optional.of(max);
    }

    final void maxApduLength(int max) {
        this.maxApduLength = max;
    }

    int getDisconnectedBy() {
        return this.disconnectedBy;
    }

    private String getStateString() {
        return this.state.name();
    }

    private synchronized void setState(State newState, Runnable notify) {
        if (this.state == State.Destroyed) {
            return;
        }
        this.state = newState;
        if (this.state == State.Connecting) {
            this.seqSend = 0;
            this.seqRcv = 0;
        } else if (this.state == State.OpenIdle) {
            this.restartTimer(notify);
        } else if (this.state == State.OpenWait) {
            this.restartTimer(notify);
        } else if (this.state == State.Disconnected) {
            Destination.remove(notify);
            this.seqSend = 0;
            this.seqRcv = 0;
        } else if (this.state == State.Destroyed && notify != null) {
            Destination.remove(notify);
        }
    }

    private synchronized void restartTimer(Runnable notify) {
        if (!this.co) {
            throw new IllegalStateException("no timer if not connection oriented");
        }
        if (this.state == State.Destroyed) {
            return;
        }
        Destination.remove(notify);
        ((AggregatorProxy)notify).future = disconnect.schedule(notify, 6000L, TimeUnit.MILLISECONDS);
    }

    private static void remove(Runnable notify) {
        Future<?> future = ((AggregatorProxy)notify).future;
        future.cancel(false);
    }

    public static final class AggregatorProxy
    implements Runnable {
        private final TransportLayer aggr;
        private Destination d;
        Future<?> future = CompletableFuture.completedFuture(Void.TYPE);

        public AggregatorProxy(TransportLayer aggregator) {
            this.aggr = aggregator;
        }

        public Destination getDestination() {
            return this.d;
        }

        public synchronized int getSeqReceive() {
            return this.d.seqRcv;
        }

        public synchronized void incSeqReceive() {
            ++this.d.seqRcv;
            this.d.seqRcv &= 0xF;
        }

        public synchronized int getSeqSend() {
            return this.d.seqSend;
        }

        public synchronized void incSeqSend() {
            ++this.d.seqSend;
            this.d.seqSend &= 0xF;
        }

        public void restartTimeout() {
            this.d.restartTimer(this);
        }

        public void setState(State newState) {
            this.d.setState(newState, this);
        }

        void setDestination(Destination dst) {
            this.d = dst;
        }

        @Override
        public void run() {
            if (this.d.alive) {
                return;
            }
            State state = this.d.getState();
            if (state != State.Disconnected && state != State.Destroyed) {
                try {
                    this.aggr.disconnect(this.d);
                }
                catch (KNXLinkClosedException kNXLinkClosedException) {
                    // empty catch block
                }
            }
        }
    }

    public static enum State {
        Destroyed,
        Disconnected,
        Connecting,
        OpenIdle,
        OpenWait;

    }
}

