/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.mgmt;

import java.net.InetSocketAddress;
import java.util.function.Consumer;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.cemi.CEMIDevMgmt;
import tuwien.auto.calimero.knxnetip.Connection;
import tuwien.auto.calimero.knxnetip.KNXConnectionClosedException;
import tuwien.auto.calimero.knxnetip.KNXnetIPConnection;
import tuwien.auto.calimero.knxnetip.KNXnetIPDevMgmt;
import tuwien.auto.calimero.knxnetip.SecureConnection;
import tuwien.auto.calimero.mgmt.LocalDeviceManagement;

public class LocalDeviceManagementIp
extends LocalDeviceManagement {
    private final KNXnetIPConnection conn;

    public static LocalDeviceManagementIp newAdapter(Connection connection, Consumer<CloseEvent> adapterClosed) throws KNXException, InterruptedException {
        KNXnetIPDevMgmt mgmt = new KNXnetIPDevMgmt(connection);
        return new LocalDeviceManagementIp(mgmt, adapterClosed, false);
    }

    public static LocalDeviceManagementIp newAdapter(InetSocketAddress localEP, InetSocketAddress serverCtrlEP, boolean useNat, boolean queryWriteEnable, Consumer<CloseEvent> adapterClosed) throws KNXException, InterruptedException {
        return new LocalDeviceManagementIp(localEP, serverCtrlEP, useNat, adapterClosed, queryWriteEnable);
    }

    public static LocalDeviceManagementIp newSecureAdapter(Connection.SecureSession session, Consumer<CloseEvent> adapterClosed) throws KNXException, InterruptedException {
        KNXnetIPConnection mgmt = SecureConnection.newDeviceManagement(session);
        return new LocalDeviceManagementIp(mgmt, adapterClosed, false);
    }

    public static LocalDeviceManagementIp newSecureAdapter(InetSocketAddress localEP, InetSocketAddress serverCtrlEP, boolean useNat, byte[] deviceAuthCode, byte[] userKey, Consumer<CloseEvent> adapterClosed) throws KNXException, InterruptedException {
        KNXnetIPConnection mgmt = SecureConnection.newDeviceManagement(localEP, serverCtrlEP, useNat, deviceAuthCode, userKey);
        return new LocalDeviceManagementIp(mgmt, adapterClosed, false);
    }

    protected LocalDeviceManagementIp(InetSocketAddress localEP, InetSocketAddress serverCtrlEP, boolean useNat, Consumer<CloseEvent> adapterClosed, boolean queryWriteEnable) throws KNXException, InterruptedException {
        this(LocalDeviceManagementIp.create(localEP, serverCtrlEP, useNat), adapterClosed, queryWriteEnable);
    }

    LocalDeviceManagementIp(KNXnetIPConnection mgmt, Consumer<CloseEvent> adapterClosed, boolean queryWriteEnable) throws KNXException, InterruptedException {
        super(mgmt, adapterClosed, queryWriteEnable);
        this.conn = mgmt;
        this.conn.addConnectionListener(new LocalDeviceManagement.KNXListenerImpl());
        this.init();
    }

    public void reset() throws KNXConnectionClosedException, KNXTimeoutException, InterruptedException {
        this.send(new CEMIDevMgmt(241), (Object)KNXnetIPConnection.BlockingMode.WaitForAck);
    }

    @Override
    public String getName() {
        InetSocketAddress remote = this.conn.getRemoteAddress();
        return "Local-DM " + remote.getAddress().getHostAddress() + ":" + remote.getPort();
    }

    @Override
    protected void send(CEMIDevMgmt frame, Object mode) throws KNXTimeoutException, KNXConnectionClosedException, InterruptedException {
        this.conn.send(frame, (KNXnetIPConnection.BlockingMode)((Object)mode));
    }

    private static KNXnetIPDevMgmt create(InetSocketAddress localEP, InetSocketAddress serverCtrlEP, boolean useNat) throws KNXException, InterruptedException {
        return new KNXnetIPDevMgmt(localEP, serverCtrlEP, useNat);
    }
}

